/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.reconnect;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ActivityEdgeHelper;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDefaultNameProvider;
import org.eclipse.papyrus.uml.domain.services.reconnect.IDomainBasedEdgeReconnectTargetBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeReconnectTargetBehaviorProvider
implements IDomainBasedEdgeReconnectTargetBehaviorProvider {
    private final IViewQuerier representationQuery;

    public ElementDomainBasedEdgeReconnectTargetBehaviorProvider(IViewQuerier representationQuery) {
        this.representationQuery = Objects.requireNonNull(representationQuery);
    }

    @Override
    public CheckStatus reconnectTarget(EObject elementToReconnect, EObject oldTarget, EObject newTarget, Object newTargetView) {
        if (elementToReconnect == null || oldTarget == null || newTarget == null) {
            return CheckStatus.no(MessageFormat.format("Invalid input for reconnection (element ={0} oldTarget ={1} newTarget = {2})", elementToReconnect, oldTarget, newTarget));
        }
        return (CheckStatus)new ReconnectTargetBehaviorProviderSwitch(this.representationQuery, oldTarget, newTarget, newTargetView).doSwitch(elementToReconnect);
    }

    static class ReconnectTargetBehaviorProviderSwitch
    extends UMLSwitch<CheckStatus> {
        private final IViewQuerier representationQuery;
        private final EObject oldTarget;
        private final EObject newTarget;
        private final Object newTargetView;

        ReconnectTargetBehaviorProviderSwitch(IViewQuerier representationQuery, EObject oldTarget, EObject newTarget, Object newTargetView) {
            this.representationQuery = representationQuery;
            this.oldTarget = oldTarget;
            this.newTarget = newTarget;
            this.newTargetView = newTargetView;
        }

        public CheckStatus caseActivityEdge(ActivityEdge activityEdge) {
            activityEdge.setTarget((ActivityNode)this.newTarget);
            ActivityEdgeHelper activityEdgeHelper = new ActivityEdgeHelper();
            activityEdgeHelper.updateActivityEdgeContainer(activityEdge);
            activityEdgeHelper.setInPartition(activityEdge);
            return CheckStatus.YES;
        }

        public CheckStatus caseAssociation(Association association) {
            Classifier newType = (Classifier)this.newTarget;
            Property sourceProperty = (Property)association.getMemberEnds().get(0);
            sourceProperty.setType((Type)newType);
            Property targetProperty = (Property)association.getMemberEnds().get(1);
            if (!association.getOwnedEnds().contains((Object)targetProperty) && this.newTarget instanceof StructuredClassifier) {
                ((StructuredClassifier)this.newTarget).getOwnedAttributes().add((Object)targetProperty);
            }
            return CheckStatus.YES;
        }

        public CheckStatus caseComponentRealization(ComponentRealization componentRealization) {
            componentRealization.getSuppliers().remove((Object)this.oldTarget);
            Component newComponent = (Component)this.newTarget;
            componentRealization.setAbstraction(newComponent);
            return CheckStatus.YES;
        }

        public CheckStatus caseConnector(Connector connector) {
            Object targetVisualParent = this.representationQuery.getVisualParent(this.newTargetView);
            if (targetVisualParent != null) {
                EObject visualTargetParent = this.representationQuery.getSemanticElement(targetVisualParent);
                ConnectorEnd connectorEnd = (ConnectorEnd)connector.getEnds().get(1);
                connectorEnd.setRole((ConnectableElement)this.newTarget);
                if (visualTargetParent instanceof Property) {
                    Property targetProperty = (Property)visualTargetParent;
                    connectorEnd.setPartWithPort(targetProperty);
                } else {
                    connectorEnd.setPartWithPort(null);
                }
                return CheckStatus.YES;
            }
            return (CheckStatus)super.caseConnector(connector);
        }

        public CheckStatus caseDependency(Dependency dependency) {
            dependency.getSuppliers().remove((Object)this.oldTarget);
            dependency.getSuppliers().add((Object)((NamedElement)this.newTarget));
            return CheckStatus.YES;
        }

        public CheckStatus caseDeployment(Deployment deployment) {
            deployment.setLocation((DeploymentTarget)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseExtend(Extend extend) {
            extend.setExtendedCase((UseCase)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseExtension(Extension extension) {
            String oldName = extension.getName();
            try {
                extension.setName(null);
                ElementDefaultNameProvider elementDefaultNameProvider = new ElementDefaultNameProvider();
                String deducedName = elementDefaultNameProvider.getDefaultName((NamedElement)extension, extension.eContainer());
                Stereotype sourceType = extension.getStereotype();
                if (sourceType instanceof Stereotype) {
                    EList attributes = sourceType.getOwnedAttributes();
                    for (Property property : attributes) {
                        if (property.getAssociation() != extension) continue;
                        property.setType((Type)this.newTarget);
                        property.setName("base_" + ((NamedElement)this.newTarget).getName());
                        break;
                    }
                    if (oldName.contains(deducedName) && oldName.indexOf(deducedName) == 0) {
                        oldName = oldName.substring(deducedName.length());
                        try {
                            extension.setName(elementDefaultNameProvider.getDefaultName((NamedElement)extension, extension.eContainer()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            finally {
                if (extension.getName() == null) {
                    extension.setName(oldName);
                }
            }
            return CheckStatus.YES;
        }

        public CheckStatus caseGeneralization(Generalization generalization) {
            generalization.setGeneral((Classifier)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseInclude(Include include) {
            include.setAddition((UseCase)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseInformationFlow(InformationFlow informationFlow) {
            informationFlow.getInformationTargets().remove((Object)this.oldTarget);
            informationFlow.getInformationTargets().add((Object)((NamedElement)this.newTarget));
            return CheckStatus.YES;
        }

        public CheckStatus caseInterfaceRealization(InterfaceRealization object) {
            object.setContract((Interface)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseManifestation(Manifestation manifestation) {
            manifestation.setUtilizedElement((PackageableElement)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseMessage(Message message) {
            MessageEnd receiveEvent = message.getReceiveEvent();
            if (receiveEvent instanceof MessageOccurrenceSpecification && this.newTarget instanceof Lifeline && this.oldTarget instanceof Lifeline) {
                MessageOccurrenceSpecification os = (MessageOccurrenceSpecification)receiveEvent;
                os.getCovereds().clear();
                os.getCovereds().add((Object)((Lifeline)this.newTarget));
            }
            return CheckStatus.YES;
        }

        public CheckStatus casePackageImport(PackageImport packImport) {
            packImport.setImportedPackage((Package)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus casePackageMerge(PackageMerge object) {
            object.setMergedPackage((Package)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseSubstitution(Substitution substitution) {
            substitution.setContract((Classifier)this.newTarget);
            return CheckStatus.YES;
        }

        public CheckStatus caseTransition(Transition transition) {
            transition.setTarget((Vertex)this.newTarget);
            return CheckStatus.YES;
        }
    }
}

