/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.papyrus.infra.constraints.ConstraintsPackage;
import org.eclipse.papyrus.infra.properties.contexts.Annotatable;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextsSwitch;
import org.eclipse.papyrus.infra.properties.ui.UiPackage;
import org.eclipse.papyrus.views.properties.toolsmiths.editor.actions.ToggleAnnotationsAction;

public class GetVisibleFeaturesQuery
implements IJavaQuery2<EObject, List<EReference>> {
    static Set<EReference> allExcludedReferences = new HashSet<EReference>();

    static {
        allExcludedReferences.add(ConstraintsPackage.Literals.DISPLAY_UNIT__CONSTRAINTS);
        allExcludedReferences.add(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
        allExcludedReferences.add(ContextsPackage.Literals.CONTEXT__DEPENDENCIES);
        allExcludedReferences.add(ContextsPackage.Literals.DATA_CONTEXT_ROOT__MODEL_ELEMENT_FACTORY);
        allExcludedReferences.add(ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__PACKAGE);
        allExcludedReferences.add(ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__SUPERTYPES);
        allExcludedReferences.add(ContextsPackage.Literals.PROPERTY__CONTEXT_ELEMENT);
        allExcludedReferences.add(ContextsPackage.Literals.ABSTRACT_SECTION__TAB);
        allExcludedReferences.add(ContextsPackage.Literals.SECTION__OWNER);
        allExcludedReferences.add(ContextsPackage.Literals.SECTION__VIEWS);
        allExcludedReferences.add(ContextsPackage.Literals.TAB__AFTER_TAB);
        allExcludedReferences.add(ContextsPackage.Literals.TAB__SECTIONS);
        allExcludedReferences.add(ContextsPackage.Literals.TAB__ALL_SECTIONS);
        allExcludedReferences.add(ContextsPackage.Literals.VIEW__CONTEXT);
        allExcludedReferences.add(ContextsPackage.Literals.VIEW__DATACONTEXTS);
        allExcludedReferences.add(ContextsPackage.Literals.ANNOTATION__ELEMENT);
        allExcludedReferences.add(ContextsPackage.Literals.ANNOTATION__REFERENCES);
        allExcludedReferences.add(UiPackage.Literals.COMPOSITE_WIDGET__WIDGET_TYPE);
        allExcludedReferences.add(UiPackage.Literals.UI_COMPONENT__ATTRIBUTES);
        allExcludedReferences.add(UiPackage.Literals.LAYOUT__LAYOUT_TYPE);
        allExcludedReferences.add(UiPackage.Literals.PROPERTY_EDITOR__PROPERTY);
        allExcludedReferences.add(UiPackage.Literals.PROPERTY_EDITOR__WIDGET_TYPE);
        allExcludedReferences.add(UiPackage.Literals.PROPERTY_EDITOR__UNRESOLVED_PROPERTY);
        allExcludedReferences.add(UiPackage.Literals.STANDARD_WIDGET__WIDGET_TYPE);
    }

    public List<EReference> evaluate(EObject source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        if (source.eClass().getEPackage() == ContextsPackage.eINSTANCE) {
            return (List)new ContextsSwitch<List<EReference>>(){

                public List<EReference> caseContext(Context object) {
                    return GetVisibleFeaturesQuery.this.filter(object.eClass(), GetVisibleFeaturesQuery.this.filterContextReferences(object));
                }

                public List<EReference> caseAnnotatable(Annotatable object) {
                    return GetVisibleFeaturesQuery.this.filter(object.eClass(), GetVisibleFeaturesQuery.this.filterAnnotationReferences(object));
                }

                public List<EReference> defaultCase(EObject object) {
                    return GetVisibleFeaturesQuery.this.filter(object.eClass(), ref -> true);
                }
            }.doSwitch(source);
        }
        if (source.eClass().getEPackage() == UiPackage.eINSTANCE) {
            return this.filter(source.eClass(), ref -> true);
        }
        return Collections.emptyList();
    }

    protected Predicate<EReference> filterContextReferences(Context object) {
        return ref -> {
            if (ref == ContextsPackage.Literals.CONTEXT__PROTOTYPE) {
                return object.getPrototype() != null;
            }
            if (ref == ContextsPackage.Literals.ANNOTATABLE__ANNOTATIONS) {
                return ToggleAnnotationsAction.showAnnotations;
            }
            return true;
        };
    }

    protected Predicate<EReference> filterAnnotationReferences(Annotatable object) {
        return ref -> {
            if (ref == ContextsPackage.Literals.ANNOTATABLE__ANNOTATIONS) {
                return ToggleAnnotationsAction.showAnnotations;
            }
            return true;
        };
    }

    private List<EReference> filter(EClass eClass, Predicate<EReference> filter) {
        return eClass.getEAllReferences().stream().filter(ref -> !allExcludedReferences.contains(ref)).filter(filter).collect(Collectors.toList());
    }
}

