/**
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.ICellAxisWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Cell</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl.CellImpl#getColumnWrapper <em>Column Wrapper</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl.CellImpl#getRowWrapper <em>Row Wrapper</em>}</li>
 * <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablecell.impl.CellImpl#getProblems <em>Problems</em>}</li>
 * </ul>
 *
 * @generated not
 */
public class CellImpl extends org.eclipse.emf.cdo.ecore.impl.EModelElementImpl implements Cell {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected CellImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattablecellPackage.Literals.CELL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Decrease the generated ESTATIC_FEATURE_COUNT from 1 to 0 because the inherited
	 * EModelElement.eAnnotations feature is implemented dynamically, too.
	 * <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	protected static final int ESTATIC_FEATURE_COUNT = 0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected int eStaticFeatureCount() {
		return ESTATIC_FEATURE_COUNT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ICellAxisWrapper getColumnWrapper() {
		return (ICellAxisWrapper) eDynamicGet(NattablecellPackage.CELL__COLUMN_WRAPPER - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.CELL__COLUMN_WRAPPER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public NotificationChain basicSetColumnWrapper(ICellAxisWrapper newColumnWrapper, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newColumnWrapper, NattablecellPackage.CELL__COLUMN_WRAPPER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setColumnWrapper(ICellAxisWrapper newColumnWrapper) {
		eDynamicSet(NattablecellPackage.CELL__COLUMN_WRAPPER - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.CELL__COLUMN_WRAPPER, newColumnWrapper);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public ICellAxisWrapper getRowWrapper() {
		return (ICellAxisWrapper) eDynamicGet(NattablecellPackage.CELL__ROW_WRAPPER - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.CELL__ROW_WRAPPER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public NotificationChain basicSetRowWrapper(ICellAxisWrapper newRowWrapper, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject) newRowWrapper, NattablecellPackage.CELL__ROW_WRAPPER, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setRowWrapper(ICellAxisWrapper newRowWrapper) {
		eDynamicSet(NattablecellPackage.CELL__ROW_WRAPPER - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.CELL__ROW_WRAPPER, newRowWrapper);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Problem> getProblems() {
		return (EList<Problem>) eDynamicGet(NattablecellPackage.CELL__PROBLEMS - ESTATIC_FEATURE_COUNT, NattablecellPackage.Literals.CELL__PROBLEMS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case NattablecellPackage.CELL__COLUMN_WRAPPER:
			return basicSetColumnWrapper(null, msgs);
		case NattablecellPackage.CELL__ROW_WRAPPER:
			return basicSetRowWrapper(null, msgs);
		case NattablecellPackage.CELL__PROBLEMS:
			return ((InternalEList<?>) getProblems()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case NattablecellPackage.CELL__COLUMN_WRAPPER:
			return getColumnWrapper();
		case NattablecellPackage.CELL__ROW_WRAPPER:
			return getRowWrapper();
		case NattablecellPackage.CELL__PROBLEMS:
			return getProblems();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case NattablecellPackage.CELL__COLUMN_WRAPPER:
			setColumnWrapper((ICellAxisWrapper) newValue);
			return;
		case NattablecellPackage.CELL__ROW_WRAPPER:
			setRowWrapper((ICellAxisWrapper) newValue);
			return;
		case NattablecellPackage.CELL__PROBLEMS:
			getProblems().clear();
			getProblems().addAll((Collection<? extends Problem>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case NattablecellPackage.CELL__COLUMN_WRAPPER:
			setColumnWrapper((ICellAxisWrapper) null);
			return;
		case NattablecellPackage.CELL__ROW_WRAPPER:
			setRowWrapper((ICellAxisWrapper) null);
			return;
		case NattablecellPackage.CELL__PROBLEMS:
			getProblems().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case NattablecellPackage.CELL__COLUMN_WRAPPER:
			return getColumnWrapper() != null;
		case NattablecellPackage.CELL__ROW_WRAPPER:
			return getRowWrapper() != null;
		case NattablecellPackage.CELL__PROBLEMS:
			return !getProblems().isEmpty();
		}
		return super.eIsSet(featureID);
	}
} // CellImpl
