/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.search.internal.ui.query;

import java.util.regex.Pattern;

public class PatternUtil {
    private static final String WILDCARD = ".*";

    private PatternUtil() {
    }

    public static String wrap(String searchText, boolean caseSensitive, boolean regularExpression, boolean allStringAttributes) {
        String result = caseSensitive ? (!regularExpression ? (allStringAttributes ? String.format("%s%s%s", WILDCARD, Pattern.quote(searchText), WILDCARD) : null) : PatternUtil.ensureRegexSubstring(searchText)) : (!regularExpression ? String.format("(?i)%s%s%s", WILDCARD, Pattern.quote(searchText), WILDCARD) : String.format("(?i)%s", PatternUtil.ensureRegexSubstring(searchText)));
        return result;
    }

    private static String ensureRegexSubstring(String regex) {
        String result = regex;
        if (!result.startsWith(WILDCARD)) {
            result = WILDCARD + result;
        }
        if (!result.endsWith(WILDCARD)) {
            result = String.valueOf(result) + WILDCARD;
        }
        return result;
    }

    public static String wrapForFind(String searchText, boolean caseSensitive, boolean regularExpression) {
        String result = caseSensitive ? (!regularExpression ? Pattern.quote(searchText) : searchText) : (!regularExpression ? String.format("(?i)%s", Pattern.quote(searchText)) : String.format("(?i)%s", searchText));
        return result;
    }
}

