/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.utils.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.moka.utils.helper.OpenPapyrusEditorRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtils {
    public static IEditorPart getEditorPart(EObject modelElement) {
        if (!modelElement.eIsProxy()) {
            return EditorUtils.getEditorPart(modelElement.eResource().getURI().toString());
        }
        IEditorPart part = null;
        FileEditorInput input = EditorUtils.getFileEditorInput(modelElement);
        OpenPapyrusEditorRunnable runnable = new OpenPapyrusEditorRunnable(input);
        Display.getDefault().syncExec((Runnable)runnable);
        part = runnable.getEditorPart();
        return part;
    }

    public static IEditorPart getEditorPart(String resourceURI) {
        String[] splitted = resourceURI.split("/");
        String resourceName = splitted[splitted.length - 1].replaceAll("\\.uml$", ".di");
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        IEditorPart part = null;
        int i = 0;
        while (i < windows.length && part == null) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length && part == null) {
                IEditorReference[] editorReferences = pages[j].getEditorReferences();
                int k = 0;
                while (k < editorReferences.length && part == null) {
                    String cddName;
                    IEditorReference ref = editorReferences[k];
                    IEditorPart cdd = ref.getEditor(false);
                    if (cdd instanceof IMultiDiagramEditor && (cddName = cdd.getEditorInput().getName()).equals(resourceName)) {
                        part = cdd;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (part == null) {
            FileEditorInput input = EditorUtils.getFileEditorInput(resourceURI);
            OpenPapyrusEditorRunnable runnable = new OpenPapyrusEditorRunnable(input);
            Display.getDefault().syncExec((Runnable)runnable);
            part = runnable.getEditorPart();
        }
        return part;
    }

    public static FileEditorInput getFileEditorInput(EObject modelElement) {
        EObject resolvedElement = modelElement;
        if (resolvedElement.eIsProxy()) {
            resolvedElement = EcoreUtil.resolve((EObject)modelElement, (ResourceSet)new ResourceSetImpl());
        }
        return EditorUtils.getFileEditorInput(resolvedElement.eResource().getURI().toString());
    }

    public static FileEditorInput getFileEditorInput(String resourceURI) {
        Resource newResource = new ResourceSetImpl().createResource(URI.createURI((String)resourceURI.replaceAll("\\.uml$", ".di")));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IFile modelElementIFile = (IFile)workspaceRoot.findMember(newResource.getURI().toPlatformString(true));
        if (modelElementIFile == null) {
            return null;
        }
        return new FileEditorInput(modelElementIFile);
    }
}

