/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.papyrus.moka.kernel.process.BaseProcess;
import org.eclipse.papyrus.moka.kernel.process.MQTTServerConfig;
import org.eclipse.papyrus.moka.kernel.process.MokaProcessStatus;

public class ServerMqttProcess
extends BaseProcess<Process>
implements ILaunchesListener2 {
    protected IOException exception = null;

    public ServerMqttProcess(ILaunch l) {
        super(l);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            if (this.process == null) {
                return 2;
            }
            return ((Process)this.process).exitValue();
        }
        throw new DebugException(null);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canTerminate() {
        if (this.process != null) {
            return ((Process)this.process).isAlive();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.process != null) {
            return !((Process)this.process).isAlive();
        }
        return true;
    }

    public void terminate() throws DebugException {
        if (this.process != null && ((Process)this.process).isAlive()) {
            ((Process)this.process).destroy();
            if (((Process)this.process).isAlive()) {
                ((Process)this.process).destroyForcibly();
            }
            this.setStatus(MokaProcessStatus.TERMINATED);
        }
    }

    @Override
    public void run() {
        block9: {
            File serverExecutable = new File(MQTTServerConfig.getMQTTServerPath());
            if (serverExecutable.exists() && serverExecutable.isFile()) {
                ProcessBuilder builder = new ProcessBuilder(new String[0]).inheritIO();
                ArrayList<String> commands = new ArrayList<String>();
                commands.add(serverExecutable.getAbsolutePath());
                commands.add("-v");
                commands.add("-p");
                commands.add(MQTTServerConfig.getMQTTServerPort());
                builder.command(commands);
                try {
                    try {
                        this.process = builder.start();
                    }
                    catch (IOException e) {
                        this.exception = e;
                        if (this.process != null) {
                            this.setStatus(MokaProcessStatus.RUNNING);
                            break block9;
                        }
                        this.setStatus(MokaProcessStatus.TERMINATED);
                    }
                }
                finally {
                    if (this.process != null) {
                        this.setStatus(MokaProcessStatus.RUNNING);
                    } else {
                        this.setStatus(MokaProcessStatus.TERMINATED);
                    }
                }
            }
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        Iterator<ILaunch> it = Arrays.asList(launches).iterator();
        while (it.hasNext()) {
            if (!it.next().equals(this.launch)) continue;
            try {
                this.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    public IOException getError() {
        return this.exception;
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }
}

