/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.presentation.control;

import java.util.Iterator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatedDiagramTree;
import org.eclipse.papyrus.moka.animation.presentation.data.IAnimationTreeNode;
import org.eclipse.swt.widgets.Display;

public class AnimatedDiagramTreeContentProvider
implements ITreeContentProvider {
    protected boolean pendingRefresh = false;
    protected TreeViewer viewer;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IAnimationTreeNode node;
        this.viewer = (TreeViewer)viewer;
        if (oldInput != null) {
            node = null;
            node = oldInput instanceof AnimatedDiagramTree ? ((AnimatedDiagramTree)oldInput).getRoot() : (IAnimationTreeNode)oldInput;
            this.removeListenerTo(node);
        }
        if (newInput != null) {
            node = null;
            node = newInput instanceof AnimatedDiagramTree ? ((AnimatedDiagramTree)newInput).getRoot() : (IAnimationTreeNode)newInput;
            this.addListenerTo(node);
        }
        this.pendingRefresh = false;
    }

    protected void addListenerTo(IAnimationTreeNode node) {
        node.addListener((IContentProvider)this);
        Iterator<IAnimationTreeNode> nodeIterator = node.getChildren().iterator();
        while (nodeIterator.hasNext()) {
            this.addListenerTo(nodeIterator.next());
        }
    }

    protected void removeListenerTo(IAnimationTreeNode node) {
        node.removeListener((IContentProvider)this);
        Iterator<IAnimationTreeNode> nodeIterator = node.getChildren().iterator();
        while (nodeIterator.hasNext()) {
            this.removeListenerTo(nodeIterator.next());
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AnimatedDiagramTree) {
            return new Object[]{((AnimatedDiagramTree)inputElement).getRoot()};
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof IAnimationTreeNode) {
            children = ((IAnimationTreeNode)parentElement).getChildren().toArray();
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof IAnimationTreeNode) {
            return ((IAnimationTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = true;
        if (element instanceof IAnimationTreeNode) {
            hasChildren = !((IAnimationTreeNode)element).getChildren().isEmpty();
        }
        return hasChildren;
    }

    public void requestRefresh() {
        if (!this.pendingRefresh) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer viewer = AnimatedDiagramTreeContentProvider.this.viewer;
                    viewer.refresh();
                    viewer.expandAll();
                }
            });
        }
    }

    public void dispose() {
    }
}

