/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.time;

import java.util.ArrayList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.engine.uml.debug.UMLDebugExecutionEngine;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.control.TimedExecutionLoop;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.DEScheduler;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.actions.CallbackAction;
import org.eclipse.papyrus.moka.engine.uml.time.scheduling.de.actions.DisplayCurrentTimeAction;
import org.eclipse.papyrus.moka.engine.uml.time.semantics.Loci.TimedExecutionFactory;
import org.eclipse.papyrus.moka.engine.uml.time.semantics.Loci.TimedLocus;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.IExecutor;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLRootTaskExecution;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.scheduling.control.ExecutionController;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionController;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionLoop;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IScheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.control.Scheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.papyrus.moka.pscs.loci.CS_Executor;
import org.eclipse.uml2.uml.Element;

public class UMLTimedExecutionEngine
extends UMLDebugExecutionEngine {
    protected double getStopTime() {
        return -1.0;
    }

    protected void initDEScheduler() {
        DEScheduler.init((double)this.getStopTime());
    }

    protected void doPreRunActions() {
        DEScheduler.getInstance().pushPreStepAction((CallbackAction)new DisplayCurrentTimeAction());
    }

    protected void doPostRunActions() {
    }

    public ILocus createLocus() {
        TimedLocus locus = new TimedLocus();
        locus.setExecutor((IExecutor)new CS_Executor());
        locus.setFactory((IExecutionFactory)new TimedExecutionFactory());
        return locus;
    }

    public IExecutionController createController() {
        ExecutionController controller = new ExecutionController();
        controller.setExecutionLoop((IExecutionLoop)new TimedExecutionLoop());
        return controller;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(SubMonitor monitor) throws ExecutionEngineException {
        EObject executionSource = this.configuration.getExecutionSource();
        if (!(executionSource instanceof Element)) throw new IllegalArgumentException("ExecutionSource in configuration must be instanceOf UML::Element");
        Element source = (Element)this.configuration.getExecutionSource();
        if (this.locus == null || source == null) return;
        IUMLRootTaskExecution rootExecution = this.rootTaskFactory.createRootExecution(source);
        if (rootExecution == null) throw new ExecutionEngineException(this.identifier, this.status, "Could not instantiate an execution from the specified element");
        rootExecution.setLocus(this.locus);
        rootExecution.setInputParameterValues(new ArrayList());
        if (!rootExecution.canExecute()) throw new ExecutionEngineException(this.identifier, this.status, "Could not start the execution from the specified model element");
        this.initDEScheduler();
        this.doPreRunActions();
        this.controller.getExecutionLoop().init((ITaskExecution)rootExecution, (IScheduler)new Scheduler());
        this.controller.start();
        this.doPostRunActions();
    }
}

