/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.scheduling;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.papyrus.moka.engine.uml.scheduling.UMLTaskExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLEventSendingExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionLoop;

public class UMLEventSendingTaskExecution
extends UMLTaskExecution
implements IUMLEventSendingExecution {
    protected IEventOccurrence event;
    protected ReentrantLock eventLock = new ReentrantLock(true);

    public UMLEventSendingTaskExecution(IExecutionLoop loop) {
        super(loop);
    }

    public void setEvent(IEventOccurrence eventOcccurence) {
        this.eventLock.lock();
        this.event = eventOcccurence;
        this.eventLock.unlock();
    }

    public boolean canExecute() {
        boolean canExecute = false;
        this.eventLock.lock();
        canExecute = this.event != null;
        this.eventLock.unlock();
        return canExecute;
    }

    public void sendEvent() {
        this.eventLock.lock();
        if (this.event != null) {
            this.event.doSend();
        }
        this.eventLock.unlock();
    }

    public void execute() {
        this.sendEvent();
    }

    @Override
    public IValue new_() {
        UMLEventSendingTaskExecution sendingExecution = new UMLEventSendingTaskExecution(this.executionLoop);
        this.eventLock.lock();
        sendingExecution.event = this.event;
        this.eventLock.unlock();
        return sendingExecution;
    }

    public String toString() {
        return "EventOccurrenceSendingExecution(" + this.event + ")";
    }

    @Override
    public void terminate() {
        this.eventLock.lock();
        this.event = null;
        this.eventLock.unlock();
    }

    @Override
    public IObject_ getContext() {
        IObject_ context = null;
        this.eventLock.lock();
        if (this.event != null) {
            context = this.event.getTarget().getReferent();
        }
        this.eventLock.unlock();
        return context;
    }
}

