/**
 * Copyright (c) 2019 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Context Filter Behavior</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration allows to define wich context must be used to find diagrams.
 * <!-- end-model-doc -->
 *
 * @see org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate.PapyrusGMFDocumentStructureTemplatePackage#getContextFilterBehavior()
 * @model
 * @generated
 */
public enum ContextFilterBehavior implements Enumerator {
	/**
	 * The '<em><b>SEMANTIC CONTEXT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (In Papyrus, this concept is called Diagram Root Element)
	 * <!-- end-model-doc -->
	 *
	 * @see #SEMANTIC_CONTEXT_VALUE
	 * @generated
	 * @ordered
	 */
	SEMANTIC_CONTEXT(0, "SEMANTIC_CONTEXT", "SEMANTIC_CONTEXT"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>GRAPHICAL CONTEXT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (In Papyrus, this concept is called Diagram Owner)
	 * <!-- end-model-doc -->
	 *
	 * @see #GRAPHICAL_CONTEXT_VALUE
	 * @generated
	 * @ordered
	 */
	GRAPHICAL_CONTEXT(1, "GRAPHICAL_CONTEXT", "GRAPHICAL_CONTEXT"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>BOTH</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * We look matching diagrams using the element as semantic context and graphical context.
	 * <!-- end-model-doc -->
	 *
	 * @see #BOTH_VALUE
	 * @generated
	 * @ordered
	 */
	BOTH(2, "BOTH", "BOTH"); //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>SEMANTIC CONTEXT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (In Papyrus, this concept is called Diagram Root Element)
	 * <!-- end-model-doc -->
	 *
	 * @see #SEMANTIC_CONTEXT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SEMANTIC_CONTEXT_VALUE = 0;

	/**
	 * The '<em><b>GRAPHICAL CONTEXT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (In Papyrus, this concept is called Diagram Owner)
	 * <!-- end-model-doc -->
	 *
	 * @see #GRAPHICAL_CONTEXT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GRAPHICAL_CONTEXT_VALUE = 1;

	/**
	 * The '<em><b>BOTH</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * We look matching diagrams using the element as semantic context and graphical context.
	 * <!-- end-model-doc -->
	 *
	 * @see #BOTH
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BOTH_VALUE = 2;

	/**
	 * An array of all the '<em><b>Context Filter Behavior</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static final ContextFilterBehavior[] VALUES_ARRAY = new ContextFilterBehavior[] {
			SEMANTIC_CONTEXT,
			GRAPHICAL_CONTEXT,
			BOTH,
	};

	/**
	 * A public read-only list of all the '<em><b>Context Filter Behavior</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public static final List<ContextFilterBehavior> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Context Filter Behavior</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param literal
	 *                    the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ContextFilterBehavior get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ContextFilterBehavior result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Context Filter Behavior</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param name
	 *                 the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ContextFilterBehavior getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ContextFilterBehavior result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Context Filter Behavior</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param value
	 *                  the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ContextFilterBehavior get(int value) {
		switch (value) {
		case SEMANTIC_CONTEXT_VALUE:
			return SEMANTIC_CONTEXT;
		case GRAPHICAL_CONTEXT_VALUE:
			return GRAPHICAL_CONTEXT;
		case BOTH_VALUE:
			return BOTH;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private ContextFilterBehavior(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // ContextFilterBehavior
