/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.tools.util.ClasspathHelper;
import org.eclipse.papyrus.infra.tools.util.Try;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.URIConverterService;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CommonURIUtils {
    private static final String BUNDLE_RESOURCE_SCHEME = "bundleresource";
    private static final String BUNDLE_CLASS_SCHEME = "bundleclass";
    private static final Pattern BUNDLE_RESOURCE_AUTHORITY_PATTERN = Pattern.compile("^\\d+");

    public static URI normalize(ResourceSet context, URI resourceURI) {
        return context == null ? resourceURI : URIConverterService.INSTANCE.normalize(resourceURI, context);
    }

    public static Try<String> getBundleName(EObject context, URI resourceURI) {
        return CommonURIUtils.getBundleName(context.eResource(), resourceURI);
    }

    public static Try<String> getBundleName(Resource context, URI resourceURI) {
        return CommonURIUtils.getBundleName(context.getResourceSet(), resourceURI);
    }

    public static Try<String> getBundleName(ResourceSet context, URI resourceURI) {
        String result = null;
        URI normalized = CommonURIUtils.normalize(context, resourceURI);
        if ((normalized.isPlatformPlugin() || normalized.isPlatformResource()) && normalized.segmentCount() > 1) {
            result = normalized.segment(1);
        } else if (BUNDLE_CLASS_SCHEME.equals(normalized.scheme()) && normalized.hasAuthority()) {
            result = normalized.authority();
        } else if (BUNDLE_RESOURCE_SCHEME.equals(normalized.scheme()) && normalized.hasAuthority()) {
            Bundle bundle = null;
            Matcher m = BUNDLE_RESOURCE_AUTHORITY_PATTERN.matcher(normalized.authority());
            if (m.find()) {
                long bundleID = Long.parseLong(m.group());
                bundle = Activator.getDefault().getBundle().getBundleContext().getBundle(bundleID);
            }
            if (bundle != null) {
                result = bundle.getSymbolicName();
            }
        } else {
            EPackage ePackage = context.getPackageRegistry().getEPackage(normalized.toString());
            if (ePackage != null) {
                Bundle bundle = FrameworkUtil.getBundle(ePackage.getClass());
                if (bundle != null) {
                    result = bundle.getSymbolicName();
                }
            } else {
                return Try.failure((String)NLS.bind((String)Messages.CommonURIUtils_0, (Object)resourceURI));
            }
        }
        return Try.success((Object)result);
    }

    public static boolean exists(EObject context, URI resourceURI) {
        return CommonURIUtils.exists(context.eResource(), resourceURI);
    }

    public static boolean exists(Resource context, URI resourceURI) {
        return CommonURIUtils.exists(context.getResourceSet(), resourceURI);
    }

    public static boolean exists(ResourceSet context, URI resourceURI) {
        boolean result = true;
        URI normalized = CommonURIUtils.normalize(context, resourceURI);
        if (normalized.isPlatformPlugin() || normalized.isPlatformResource()) {
            result = !normalized.hasTrailingPathSeparator() && normalized.segmentCount() > 2 && context.getURIConverter().exists(normalized, null);
        } else if (BUNDLE_CLASS_SCHEME.equals(normalized.scheme()) && normalized.hasAuthority() && normalized.segmentCount() > 0) {
            String bundle = normalized.authority();
            String className = normalized.segment(0);
            result = bundle != null && className != null && ClasspathHelper.INSTANCE.findClass(className, URI.createPlatformPluginURI((String)bundle, (boolean)false), null) != null;
        } else if (BUNDLE_RESOURCE_SCHEME.equals(normalized.scheme()) && normalized.hasAuthority() && normalized.segmentCount() > 0) {
            Bundle bundle = null;
            String className = normalized.segment(0);
            Matcher m = BUNDLE_RESOURCE_AUTHORITY_PATTERN.matcher(normalized.authority());
            if (m.find()) {
                long bundleID = Long.parseLong(m.group());
                bundle = Activator.getDefault().getBundle().getBundleContext().getBundle(bundleID);
            }
            result = bundle != null && className != null && ClasspathHelper.INSTANCE.findClass(className, URI.createPlatformPluginURI((String)bundle.getSymbolicName(), (boolean)false), null) != null;
        } else if (!normalized.isRelative()) {
            result = context.getPackageRegistry().getEPackage(normalized.toString()) != null;
        }
        return result;
    }
}

