/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.tools.util.Try;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class CommonMarkerResolutionUtils {
    public static Optional<String> getModelName(IMarker marker) {
        return Optional.ofNullable(marker.getAttribute("modelName", null));
    }

    public static Optional<IPath> getModelPath(IMarker marker) {
        return Optional.ofNullable(marker.getAttribute("modelPath", null)).map(Path::new);
    }

    public static <T extends EObject> Optional<T> getModelObject(IMarker marker, Class<T> type, EditingDomain domain) {
        return CommonMarkerResolutionUtils.getModelObject(marker, "uri", type, domain);
    }

    public static <T extends EObject> Optional<T> getModelObject(IMarker marker, String attribute, Class<T> type, EditingDomain domain) {
        return CommonMarkerResolutionUtils.getURIs(marker, attribute).map(uri -> domain.getResourceSet().getEObject(uri, true)).filter(type::isInstance).findAny().map(type::cast);
    }

    private static Stream<URI> getURIs(IMarker marker, String attribute) {
        String related;
        Stream<URI> result = Stream.of(marker.getAttribute(attribute, "")).filter(Predicate.not(String::isBlank)).map(uri -> URI.createURI((String)uri, (boolean)true));
        if ("uri".equals(attribute) && !(related = marker.getAttribute("relatedURIs", "")).isBlank()) {
            result = Stream.concat(result, Stream.of(related.split("\\s+")).filter(Predicate.not(String::isBlank)).map(uri -> URI.decode((String)uri)).map(uri -> URI.createURI((String)uri, (boolean)true)));
        }
        return result;
    }

    public static Optional<EAttribute> getModelAttribute(IMarker marker) {
        return CommonMarkerResolutionUtils.getModelFeature(marker, EPackage.Registry.INSTANCE).filter(EAttribute.class::isInstance).map(EAttribute.class::cast);
    }

    public static Optional<EReference> getModelReference(IMarker marker) {
        return CommonMarkerResolutionUtils.getModelFeature(marker, EPackage.Registry.INSTANCE).filter(EReference.class::isInstance).map(EReference.class::cast);
    }

    public static Optional<EStructuralFeature> getModelFeature(IMarker marker) {
        return CommonMarkerResolutionUtils.getModelFeature(marker, EPackage.Registry.INSTANCE);
    }

    public static Optional<EStructuralFeature> getModelFeature(IMarker marker, EditingDomain domain) {
        return CommonMarkerResolutionUtils.getModelFeature(marker, domain.getResourceSet().getPackageRegistry());
    }

    public static Optional<EStructuralFeature> getModelFeature(IMarker marker, EPackage.Registry packageRegistry) {
        return CommonMarkerResolutionUtils.getURIs(marker, "uri").map(uri -> {
            EPackage ePackage = packageRegistry.getEPackage(uri.trimFragment().toString());
            return ePackage == null ? null : ePackage.eResource().getEObject(uri.fragment());
        }).filter(EStructuralFeature.class::isInstance).findAny().map(EStructuralFeature.class::cast);
    }

    public static <V> Optional<V> getValue(IMarker marker, String attribute, Class<V> type, EDataType dataType) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            Boolean safeCast = marker.getAttribute(attribute, false);
            return Optional.ofNullable(safeCast);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            Integer safeCast = marker.getAttribute(attribute, 0);
            return Optional.ofNullable(safeCast);
        }
        if (type == String.class) {
            return Optional.ofNullable(type.cast(marker.getAttribute(attribute, null)));
        }
        return Optional.ofNullable(marker.getAttribute(attribute, null)).map(value -> EcoreUtil.createFromString((EDataType)dataType, (String)value)).map(type::cast);
    }

    public static Try<EditingDomain> getOpenEditingDomain(IMarker marker) {
        IResource resource = marker.getResource();
        if (!(resource instanceof IFile) || !PlatformUI.isWorkbenchRunning()) {
            return Try.success(null);
        }
        FileEditorInput editorInput = new FileEditorInput((IFile)resource);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        return Stream.of(windows).map(IWorkbenchWindow::getActivePage).flatMap(arg_0 -> CommonMarkerResolutionUtils.lambda$19((IEditorInput)editorInput, arg_0)).filter(Objects::nonNull).map(CommonMarkerResolutionUtils::getEditingDomain).filter(Objects::nonNull).findAny().orElseGet(Try::empty);
    }

    private static Try<EditingDomain> getEditingDomain(IEditorReference editorRef) {
        Try result = Try.empty();
        IEditorPart editor = editorRef.getEditor(true);
        if (editor instanceof IEditingDomainProvider) {
            result = !CommonMarkerResolutionUtils.ensureClean(editor) ? Try.failure((String)"dirty editor") : Try.success((Object)((IEditingDomainProvider)editor).getEditingDomain());
        }
        if (result.isEmpty() && editor != null) {
            result = Try.success((Object)((EditingDomain)editor.getAdapter(EditingDomain.class)));
        }
        return result;
    }

    private static boolean ensureClean(IEditorPart editor) {
        boolean result;
        boolean bl = result = !editor.isDirty();
        if (!result) {
            IWorkbenchPage page = editor.getSite().getPage();
            if (page.getActiveEditor() != editor) {
                page.activate((IWorkbenchPart)editor);
            }
            if (MessageDialog.openQuestion((Shell)editor.getSite().getShell(), (String)Messages.CommonMarkerResolutionUtils_0, (String)NLS.bind((String)Messages.CommonMarkerResolutionUtils_1, (Object)editor.getTitle()))) {
                result = page.saveEditor(editor, false);
            }
        }
        return result;
    }

    public static Optional<IEditorPart> getEditor(EditingDomain editingDomain) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        return Stream.of(windows).map(IWorkbenchWindow::getActivePage).map(IWorkbenchPage::getEditorReferences).flatMap(iEditorReferenceArray -> Stream.of(iEditorReferenceArray)).map(ref -> ref.getEditor(false)).filter(Objects::nonNull).filter(CommonMarkerResolutionUtils.hasEditingDomain(editingDomain)).findAny();
    }

    private static Predicate<IEditorPart> hasEditingDomain(EditingDomain editingDomain) {
        return editor -> {
            EditingDomain myDomain = null;
            if (editor instanceof IEditingDomainProvider) {
                myDomain = ((IEditingDomainProvider)editor).getEditingDomain();
            }
            if (myDomain == null) {
                myDomain = (EditingDomain)editor.getAdapter(EditingDomain.class);
            }
            return myDomain == editingDomain;
        };
    }

    private static /* synthetic */ Stream lambda$19(IEditorInput iEditorInput, IWorkbenchPage page) {
        return Stream.of(page.findEditors(iEditorInput, null, 1));
    }
}

