/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.common.util.CacheAdapter;

public abstract class AbstractReferenceDeleteRelationshipEditHelperAdvice
extends AbstractEditHelperAdvice {
    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
        if (request instanceof DestroyReferenceRequest && ((DestroyReferenceRequest)request).getContainingFeature() == null) {
            String visualId = (String)request.getParameter("VISUAL_ID");
            ((DestroyReferenceRequest)request).setContainingFeature(this.getFeature(visualId, request.getClientContext()));
        }
    }

    protected EReference getFeature(String visualId, IClientContext context) {
        List elementTypes = ElementTypeRegistryUtils.getElementTypesBySemanticHint((String)visualId, (String)context.getId());
        for (IElementType iElementType : elementTypes) {
            Map<String, EReference> featureElementTypeToEReferenceMap = this.getFeatureElementTypeToEReferenceMap();
            for (String featureElementType : featureElementTypeToEReferenceMap.keySet()) {
                List<ISpecializationType> subs = Arrays.asList(ElementTypeRegistry.getInstance().getSpecializationsOf(featureElementType));
                boolean typeOf = ElementUtil.isTypeOf(iElementType, ElementTypeRegistry.getInstance().getType(featureElementType));
                if (!subs.contains(iElementType) && !typeOf) continue;
                return featureElementTypeToEReferenceMap.get(featureElementType);
            }
        }
        return null;
    }

    protected abstract Map<String, EReference> getFeatureElementTypeToEReferenceMap();

    private List<View> getAllViewsFor(EObject eobject) {
        ArrayList<View> elementViews = new ArrayList<View>();
        if (eobject != null) {
            Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences(eobject);
            for (EStructuralFeature.Setting ref : settings) {
                View view;
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || (view = (View)ref.getEObject()) == null) continue;
                elementViews.add(view);
            }
        }
        return elementViews;
    }

    protected List<Connector> findConnectorsToDestroy(DestroyReferenceRequest request) {
        ArrayList<Connector> connectorsToDestroy = new ArrayList<Connector>();
        EObject featureOwner = request.getContainer();
        if (featureOwner != null) {
            List<View> featureOwnerViews = this.getAllViewsFor(featureOwner);
            if (this.checkSourceEdgeToFindConnectorToDestroy()) {
                connectorsToDestroy.addAll(this.findSourceConnectorsToDestroy(request, featureOwnerViews));
            }
            if (this.checkTargetEdgeToFindConnectorToDestroy()) {
                connectorsToDestroy.addAll(this.findTargetConnectorsToDestroy(request, featureOwnerViews));
            }
        }
        return connectorsToDestroy;
    }

    private List<Connector> findSourceConnectorsToDestroy(DestroyReferenceRequest request, List<View> featureOwnerViews) {
        ArrayList<Connector> viewsToDestroy = new ArrayList<Connector>();
        EObject removedReference = request.getReferencedObject();
        String visualId = (String)request.getParameter("VISUAL_ID");
        if (visualId != null && !visualId.isEmpty() && removedReference != null) {
            for (View currentView : featureOwnerViews) {
                EList sourceEdges = currentView.getSourceEdges();
                for (Object current : sourceEdges) {
                    View target;
                    EObject model;
                    Connector conn;
                    if (!(current instanceof Connector) || !visualId.equals((conn = (Connector)current).getType()) || removedReference != (model = (target = conn.getTarget()).getElement())) continue;
                    viewsToDestroy.add(conn);
                }
            }
        }
        return viewsToDestroy;
    }

    private List<Connector> findTargetConnectorsToDestroy(DestroyReferenceRequest request, List<View> featureOwnerViews) {
        ArrayList<Connector> viewsToDestroy = new ArrayList<Connector>();
        EObject removedReference = request.getReferencedObject();
        String visualId = (String)request.getParameter("VISUAL_ID");
        if (visualId != null && !visualId.isEmpty() && removedReference != null) {
            for (View currentView : featureOwnerViews) {
                EList targetEdgets = currentView.getTargetEdges();
                for (Object current : targetEdgets) {
                    View target;
                    EObject model;
                    Connector conn;
                    if (!(current instanceof Connector) || !visualId.equals((conn = (Connector)current).getType()) || removedReference != (model = (target = conn.getTarget()).getElement())) continue;
                    viewsToDestroy.add(conn);
                }
            }
        }
        return viewsToDestroy;
    }

    protected abstract boolean checkSourceEdgeToFindConnectorToDestroy();

    protected abstract boolean checkTargetEdgeToFindConnectorToDestroy();

    protected ICommand getBeforeDestroyReferenceCommand(DestroyReferenceRequest request) {
        CompositeCommand command = new CompositeCommand("Clear Connectors");
        List<Connector> connectorsToDestroy = this.findConnectorsToDestroy(request);
        if (!connectorsToDestroy.isEmpty()) {
            TransactionalEditingDomain domain = request.getEditingDomain();
            for (View view : connectorsToDestroy) {
                ICommand result;
                DestroyElementRequest destroy = new DestroyElementRequest(domain, (EObject)view, false);
                Object eHelperContext = destroy.getEditHelperContext();
                IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
                if (context == null || (result = context.getEditCommand((IEditCommandRequest)destroy)) == null) continue;
                command.add((IUndoableOperation)result);
            }
        }
        if (command.isEmpty() || !command.canExecute()) {
            return null;
        }
        return command;
    }
}

