/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiFactory;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.Window;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.BasicPageManagerImpl;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiSwitch;

public class DiUtils {
    public static SashModel createDefaultSashModel() {
        SashModel sashModel = DiFactory.eINSTANCE.createSashModel();
        Window window = DiFactory.eINSTANCE.createWindow();
        sashModel.getWindows().add((Object)window);
        TabFolder folder = DiFactory.eINSTANCE.createTabFolder();
        window.setPanel(folder);
        sashModel.setCurrentSelectionSilently(folder);
        return sashModel;
    }

    public static SashWindowsMngr createDefaultSashWindowsMngr() {
        SashWindowsMngr model = DiFactory.eINSTANCE.createSashWindowsMngr();
        SashModel layout = DiUtils.createDefaultSashModel();
        model.setSashModel(layout);
        return model;
    }

    public static SashWindowsMngr lookupSashWindowsMngr(Resource diResource) {
        for (Object node : diResource.getContents()) {
            if (!(node instanceof SashWindowsMngr)) continue;
            return (SashWindowsMngr)node;
        }
        return null;
    }

    public static TabFolder lookupCurrentTabFolderSelection(Resource diResource) {
        SashModel sashModel;
        SashWindowsMngr lookupSashWindowsMngr = DiUtils.lookupSashWindowsMngr(diResource);
        if (lookupSashWindowsMngr != null && (sashModel = lookupSashWindowsMngr.getSashModel()) != null) {
            return sashModel.getCurrentSelection();
        }
        return null;
    }

    @Deprecated
    public static PageRef getPageRef(Resource diResource, EObject eObject) {
        SashWindowsMngr windowsMngr = DiUtils.lookupSashWindowsMngr(diResource);
        if (windowsMngr != null && windowsMngr.getPageList() != null) {
            for (PageRef pageRef : windowsMngr.getPageList().getAvailablePage()) {
                EObject emfPageIdentifier = pageRef.getEmfPageIdentifier();
                if (eObject == null || !eObject.equals(emfPageIdentifier)) continue;
                return pageRef;
            }
        }
        return null;
    }

    @Deprecated
    public static void addPageToPageList(Resource diResource, PageRef pageRef) throws SashEditorException {
    }

    @Deprecated
    public static void addPageToPageList(SashWindowsMngr windowsMngr, PageRef pageRef) throws SashEditorException {
    }

    @Deprecated
    public static void addPageToTabFolder(SashWindowsMngr windowsMngr, PageRef pageRef) throws SashEditorException {
        if (pageRef == null || pageRef.getPageIdentifier() == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: parameters are null");
        }
        SashModel sashModel = windowsMngr.getSashModel();
        if (sashModel == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: can't find SashModel");
        }
        TabFolder tabFolder = sashModel.getCurrentSelection();
        if (tabFolder == null) {
            throw new SashEditorException("Unable to add the page to the tab folder: No active folder");
        }
        tabFolder.addPage(pageRef.getPageIdentifier());
    }

    public static Command getMemoizedCloseAllPagesCommand(TransactionalEditingDomain domain, IPageManager pageManager, final Object pageIdentifier) {
        RecordingCommand result = null;
        final BasicPageManagerImpl pageMan = (BasicPageManagerImpl)pageManager;
        final Map<PageRef, TabFolder> pages = DiUtils.execute(pageMan, new BasicPageManagerImpl.SashModelOperation<Map<PageRef, TabFolder>>(){

            @Override
            public Map<PageRef, TabFolder> execute(SashWindowsMngr sashWindowsManager) {
                return (Map)new DiSwitch<Map<PageRef, TabFolder>>(){
                    private Map<PageRef, TabFolder> pages = new HashMap<PageRef, TabFolder>();

                    @Override
                    public Map<PageRef, TabFolder> defaultCase(EObject object) {
                        for (EObject next : object.eContents()) {
                            this.doSwitch(next);
                        }
                        return this.pages;
                    }

                    @Override
                    public Map<PageRef, TabFolder> casePageRef(PageRef object) {
                        if (object.getPageIdentifier() == pageIdentifier) {
                            this.pages.put(object, object.getParent());
                        }
                        return this.pages;
                    }
                }.doSwitch(sashWindowsManager.getSashModel());
            }
        });
        if (!pages.isEmpty()) {
            final BasicPageManagerImpl.SashModelOperation<Void> removeOp = new BasicPageManagerImpl.SashModelOperation<Void>(){

                @Override
                public Void execute(SashWindowsMngr sashWindowsManager) {
                    SashModel sashModel = sashWindowsManager.getSashModel();
                    for (Map.Entry next : pages.entrySet()) {
                        PageRef page = (PageRef)next.getKey();
                        TabFolder folder = (TabFolder)next.getValue();
                        folder.getChildren().remove((Object)page);
                        sashModel.removeEmptyFolder(folder);
                    }
                    return null;
                }
            };
            result = new RecordingCommand(domain, "Remove Editor Page(s)"){

                protected void doExecute() {
                    DiUtils.execute(pageMan, removeOp);
                }
            };
        }
        return result;
    }

    private static <T> T execute(BasicPageManagerImpl pageManager, BasicPageManagerImpl.SashModelOperation<T> sashOperation) {
        try {
            return pageManager.execute(sashOperation);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getLocalizedMessage());
        }
    }
}

