/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeUtil {
    private StereotypeUtil() {
    }

    public static final Collection<Operation> getAllStereotypeOperations(Stereotype stereotype, boolean ignoreVoidOperations, boolean ignoreOperationsWithParameters, boolean inheritedOperation) {
        if (inheritedOperation) {
            return StereotypeUtil.filterOperations((Collection<Operation>)stereotype.getAllOperations(), ignoreVoidOperations, ignoreOperationsWithParameters);
        }
        return StereotypeUtil.filterOperations((Collection<Operation>)stereotype.getOwnedOperations(), ignoreVoidOperations, ignoreOperationsWithParameters);
    }

    private static final Collection<Operation> filterOperations(Collection<Operation> operations, boolean ignoreVoidOperations, boolean ignoreOperationsWithParameters) {
        if (!ignoreOperationsWithParameters && !ignoreVoidOperations) {
            return Collections.unmodifiableCollection(operations);
        }
        HashSet<Operation> filteredOperation = new HashSet<Operation>();
        for (Operation current : operations) {
            ArrayList<Parameter> returnParameters = new ArrayList<Parameter>();
            ArrayList<Parameter> othersParameters = new ArrayList<Parameter>();
            for (Parameter p : current.getOwnedParameters()) {
                if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                    returnParameters.add(p);
                    continue;
                }
                othersParameters.add(p);
            }
            if (!ignoreVoidOperations || returnParameters.isEmpty() || !ignoreOperationsWithParameters || !othersParameters.isEmpty()) continue;
            filteredOperation.add(current);
        }
        return filteredOperation;
    }
}

