/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.impl;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.InfosProvider;
import org.eclipse.cbi.p2repo.aggregator.MavenDependencyItem;
import org.eclipse.cbi.p2repo.aggregator.MavenDependencyMapping;
import org.eclipse.cbi.p2repo.aggregator.Status;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.aggregator.impl.MavenMappingImpl;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class MavenDependencyMappingImpl
extends MinimalEObjectImpl.Container
implements MavenDependencyMapping {
    private Pattern compiledIUNamePattern;
    private Pattern compiledNamespacePattern;
    private Pattern compiledNamePattern;
    private Pattern compiledVersionRangePattern;
    protected int eFlags = 0;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final String IU_NAME_PATTERN_EDEFAULT = null;
    protected String iuNamePattern = IU_NAME_PATTERN_EDEFAULT;
    protected static final String NAMESPACE_PATTERN_EDEFAULT = null;
    protected String namespacePattern = NAMESPACE_PATTERN_EDEFAULT;
    protected static final String NAME_PATTERN_EDEFAULT = null;
    protected String namePattern = NAME_PATTERN_EDEFAULT;
    protected static final String GROUP_ID_EDEFAULT = null;
    protected String groupId = GROUP_ID_EDEFAULT;
    protected static final String ARTIFACT_ID_EDEFAULT = null;
    protected String artifactId = ARTIFACT_ID_EDEFAULT;
    protected static final String VERSION_RANGE_PATTERN_EDEFAULT = null;
    protected String versionRangePattern = VERSION_RANGE_PATTERN_EDEFAULT;
    protected static final String VERSION_RANGE_TEMPLATE_EDEFAULT = null;
    protected String versionRangeTemplate = VERSION_RANGE_TEMPLATE_EDEFAULT;

    protected MavenDependencyMappingImpl() {
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.MAVEN_DEPENDENCY_MAPPING;
    }

    @Override
    public Status getStatus() {
        try {
            String iuNamePattern = StringUtils.trimmedOrNull((String)this.getIuNamePattern());
            if (iuNamePattern != null) {
                this.compiledNamespacePattern = Pattern.compile(iuNamePattern);
            }
            String namespacePattern = StringUtils.trimmedOrNull((String)this.getNamespacePattern());
            String namePattern = StringUtils.trimmedOrNull((String)this.getNamePattern());
            if (namePattern == null || namespacePattern == null || StringUtils.trimmedOrNull((String)this.getGroupId()) == null || StringUtils.trimmedOrNull((String)this.getArtifactId()) == null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, "Incomplete");
            }
            this.compiledNamespacePattern = Pattern.compile(namespacePattern);
            this.compiledNamePattern = Pattern.compile(namePattern);
            MavenMappingImpl.checkReplacements(this.compiledNamePattern, this.getGroupId(), this.getArtifactId());
            String versionRangePattern = StringUtils.trimmedOrNull((String)this.getVersionRangePattern());
            if (versionRangePattern != null) {
                this.compiledVersionRangePattern = Pattern.compile(versionRangePattern);
                String versionRangeTemplate = this.getVersionRangeTemplate();
                if (versionRangeTemplate != null) {
                    MavenMappingImpl.checkReplacements(this.compiledVersionRangePattern, versionRangeTemplate);
                }
            }
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
        }
        catch (PatternSyntaxException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, e.getMessage());
        }
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 1);
        }
        return this.errors;
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.warnings;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        return this.infos;
    }

    @Override
    public String getIuNamePattern() {
        return this.iuNamePattern;
    }

    public void setIuNamePatternGen(String newIuNamePattern) {
        String oldIuNamePattern = this.iuNamePattern;
        this.iuNamePattern = newIuNamePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldIuNamePattern, (Object)this.iuNamePattern));
        }
    }

    @Override
    public void setIuNamePattern(String newIuNamePattern) {
        this.setIuNamePatternGen(newIuNamePattern);
        newIuNamePattern = StringUtils.trimmedOrNull((String)newIuNamePattern);
        if (newIuNamePattern != null) {
            try {
                this.compiledIUNamePattern = Pattern.compile(StringUtils.trimmedOrNull((String)newIuNamePattern));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else {
            this.compiledIUNamePattern = null;
        }
    }

    @Override
    public String getNamespacePattern() {
        return this.namespacePattern;
    }

    public void setNamespacePatternGen(String newNamespacePattern) {
        String oldNamespacePattern = this.namespacePattern;
        this.namespacePattern = newNamespacePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldNamespacePattern, (Object)this.namespacePattern));
        }
    }

    @Override
    public void setNamespacePattern(String newNamespacePattern) {
        this.setNamespacePatternGen(newNamespacePattern);
        if (newNamespacePattern != null) {
            try {
                this.compiledNamespacePattern = Pattern.compile(StringUtils.trimmedOrNull((String)newNamespacePattern));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else {
            this.compiledNamespacePattern = null;
        }
    }

    @Override
    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePatternGen(String newNamePattern) {
        String oldNamePattern = this.namePattern;
        this.namePattern = newNamePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldNamePattern, (Object)this.namePattern));
        }
    }

    @Override
    public void setNamePattern(String newNamePattern) {
        this.setNamePatternGen(newNamePattern);
        if (newNamePattern != null) {
            try {
                this.compiledNamePattern = Pattern.compile(StringUtils.trimmedOrNull((String)newNamePattern));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else {
            this.compiledNamePattern = null;
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String newGroupId) {
        String oldGroupId = this.groupId;
        this.groupId = newGroupId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldGroupId, (Object)this.groupId));
        }
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public void setArtifactId(String newArtifactId) {
        String oldArtifactId = this.artifactId;
        this.artifactId = newArtifactId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldArtifactId, (Object)this.artifactId));
        }
    }

    @Override
    public String getVersionRangePattern() {
        return this.versionRangePattern;
    }

    public void setVersionRangePatternGen(String newVersionRangePattern) {
        String oldVersionRangePattern = this.versionRangePattern;
        this.versionRangePattern = newVersionRangePattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldVersionRangePattern, (Object)this.versionRangePattern));
        }
    }

    @Override
    public void setVersionRangePattern(String newVersionRangePattern) {
        this.setVersionRangePatternGen(newVersionRangePattern);
        if (newVersionRangePattern != null) {
            try {
                this.compiledVersionRangePattern = Pattern.compile(StringUtils.trimmedOrNull((String)newVersionRangePattern));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        } else {
            this.compiledVersionRangePattern = null;
        }
    }

    @Override
    public String getVersionRangeTemplate() {
        return this.versionRangeTemplate;
    }

    @Override
    public void setVersionRangeTemplate(String newVersionRangeTemplate) {
        String oldVersionRangeTemplate = this.versionRangeTemplate;
        this.versionRangeTemplate = newVersionRangeTemplate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldVersionRangeTemplate, (Object)this.versionRangeTemplate));
        }
    }

    @Override
    public MavenDependencyItem map(String iuName, String requirementNamespace, String requirementName, VersionRange versionRange) {
        Matcher matcher;
        if ((this.compiledIUNamePattern == null || this.compiledIUNamePattern.matcher(iuName).matches()) && this.compiledNamespacePattern.matcher(requirementNamespace).matches() && (matcher = this.compiledNamePattern.matcher(requirementName)).matches()) {
            MavenDependencyItem item = AggregatorFactory.eINSTANCE.createMavenDependencyItem();
            item.setGroupId(matcher.replaceFirst(this.getGroupId()));
            item.setArtifactId(matcher.replaceFirst(this.getArtifactId()));
            item.setMavenDependencyMapping(this);
            if (this.compiledVersionRangePattern != null) {
                Matcher versionRangeMatcher = this.compiledVersionRangePattern.matcher(versionRange.toString());
                if (versionRangeMatcher.matches()) {
                    if (this.versionRangeTemplate != null) {
                        String replacement = versionRangeMatcher.replaceFirst(this.versionRangeTemplate);
                        item.setMappedVersionRange(replacement);
                    }
                } else {
                    return null;
                }
            }
            return item;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getErrors();
            }
            case 2: {
                return this.getWarnings();
            }
            case 3: {
                return this.getInfos();
            }
            case 4: {
                return this.getIuNamePattern();
            }
            case 5: {
                return this.getNamespacePattern();
            }
            case 6: {
                return this.getNamePattern();
            }
            case 7: {
                return this.getGroupId();
            }
            case 8: {
                return this.getArtifactId();
            }
            case 9: {
                return this.getVersionRangePattern();
            }
            case 10: {
                return this.getVersionRangeTemplate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setIuNamePattern((String)newValue);
                return;
            }
            case 5: {
                this.setNamespacePattern((String)newValue);
                return;
            }
            case 6: {
                this.setNamePattern((String)newValue);
                return;
            }
            case 7: {
                this.setGroupId((String)newValue);
                return;
            }
            case 8: {
                this.setArtifactId((String)newValue);
                return;
            }
            case 9: {
                this.setVersionRangePattern((String)newValue);
                return;
            }
            case 10: {
                this.setVersionRangeTemplate((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                return;
            }
            case 2: {
                this.getWarnings().clear();
                return;
            }
            case 3: {
                this.getInfos().clear();
                return;
            }
            case 4: {
                this.setIuNamePattern(IU_NAME_PATTERN_EDEFAULT);
                return;
            }
            case 5: {
                this.setNamespacePattern(NAMESPACE_PATTERN_EDEFAULT);
                return;
            }
            case 6: {
                this.setNamePattern(NAME_PATTERN_EDEFAULT);
                return;
            }
            case 7: {
                this.setGroupId(GROUP_ID_EDEFAULT);
                return;
            }
            case 8: {
                this.setArtifactId(ARTIFACT_ID_EDEFAULT);
                return;
            }
            case 9: {
                this.setVersionRangePattern(VERSION_RANGE_PATTERN_EDEFAULT);
                return;
            }
            case 10: {
                this.setVersionRangeTemplate(VERSION_RANGE_TEMPLATE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 2: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 3: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 4: {
                return IU_NAME_PATTERN_EDEFAULT == null ? this.iuNamePattern != null : !IU_NAME_PATTERN_EDEFAULT.equals(this.iuNamePattern);
            }
            case 5: {
                return NAMESPACE_PATTERN_EDEFAULT == null ? this.namespacePattern != null : !NAMESPACE_PATTERN_EDEFAULT.equals(this.namespacePattern);
            }
            case 6: {
                return NAME_PATTERN_EDEFAULT == null ? this.namePattern != null : !NAME_PATTERN_EDEFAULT.equals(this.namePattern);
            }
            case 7: {
                return GROUP_ID_EDEFAULT == null ? this.groupId != null : !GROUP_ID_EDEFAULT.equals(this.groupId);
            }
            case 8: {
                return ARTIFACT_ID_EDEFAULT == null ? this.artifactId != null : !ARTIFACT_ID_EDEFAULT.equals(this.artifactId);
            }
            case 9: {
                return VERSION_RANGE_PATTERN_EDEFAULT == null ? this.versionRangePattern != null : !VERSION_RANGE_PATTERN_EDEFAULT.equals(this.versionRangePattern);
            }
            case 10: {
                return VERSION_RANGE_TEMPLATE_EDEFAULT == null ? this.versionRangeTemplate != null : !VERSION_RANGE_TEMPLATE_EDEFAULT.equals(this.versionRangeTemplate);
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", iuNamePattern: ");
        result.append(this.iuNamePattern);
        result.append(", namespacePattern: ");
        result.append(this.namespacePattern);
        result.append(", namePattern: ");
        result.append(this.namePattern);
        result.append(", groupId: ");
        result.append(this.groupId);
        result.append(", artifactId: ");
        result.append(this.artifactId);
        result.append(", versionRangePattern: ");
        result.append(this.versionRangePattern);
        result.append(", versionRangeTemplate: ");
        result.append(this.versionRangeTemplate);
        result.append(')');
        return result.toString();
    }
}

