/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public interface IGenerator {
    public List<Context> generate(List<URI> var1);

    @Deprecated
    default public void createControls(Composite parent) {
        throw new AbstractMethodError("createControls(Composite)");
    }

    default public void createControls(Composite parent, IFile workbenchSelection) {
        this.createControls(parent);
    }

    public String getDescription();

    public boolean isReady();

    public String getName();

    public boolean isSelectedSingle(Property var1);

    public boolean isSelectedMultiple(Property var1);

    public boolean isSelectedSingle(Property var1, DataContextElement var2);

    public boolean isSelectedMultiple(Property var1, DataContextElement var2);

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public List<Object> getExternalReference();

    public IObservableValue getObservableValue();

    public void setStrategy(int var1);

    public void addCheckElement(Object var1);

    public void dispose();

    default public IFile getSourceFile(IFile file) {
        try {
            Optional<IContentType> contentType = Optional.ofNullable(file.getContentDescription()).map(IContentDescription::getContentType);
            return this.getSourceFile(file, contentType.orElse(null));
        }
        catch (CoreException e) {
            Activator.log.error("Could not determine content type of " + String.valueOf(file), (Throwable)e);
            return null;
        }
    }

    default public IFile getSourceFile(IFile file, IContentType contentType) {
        return null;
    }

    default public boolean canGenerate(IFile selectedFile, IContentType contentType) {
        return this.getSourceFile(selectedFile, contentType) != null;
    }
}

