/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public abstract class EMFLogicalModel
extends AbstractBaseModel
implements IEMFModel {
    protected final Set<Resource> resources = new HashSet<Resource>();

    public Set<Resource> getResources() {
        this.pruneDeletedResources();
        return this.resources;
    }

    protected void pruneDeletedResources() {
        ModelSet rset = this.getModelManager();
        Iterator<Resource> iter = this.resources.iterator();
        while (iter.hasNext()) {
            if (iter.next().getResourceSet() == rset) continue;
            iter.remove();
        }
    }

    @Override
    protected void configureResource(Resource resourceToConfigure) {
        super.configureResource(resourceToConfigure);
        if (resourceToConfigure != null) {
            this.resources.add(resourceToConfigure);
        }
    }

    protected boolean isRelatedResource(Resource resource) {
        if (resource == null || resource.getURI() == null) {
            return false;
        }
        URI uri = resource.getURI();
        if (uri.fileExtension() == null) {
            return false;
        }
        return uri.fileExtension().equals(this.getModelFileExtension());
    }

    @Override
    public void saveModel() throws IOException {
        ModelSet set = this.getModelManager();
        for (Resource resource : this.getResources()) {
            if (!set.shouldSave(resource)) continue;
            try {
                resource.save(null);
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public void handle(Resource resource) {
        if (this.isRelatedResource(resource)) {
            this.configureResource(resource);
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.getResources().clear();
    }

    @Override
    public void setModelURI(URI uriWithoutExtension) {
        for (Resource resource : this.getResources()) {
            if (!this.isControlled(resource)) continue;
            this.updateURI(resource, uriWithoutExtension);
        }
        super.setModelURI(uriWithoutExtension);
    }

    protected void updateURI(Resource resource, URI uriWithoutExtension) {
        URI oldBaseURI = this.resource.getURI();
        URI newBaseURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        URI currentFullURI = resource.getURI();
        URI currentRelativeURI = currentFullURI.deresolve(oldBaseURI);
        URI newFullURI = currentRelativeURI.resolve(newBaseURI);
        resource.setURI(newFullURI);
    }

    @Override
    public boolean isModelFor(Object element) {
        if (element instanceof EObject) {
            return this.resources.contains(((EObject)element).eResource());
        }
        return this.resources.contains(element);
    }

    @Override
    public void cleanModel(Set<URI> resourcesToDelete) {
        if (!resourcesToDelete.isEmpty()) {
            Iterator<Resource> modelResourcesIterator = this.getResources().iterator();
            ArrayList<Resource> referencedDeletedResources = new ArrayList<Resource>();
            while (modelResourcesIterator.hasNext()) {
                Resource currentResource = modelResourcesIterator.next();
                if (!resourcesToDelete.contains(currentResource.getURI())) continue;
                referencedDeletedResources.add(currentResource);
            }
            if (!referencedDeletedResources.isEmpty()) {
                this.getResources().removeAll(referencedDeletedResources);
            }
        }
    }

    @Override
    public Iterable<? extends EObject> getRootElements() {
        return () -> this.getResources().stream().flatMap(r -> r.getContents().stream()).filter(this::isRootElement).iterator();
    }

    @Override
    public boolean canPersist(EObject object) {
        return this.getResource() != null && this.isSupportedRoot(object);
    }

    protected abstract boolean isSupportedRoot(EObject var1);

    @Override
    public void persist(EObject object) {
        if (!this.canPersist(object)) {
            throw new IllegalArgumentException("cannot persist " + object);
        }
        this.getResource().getContents().add((Object)object);
    }
}

