/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateChildViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateChildViewOperation) {
            View container = ((CreateChildViewOperation)operation).getContainerView();
            Diagram diagram = container.getDiagram();
            if (!this.getDiagramProvidedId().equals(diagram.getType())) {
                return false;
            }
        }
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        String visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "PapyrusUMLStateMachineDiagram";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "PapyrusUMLStateMachineDiagram".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != null && !UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())).isEmpty();
    }

    protected boolean provides(CreateNodeViewOperation op) {
        String visualID;
        block57: {
            EObject domainElement;
            block58: {
                IElementType elementType;
                block56: {
                    if (op.getContainerView() == null) {
                        return false;
                    }
                    elementType = this.getSemanticElementType(op.getSemanticAdapter());
                    domainElement = this.getSemanticElement(op.getSemanticAdapter());
                    if (op.getSemanticHint() != null) break block56;
                    if (elementType != null || domainElement == null) {
                        return false;
                    }
                    visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
                    break block57;
                }
                visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
                if (elementType == null) break block58;
                if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                break block57;
            }
            if (!"PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                return false;
            }
            if (visualID == null) break block57;
            switch (visualID) {
                case "ConnectionPointReference_Shape": 
                case "Pseudostate_ShallowHistoryShape": 
                case "Pseudostate_JunctionShape": 
                case "Pseudostate_JoinShape": 
                case "Constraint_Shape": 
                case "Region_Shape": 
                case "State_Shape": 
                case "Pseudostate_DeepHistoryShape": 
                case "Transition_InternalTransitionLabel": 
                case "Behavior_EntryBehaviorLabel": 
                case "Pseudostate_TerminateShape": 
                case "Comment_Shape": 
                case "State_Shape_TN": 
                case "FinalState_Shape": 
                case "Pseudostate_ExitPointShape": 
                case "Behavior_DoActivityBehaviorLabel": 
                case "StateMachine_Shape": 
                case "Pseudostate_ChoiceShape": 
                case "Trigger_DeferrableTriggerLabel": 
                case "Pseudostate_ForkShape": 
                case "Pseudostate_InitialShape": 
                case "Behavior_ExitBehaviorLabel": 
                case "Pseudostate_EntryPointShape": {
                    if (domainElement != null && visualID.equals(UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement))) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        return elementTypeHint != null && (op.getSemanticHint() == null || elementTypeHint.equals(op.getSemanticHint()));
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramVersioningUtils.stampCurrentVersion((Diagram)diagram);
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("PapyrusUMLStateMachineDiagram");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block73: {
            EObject domainElement = this.getSemanticElement(semanticAdapter);
            String visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
            if (visualID == null) break block73;
            switch (visualID) {
                case "StateMachine_Shape": {
                    return this.createStateMachine_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "State_Shape_TN": {
                    return this.createState_Shape_TN(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Region_Shape": {
                    return this.createRegion_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "FinalState_Shape": {
                    return this.createFinalState_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "State_Shape": {
                    return this.createState_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_InitialShape": {
                    return this.createPseudostate_InitialShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_JoinShape": {
                    return this.createPseudostate_JoinShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_ForkShape": {
                    return this.createPseudostate_ForkShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_ChoiceShape": {
                    return this.createPseudostate_ChoiceShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_JunctionShape": {
                    return this.createPseudostate_JunctionShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_ShallowHistoryShape": {
                    return this.createPseudostate_ShallowHistoryShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_DeepHistoryShape": {
                    return this.createPseudostate_DeepHistoryShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_TerminateShape": {
                    return this.createPseudostate_TerminateShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_EntryPointShape": {
                    return this.createPseudostate_EntryPointShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Pseudostate_ExitPointShape": {
                    return this.createPseudostate_ExitPointShape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "ConnectionPointReference_Shape": {
                    return this.createConnectionPointReference_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Comment_Shape": {
                    return this.createComment_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Constraint_Shape": {
                    return this.createConstraint_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Transition_InternalTransitionLabel": {
                    return this.createTransition_InternalTransitionLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Behavior_EntryBehaviorLabel": {
                    return this.createBehavior_EntryBehaviorLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Behavior_DoActivityBehaviorLabel": {
                    return this.createBehavior_DoActivityBehaviorLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Behavior_ExitBehaviorLabel": {
                    return this.createBehavior_ExitBehaviorLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Trigger_DeferrableTriggerLabel": {
                    return this.createTrigger_DeferrableTriggerLabel(domainElement, containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block19: {
            IElementType elementType = this.getSemanticElementType(semanticAdapter);
            String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
            String vid = UMLVisualIDRegistry.getVisualID(elementTypeHint);
            if (vid == null) break block19;
            switch (vid) {
                case "Transition_Edge": {
                    return this.createTransition_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Generalization_Edge": {
                    return this.createGeneralization_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Comment_AnnotatedElementEdge": {
                    return this.createComment_AnnotatedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "Constraint_ConstrainedElementEdge": {
                    return this.createConstraint_ConstrainedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "Constraint_ContextEdge": {
                    return this.createConstraint_ContextEdge(containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Node createStateMachine_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("StateMachine_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("StateMachine_NameLabel"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("StateMachine_RegionCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        return node;
    }

    public Node createState_Shape_TN(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("State_Shape_TN"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("State_NameLabel_TN"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("State_RegionCompartment_TN"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        return node;
    }

    public Node createRegion_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Region_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Region");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Region_SubvertexCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Region");
        return node;
    }

    public Node createFinalState_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("FinalState_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FinalState");
        Node finalState_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("FinalState_FloatingNameLabel"));
        finalState_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location finalState_FloatingNameLabel_Location = (Location)finalState_FloatingNameLabel.getLayoutConstraint();
        finalState_FloatingNameLabel_Location.setX(25);
        finalState_FloatingNameLabel_Location.setY(3);
        Node finalState_StereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("FinalState_StereotypeLabel"));
        finalState_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location finalState_StereotypeLabel_Location = (Location)finalState_StereotypeLabel.getLayoutConstraint();
        finalState_StereotypeLabel_Location.setX(25);
        finalState_StereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createState_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("State_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("State_NameLabel"));
        Node state_FloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("State_FloatingNameLabel"));
        state_FloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location state_FloatingNameLabel_Location = (Location)state_FloatingNameLabel.getLayoutConstraint();
        state_FloatingNameLabel_Location.setX(40);
        state_FloatingNameLabel_Location.setY(0);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("State_RegionCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"State");
        return node;
    }

    public Node createPseudostate_InitialShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_InitialShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_InitialFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_InitialFloatingNameLabel"));
        pseudostate_InitialFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_InitialFloatingNameLabel_Location = (Location)pseudostate_InitialFloatingNameLabel.getLayoutConstraint();
        pseudostate_InitialFloatingNameLabel_Location.setX(25);
        pseudostate_InitialFloatingNameLabel_Location.setY(3);
        Node pseudostate_InitialStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_InitialStereotypeLabel"));
        pseudostate_InitialStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_InitialStereotypeLabel_Location = (Location)pseudostate_InitialStereotypeLabel.getLayoutConstraint();
        pseudostate_InitialStereotypeLabel_Location.setX(25);
        pseudostate_InitialStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_JoinShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_JoinShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_JoinFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_JoinFloatingNameLabel"));
        pseudostate_JoinFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_JoinFloatingNameLabel_Location = (Location)pseudostate_JoinFloatingNameLabel.getLayoutConstraint();
        pseudostate_JoinFloatingNameLabel_Location.setX(25);
        pseudostate_JoinFloatingNameLabel_Location.setY(3);
        Node pseudostate_JoinStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_JoinStereotypeLabel"));
        pseudostate_JoinStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_JoinStereotypeLabel_Location = (Location)pseudostate_JoinStereotypeLabel.getLayoutConstraint();
        pseudostate_JoinStereotypeLabel_Location.setX(25);
        pseudostate_JoinStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_ForkShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_ForkShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_ForkFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ForkFloatingNameLabel"));
        pseudostate_ForkFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ForkFloatingNameLabel_Location = (Location)pseudostate_ForkFloatingNameLabel.getLayoutConstraint();
        pseudostate_ForkFloatingNameLabel_Location.setX(25);
        pseudostate_ForkFloatingNameLabel_Location.setY(3);
        Node pseudostate_ForkStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ForkStereotypeLabel"));
        pseudostate_ForkStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ForkStereotypeLabel_Location = (Location)pseudostate_ForkStereotypeLabel.getLayoutConstraint();
        pseudostate_ForkStereotypeLabel_Location.setX(25);
        pseudostate_ForkStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_ChoiceShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_ChoiceShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_ChoiceFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ChoiceFloatingNameLabel"));
        pseudostate_ChoiceFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ChoiceFloatingNameLabel_Location = (Location)pseudostate_ChoiceFloatingNameLabel.getLayoutConstraint();
        pseudostate_ChoiceFloatingNameLabel_Location.setX(50);
        pseudostate_ChoiceFloatingNameLabel_Location.setY(3);
        Node pseudostate_ChoiceStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ChoiceStereotypeLabel"));
        pseudostate_ChoiceStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ChoiceStereotypeLabel_Location = (Location)pseudostate_ChoiceStereotypeLabel.getLayoutConstraint();
        pseudostate_ChoiceStereotypeLabel_Location.setX(25);
        pseudostate_ChoiceStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_JunctionShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_JunctionShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_JunctionFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_JunctionFloatingNameLabel"));
        pseudostate_JunctionFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_JunctionFloatingNameLabel_Location = (Location)pseudostate_JunctionFloatingNameLabel.getLayoutConstraint();
        pseudostate_JunctionFloatingNameLabel_Location.setX(25);
        pseudostate_JunctionFloatingNameLabel_Location.setY(3);
        Node pseudostate_JunctionStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_JunctionStereotypeLabel"));
        pseudostate_JunctionStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_JunctionStereotypeLabel_Location = (Location)pseudostate_JunctionStereotypeLabel.getLayoutConstraint();
        pseudostate_JunctionStereotypeLabel_Location.setX(25);
        pseudostate_JunctionStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_ShallowHistoryShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_ShallowHistoryShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_ShallowHistoryFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ShallowHistoryFloatingNameLabel"));
        pseudostate_ShallowHistoryFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ShallowHistoryFloatingNameLabel_Location = (Location)pseudostate_ShallowHistoryFloatingNameLabel.getLayoutConstraint();
        pseudostate_ShallowHistoryFloatingNameLabel_Location.setX(25);
        pseudostate_ShallowHistoryFloatingNameLabel_Location.setY(3);
        Node pseudostate_ShallowHistoryStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ShallowHistoryStereotypeLabel"));
        pseudostate_ShallowHistoryStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ShallowHistoryStereotypeLabel_Location = (Location)pseudostate_ShallowHistoryStereotypeLabel.getLayoutConstraint();
        pseudostate_ShallowHistoryStereotypeLabel_Location.setX(25);
        pseudostate_ShallowHistoryStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_DeepHistoryShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_DeepHistoryShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_DeepHistoryFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_DeepHistoryFloatingNameLabel"));
        pseudostate_DeepHistoryFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_DeepHistoryFloatingNameLabel_Location = (Location)pseudostate_DeepHistoryFloatingNameLabel.getLayoutConstraint();
        pseudostate_DeepHistoryFloatingNameLabel_Location.setX(25);
        pseudostate_DeepHistoryFloatingNameLabel_Location.setY(3);
        Node pseudostate_DeepHistoryStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_DeepHistoryStereotypeLabel"));
        pseudostate_DeepHistoryStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_DeepHistoryStereotypeLabel_Location = (Location)pseudostate_DeepHistoryStereotypeLabel.getLayoutConstraint();
        pseudostate_DeepHistoryStereotypeLabel_Location.setX(25);
        pseudostate_DeepHistoryStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_TerminateShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_TerminateShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_TerminateFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_TerminateFloatingNameLabel"));
        pseudostate_TerminateFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_TerminateFloatingNameLabel_Location = (Location)pseudostate_TerminateFloatingNameLabel.getLayoutConstraint();
        pseudostate_TerminateFloatingNameLabel_Location.setX(25);
        pseudostate_TerminateFloatingNameLabel_Location.setY(3);
        Node pseudostate_TerminateStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_TerminateStereotypeLabel"));
        pseudostate_TerminateStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_TerminateStereotypeLabel_Location = (Location)pseudostate_TerminateStereotypeLabel.getLayoutConstraint();
        pseudostate_TerminateStereotypeLabel_Location.setX(25);
        pseudostate_TerminateStereotypeLabel_Location.setY(-10);
        return node;
    }

    public Node createPseudostate_EntryPointShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_EntryPointShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_EntryPointFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_EntryPointFloatingNameLabel"));
        pseudostate_EntryPointFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_EntryPointFloatingNameLabel_Location = (Location)pseudostate_EntryPointFloatingNameLabel.getLayoutConstraint();
        pseudostate_EntryPointFloatingNameLabel_Location.setX(25);
        pseudostate_EntryPointFloatingNameLabel_Location.setY(3);
        Node pseudostate_EntryPointStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_EntryPointStereotypeLabel"));
        pseudostate_EntryPointStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_EntryPointStereotypeLabel_Location = (Location)pseudostate_EntryPointStereotypeLabel.getLayoutConstraint();
        pseudostate_EntryPointStereotypeLabel_Location.setX(25);
        pseudostate_EntryPointStereotypeLabel_Location.setY(-10);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        return node;
    }

    public Node createPseudostate_ExitPointShape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Pseudostate_ExitPointShape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        Node pseudostate_ExitPointFloatingNameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ExitPointFloatingNameLabel"));
        pseudostate_ExitPointFloatingNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ExitPointFloatingNameLabel_Location = (Location)pseudostate_ExitPointFloatingNameLabel.getLayoutConstraint();
        pseudostate_ExitPointFloatingNameLabel_Location.setX(25);
        pseudostate_ExitPointFloatingNameLabel_Location.setY(3);
        Node pseudostate_ExitPointStereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Pseudostate_ExitPointStereotypeLabel"));
        pseudostate_ExitPointStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location pseudostate_ExitPointStereotypeLabel_Location = (Location)pseudostate_ExitPointStereotypeLabel.getLayoutConstraint();
        pseudostate_ExitPointStereotypeLabel_Location.setX(25);
        pseudostate_ExitPointStereotypeLabel_Location.setY(-10);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Pseudostate");
        return node;
    }

    public Node createConnectionPointReference_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("ConnectionPointReference_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConnectionPointReference");
        Node connectionPointReference_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("ConnectionPointReference_NameLabel"));
        connectionPointReference_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location connectionPointReference_NameLabel_Location = (Location)connectionPointReference_NameLabel.getLayoutConstraint();
        connectionPointReference_NameLabel_Location.setX(25);
        connectionPointReference_NameLabel_Location.setY(3);
        Node connectionPointReference_StereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("ConnectionPointReference_StereotypeLabel"));
        connectionPointReference_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location connectionPointReference_StereotypeLabel_Location = (Location)connectionPointReference_StereotypeLabel.getLayoutConstraint();
        connectionPointReference_StereotypeLabel_Location.setX(25);
        connectionPointReference_StereotypeLabel_Location.setY(-10);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConnectionPointReference");
        return node;
    }

    public Node createComment_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Comment_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Comment_BodyLabel"));
        return node;
    }

    public Node createConstraint_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Constraint_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_NameLabel"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_BodyLabel"));
        return node;
    }

    public Node createTransition_InternalTransitionLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("Transition_InternalTransitionLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InternalTransition");
        return node;
    }

    public Node createBehavior_EntryBehaviorLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("Behavior_EntryBehaviorLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"EntryStateBehavior");
        return node;
    }

    public Node createBehavior_DoActivityBehaviorLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("Behavior_DoActivityBehaviorLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DoActivityStateBehavior");
        return node;
    }

    public Node createBehavior_ExitBehaviorLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("Behavior_ExitBehaviorLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExitStateBehavior");
        return node;
    }

    public Node createTrigger_DeferrableTriggerLabel(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType("Trigger_DeferrableTriggerLabel"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DeferrableTrigger");
        return node;
    }

    public Edge createTransition_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Transition_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Transition");
        Node transition_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Transition_NameLabel"));
        transition_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location transition_NameLabel_Location = (Location)transition_NameLabel.getLayoutConstraint();
        transition_NameLabel_Location.setX(0);
        transition_NameLabel_Location.setY(20);
        Node transition_GuardLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Transition_GuardLabel"));
        transition_GuardLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location transition_GuardLabel_Location = (Location)transition_GuardLabel.getLayoutConstraint();
        transition_GuardLabel_Location.setX(0);
        transition_GuardLabel_Location.setY(-20);
        Node transition_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Transition_StereotypeLabel"));
        transition_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location transition_StereotypeLabel_Location = (Location)transition_StereotypeLabel.getLayoutConstraint();
        transition_StereotypeLabel_Location.setX(0);
        transition_StereotypeLabel_Location.setY(60);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Transition");
        return edge;
    }

    public Edge createGeneralization_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Generalization_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        Node generalization_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Generalization_StereotypeLabel"));
        generalization_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location generalization_StereotypeLabel_Location = (Location)generalization_StereotypeLabel.getLayoutConstraint();
        generalization_StereotypeLabel_Location.setX(0);
        generalization_StereotypeLabel_Location.setY(40);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        return edge;
    }

    public Edge createComment_AnnotatedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createConstraint_ConstrainedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createConstraint_ContextEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Constraint_ContextEdge"));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node constraint_KeywordLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Constraint_KeywordLabel"));
        constraint_KeywordLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLStateMachineDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        BasicCompartment rv = NotationFactory.eINSTANCE.createBasicCompartment();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

