/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.internal.ui.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.emf.resource.DependencyManagementHelper;
import org.eclipse.papyrus.infra.emf.resource.IURIReplacementStrategy;
import org.eclipse.papyrus.infra.emf.resource.MoveFileURIReplacementStrategy;
import org.eclipse.papyrus.infra.emf.resource.RestoreDependencyHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.onefile.internal.ui.Activator;
import org.eclipse.papyrus.infra.onefile.internal.ui.action.CopyFilesAndFoldersOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class PapyrusCopyFilesAndFoldersOperation
extends CopyFilesAndFoldersOperation {
    protected Map<String, String> renameMapping = new HashMap<String, String>();
    protected IPath[] destinationPaths = null;

    public PapyrusCopyFilesAndFoldersOperation(Shell shell) {
        super(shell);
    }

    @Override
    protected boolean performCopyWithAutoRename(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        IWorkspace workspace = resources[0].getWorkspace();
        this.destinationPaths = new IPath[resources.length];
        try {
            String oldName = "";
            String newName = "";
            int i = 0;
            while (i < resources.length) {
                IResource source = resources[i];
                this.destinationPaths[i] = destination.append(source.getName());
                IPath relativSourcePath = source.getFullPath();
                String sourceFileName = relativSourcePath.removeFileExtension().lastSegment();
                if (!oldName.isEmpty() && sourceFileName.startsWith(oldName)) {
                    this.destinationPaths[i] = this.getDestinationPath(relativSourcePath, newName, oldName);
                } else {
                    oldName = sourceFileName;
                    if (workspace.getRoot().exists(this.destinationPaths[i]) && this.destinationPaths[i].getFileExtension().equals("di")) {
                        this.destinationPaths[i] = this.getNewNameFor(this.destinationPaths[i], workspace);
                        newName = this.destinationPaths[i].removeFileExtension().lastSegment();
                    }
                    this.renameMapping.put(oldName, newName);
                }
                ++i;
            }
            CopyResourcesOperation op = new CopyResourcesOperation(resources, this.destinationPaths, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
            op.setModelProviderIds(this.getModelProviderIds());
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.messageShell));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                this.recordError((CoreException)e.getCause());
            } else {
                IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
                this.displayError(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public IPath getDestinationPath(IPath relativeSourcePath, String newName, String oldName) {
        String fileExtension = relativeSourcePath.getFileExtension();
        String sourceFileName = relativeSourcePath.removeFileExtension().lastSegment();
        String destinationFileName = sourceFileName.replace(oldName, newName);
        return relativeSourcePath.removeLastSegments(1).append(destinationFileName).addFileExtension(fileExtension);
    }

    @Override
    protected boolean performCopy(IResource[] resources, IPath destination, IProgressMonitor monitor) {
        boolean performCopy = super.performCopy(resources, destination, monitor);
        if (performCopy) {
            this.destinationPaths = new IPath[resources.length];
            int i = 0;
            while (i < resources.length) {
                String name = resources[i].getName();
                this.destinationPaths[i] = destination.append(name);
                ++i;
            }
        }
        return performCopy;
    }

    @Override
    public IResource[] copyResources(IResource[] resources, IContainer destination) {
        IResource[] copyResources = super.copyResources(resources, destination);
        try {
            List<ModelSet> modelSetList = this.initModelSet(copyResources);
            Map<URI, URI> constructInternalMapping = this.constructInternalMapping(copyResources);
            int i = 0;
            while (i < resources.length) {
                for (ModelSet modelSet : modelSetList) {
                    if (!this.checkResource(modelSet, resources[i])) continue;
                    this.restoreAllLink(modelSet, constructInternalMapping, copyResources[i], this.destinationPaths[i]);
                }
                ++i;
            }
        }
        catch (IOException e) {
            Activator.log.error("It was not possible to restore broken links", (Throwable)e);
        }
        return copyResources;
    }

    protected List<ModelSet> initModelSet(IResource[] resources) {
        ArrayList<ModelSet> modelSetList = new ArrayList<ModelSet>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            IPath fullPath = iResource.getFullPath();
            if ("di".equals(fullPath.getFileExtension()) && iResource instanceof IFile) {
                try {
                    DiResourceSet modelSet = new DiResourceSet();
                    modelSet.loadModels((IFile)iResource);
                    modelSetList.add((ModelSet)modelSet);
                }
                catch (ModelMultiException e) {
                    Activator.log.error("It was not possible to load models", (Throwable)e);
                }
            }
            ++n2;
        }
        return modelSetList;
    }

    protected boolean checkResource(ModelSet modelSet, IResource iResource) {
        URI uri = URI.createPlatformResourceURI((String)iResource.getFullPath().toString(), (boolean)Boolean.TRUE);
        Resource resource = modelSet.getResource(uri, Boolean.FALSE.booleanValue());
        return resource != null;
    }

    protected void restoreAllLink(ModelSet modelSet, Map<URI, URI> constructInternalMapping, IResource copyResources, IPath targetPath) throws IOException {
        URI uri = URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)Boolean.TRUE);
        Resource resource = modelSet.getResource(uri, Boolean.TRUE.booleanValue());
        MoveFileURIReplacementStrategy iURIReplacementStrategy = new MoveFileURIReplacementStrategy(new HashMap(), copyResources.getFullPath().removeLastSegments(1), targetPath.removeLastSegments(1));
        RestoreDependencyHelper restoreDependencyHelper = new RestoreDependencyHelper((IURIReplacementStrategy)iURIReplacementStrategy);
        restoreDependencyHelper.restoreDependencies(resource);
        for (Map.Entry<URI, URI> oneInternalCopyMapping : constructInternalMapping.entrySet()) {
            DependencyManagementHelper.updateDependencies((URI)oneInternalCopyMapping.getKey(), (URI)oneInternalCopyMapping.getValue(), (Resource)resource);
        }
        if (!resource.getURI().fileExtension().equals("properties")) {
            resource.save(ResourceUtils.getSaveOptions());
        }
        IPath fullPath = copyResources.getFullPath();
        Resource sashResource = null;
        if ("di".equals(fullPath.getFileExtension())) {
            SashModel sashModel = SashModelUtils.getSashModel((ModelSet)modelSet);
            if (sashModel != null && !constructInternalMapping.containsKey(sashModel.getURI())) {
                sashResource = sashModel.getResource();
                for (Map.Entry<URI, URI> oneInternalCopyMapping : constructInternalMapping.entrySet()) {
                    DependencyManagementHelper.updateDependencies((URI)oneInternalCopyMapping.getKey(), (URI)oneInternalCopyMapping.getValue(), (Resource)sashResource);
                }
            }
            if (sashResource != null) {
                DiResourceSet tempModelSet = new DiResourceSet();
                tempModelSet.createModels(uri);
                URI newsashModelURI = SashModelUtils.getSashModel((ModelSet)tempModelSet).getURI();
                sashResource.setURI(newsashModelURI);
                sashResource.save(ResourceUtils.getSaveOptions());
            }
        }
    }

    protected Map<URI, URI> constructInternalMapping(IResource[] copyResources) {
        HashMap<URI, URI> internalCopyMapping = new HashMap<URI, URI>();
        int j = 0;
        while (j < copyResources.length) {
            IPath targetPath = this.destinationPaths[j];
            IResource sourceResource = copyResources[j];
            URI targetURI = URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)true);
            URI sourceURI = URI.createPlatformResourceURI((String)sourceResource.getFullPath().toString(), (boolean)true);
            internalCopyMapping.put(sourceURI, targetURI);
            ++j;
        }
        return internalCopyMapping;
    }
}

