/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;
import org.eclipse.nebula.widgets.nattable.sort.event.SortColumnEvent;
import org.eclipse.swt.custom.BusyIndicator;

public class SortCommandHandler<T>
extends AbstractLayerCommandHandler<SortColumnCommand> {
    private final ISortModel sortModel;
    private final SortHeaderLayer<T> sortHeaderLayer;

    public SortCommandHandler(ISortModel sortModel, SortHeaderLayer<T> sortHeaderLayer) {
        this.sortModel = sortModel;
        this.sortHeaderLayer = sortHeaderLayer;
    }

    @Override
    public boolean doCommand(final SortColumnCommand command) {
        final int columnIndex = command.getLayer().getColumnIndexByPosition(command.getColumnPosition());
        final SortDirectionEnum newSortDirection = command.getSortDirection() != null ? command.getSortDirection() : this.sortModel.getSortDirection(columnIndex).getNextSortDirection();
        Runnable sortRunner = new Runnable(){

            @Override
            public void run() {
                SortCommandHandler.this.sortModel.sort(columnIndex, newSortDirection, command.isAccumulate());
            }
        };
        BusyIndicator.showWhile(null, (Runnable)sortRunner);
        SortColumnEvent sortEvent = new SortColumnEvent(this.sortHeaderLayer, command.getColumnPosition());
        this.sortHeaderLayer.fireLayerEvent(sortEvent);
        return true;
    }

    @Override
    public Class<SortColumnCommand> getCommandClass() {
        return SortColumnCommand.class;
    }
}

