/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.strategy;

import com.google.common.base.Strings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.infra.gmfdiag.canonical.internal.Activator;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.Registration;
import org.osgi.framework.Bundle;

abstract class EditPartBasedRegistration<T, R extends EditPartBasedRegistration<? extends T, R>>
extends Registration<T, R> {
    private static final String EDITPART = "editPart";
    private final String editPartClassName;
    private Class<?> editPartType;

    public EditPartBasedRegistration(IConfigurationElement config, Class<T> extensionType) throws CoreException {
        super(config, extensionType);
        this.editPartClassName = Strings.emptyToNull((String)config.getAttribute(EDITPART));
    }

    private Class<?> getEditPartType() {
        IConfigurationElement config;
        Bundle bundle;
        if (this.editPartType == null && this.editPartClassName != null && (bundle = Platform.getBundle((String)(config = this.getConfigurationElement()).getContributor().getName())) != null && bundle.getState() == 32) {
            try {
                this.editPartType = bundle.loadClass(this.editPartClassName).asSubclass(EditPart.class);
            }
            catch (Exception e) {
                this.editPartType = Void.class;
                Activator.log.error("Failed to load edit-part type " + this.editPartClassName, (Throwable)e);
            }
        }
        return this.editPartType;
    }

    boolean matchesEditPartType(Class<?> editPartType) {
        boolean result;
        boolean bl = result = this.editPartClassName == null;
        if (!result) {
            Class<?> myEditPartType = this.getEditPartType();
            result = myEditPartType != null && myEditPartType.isAssignableFrom(editPartType);
        }
        return result;
    }

    @Override
    public boolean isApplicableTo(EditPart editPart) {
        return this.matchesEditPartType(editPart.getClass()) && super.isApplicableTo(editPart);
    }
}

