/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.view;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.dev.types.providers.ElementTypesContentProvider;
import org.eclipse.papyrus.dev.types.providers.ElementTypesDetailsContentProvider;
import org.eclipse.papyrus.dev.types.providers.ElementTypesDetailsLabelProvider;
import org.eclipse.papyrus.dev.types.providers.ElementTypesLabelProvider;
import org.eclipse.papyrus.infra.types.core.utils.AdviceUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class RegistredElementTypesView
extends ViewPart {
    FilteredTree detailsFilteredTree = null;
    SashForm sash = null;
    FilteredTree elementTypesFilteredTree = null;
    Combo combo = null;
    ElementTypesDetailsContentProvider elementTypesDetailsContentProvider;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.combo = new Combo(parent, 0);
        final ArrayList<String> itemsList = new ArrayList<String>();
        ArrayList contexts = new ArrayList(ClientContextManager.getInstance().getClientContexts());
        int index = -1;
        int i = 0;
        for (IClientContext context : contexts) {
            itemsList.add(context.getId());
            if (context.getId().equals(ClientContextManager.getDefaultClientContext().getId())) {
                index = i;
            }
            ++i;
        }
        String[] items = new String[itemsList.size()];
        items = itemsList.toArray(items);
        this.combo.setItems(items);
        if (index != -1) {
            this.combo.select(index);
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IClientContext clientContex;
                int index = RegistredElementTypesView.this.combo.getSelectionIndex();
                String clientContexId = (String)itemsList.get(index);
                if (clientContexId != null && (clientContex = ClientContextManager.getInstance().getClientContext(clientContexId)) != null) {
                    IElementType[] elementTypes = ElementTypeRegistry.getInstance().getElementTypes(clientContex);
                    RegistredElementTypesView.this.elementTypesDetailsContentProvider.setContextID(clientContex.getId());
                    RegistredElementTypesView.this.elementTypesFilteredTree.getViewer().setInput((Object)elementTypes);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button exportButton = new Button(parent, 0);
        exportButton.setText("Export registry");
        exportButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                File file;
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                String dest = dialog.open();
                if (dest != null && (file = new File(dest)) != null) {
                    BufferedWriter writer = null;
                    try {
                        try {
                            writer = new BufferedWriter(new FileWriter(file));
                            for (String clientContexId : itemsList) {
                                writer.write(String.valueOf(clientContexId) + "\n");
                                IElementType[] elementTypes = ElementTypeRegistry.getInstance().getElementTypes(ClientContextManager.getInstance().getClientContext(clientContexId));
                                int j = 0;
                                while (j < elementTypes.length) {
                                    IEditHelperAdvice[] sortedAdvices;
                                    IElementType elementType = elementTypes[j];
                                    writer.write("\t" + elementType.getId() + "\n");
                                    IEditHelperAdvice[] advices = ElementTypeRegistry.getInstance().getEditHelperAdvice(elementType);
                                    IEditHelperAdvice[] iEditHelperAdviceArray = sortedAdvices = AdviceUtil.sort((IEditHelperAdvice[])advices, (IElementType)elementType, (String)clientContexId);
                                    int n = sortedAdvices.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IEditHelperAdvice advice = iEditHelperAdviceArray[n2];
                                        writer.write("\t\t" + advice.getClass().getName() + "\n");
                                        ++n2;
                                    }
                                    ++j;
                                }
                            }
                            writer.flush();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            try {
                                writer.close();
                            }
                            catch (Exception e12) {
                                e12.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.sash = new SashForm(parent, 256);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.elementTypesFilteredTree = new FilteredTree((Composite)this.sash, 2048, new PatternFilter(), true);
        this.elementTypesFilteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new ElementTypesLabelProvider());
        this.elementTypesFilteredTree.getViewer().setContentProvider((IContentProvider)new ElementTypesContentProvider());
        this.detailsFilteredTree = new FilteredTree((Composite)this.sash, 2048, new PatternFilter(), true);
        this.detailsFilteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new ElementTypesDetailsLabelProvider());
        this.elementTypesDetailsContentProvider = new ElementTypesDetailsContentProvider();
        this.detailsFilteredTree.getViewer().setContentProvider((IContentProvider)this.elementTypesDetailsContentProvider);
        if (index != -1) {
            this.combo.select(index);
        }
        this.elementTypesFilteredTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IElementType) {
                    RegistredElementTypesView.this.elementTypesDetailsContentProvider.setTypeID(((IElementType)selection).getId());
                    RegistredElementTypesView.this.detailsFilteredTree.getViewer().setInput(selection);
                }
            }
        });
    }

    public void setFocus() {
    }
}

