/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.p2repo.aggregator.legacy.ResourceTransformer;
import org.eclipse.cbi.p2repo.aggregator.legacy.TreePath;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class AggregatorTransformer_080_2_100
extends ResourceTransformer {
    private static final String BUILD_NODE = "Build";
    private static final String CONFIG_NODE = "Config";
    private static final String CATEGORY_NODE = "Category";
    private static final String FEATURE_NODE = "Feature";
    private static final String CONTRIBUTION_NODE = "Contribution";
    private static final String CONTACT_NODE = "Contact";
    private static final String REPOSITORY_NODE = "Repository";
    private static final String MAPPEDREPOSITORY_NODE = "MappedRepository";
    private static final String BUNDLE_NODE = "Bundle";
    private static final String PRODUCT_NODE = "Product";
    private static final String AGGREGATOR_NODE = "Aggregator";
    private static final String PLATFORMS_REF = "platforms";
    private static final String MAP_REF = "map";
    private static final String PRODUCT_REF = "Product";
    private static final String BASE_REF = "Base";
    private static final String BUILDER_REF = "Builder";
    private static final String COMPILER_REF = "compiler";
    private static final String PROMOTION_REF = "promotion";
    private static final String CONFIGS_REF = "configs";
    private static final String CONTRIBUTIONS_REF = "contributions";
    private static final String CATEGORIES_REF = "categories";
    private static final String CATEGORY_REF = "category";
    private static final String DEFAULTMAILLIST_REF = "defaultMailList";
    private static final String BUILDMASTER_REF = "buildmaster";
    private static final String CONFIGURATIONS_REF = "configurations";
    private static final String CUSTOMCATEGORIES_REF = "customCategories";
    private static final String CONTACTS_REF = "contacts";
    private static final String AGGREGATETYPE_ENUM = "ValidationSetType";
    private static final String AGGREGATOR_REF = "aggregator";
    private static final String CONFIGURATION_NODE = "Configuration";
    private static final String OS_ATTR = "os";
    private static final String WS_ATTR = "ws";
    private static final String ARCH_ATTR = "arch";
    private static final String OPERATINGSYSTEM_ATTR = "operatingSystem";
    private static final String WINDOWSYSTEM_ATTR = "windowSystem";
    private static final String ARCHITECTURE_ATTR = "architecture";
    private static final String OPERATINGSYSTEM_ENUM = "OperatingSystem";
    private static final String WINDOWSYSTEM_ENUM = "WindowSystem";
    private static final String ARCHITECTURE_ENUM = "Architecture";
    private static final String NAME_ATTR = "name";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String CUSTOMCATEGORY_NODE = "CustomCategory";
    private static final String REPOSITORIES_REF = "repositories";
    private static final String FEATURES_REF = "features";
    private static final String BUNDLES_REF = "bundles";
    private static final String PRODUCTS_REF = "products";
    private static final String REPO_REF = "repo";
    private static final String LABEL_ATTR = "label";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String ID_ATTR = "id";
    private static final String VERSION_ATTR = "version";
    private static final String VERSIONRANGE_ATTR = "versionRange";
    private static final String ENABLED_ATTR = "enabled";
    private static final String EMAIL_ATTR = "email";
    private List<EObject> srcCategories = new ArrayList<EObject>();
    private List<EObject> srcContributions = new ArrayList<EObject>();
    private List<EObject> srcIUsWithoutRepo = new ArrayList<EObject>();
    private Map<String, EObject> trgtEmailToContactMap = new HashMap<String, EObject>();
    private EReference srcIURepoRef;

    @Override
    protected void doTransform(EObject srcEObject, TreePath trgtParentTreePath) {
        EClass scrEClass = srcEObject.eClass();
        if (BUILD_NODE.equals(scrEClass.getName())) {
            this.transformBuildNode(srcEObject, trgtParentTreePath);
        } else if (CONTACT_NODE.equals(scrEClass.getName())) {
            this.transformContactNode(srcEObject, trgtParentTreePath);
        } else if (CONFIG_NODE.equals(scrEClass.getName())) {
            this.transformConfigNode(srcEObject, trgtParentTreePath);
        } else if (CATEGORY_NODE.equals(scrEClass.getName())) {
            this.transformCategoryNode(srcEObject, trgtParentTreePath);
        } else if (CONTRIBUTION_NODE.equals(scrEClass.getName())) {
            this.transformContributionNode(srcEObject, trgtParentTreePath);
        } else if (REPOSITORY_NODE.equals(scrEClass.getName())) {
            this.transformRepositoryNode(srcEObject, trgtParentTreePath);
        } else if (FEATURE_NODE.equals(scrEClass.getName())) {
            this.transformIUNode(srcEObject, trgtParentTreePath, FEATURE_NODE);
        } else if (BUNDLE_NODE.equals(scrEClass.getName())) {
            this.transformIUNode(srcEObject, trgtParentTreePath, BUNDLE_NODE);
        } else if ("Product".equals(scrEClass.getName())) {
            this.transformIUNode(srcEObject, trgtParentTreePath, "Product");
        }
    }

    @Override
    protected void doTransformRef(EObject srcEObject) {
        this.transformCategoryRef();
    }

    private void collectSrcIUs(Map<EObject, List<EObject>> srcRepositoryToIUsMap, List<EObject> srcRepositories, List<EObject> ius) {
        for (EObject iu : ius) {
            List<EObject> srcRepoIUs;
            EObject srcRepo = (EObject)iu.eGet((EStructuralFeature)this.getSrcIURepoRef(iu));
            if (srcRepo == null) {
                this.srcIUsWithoutRepo.add(iu);
                continue;
            }
            if (!srcRepositories.contains(srcRepo)) {
                srcRepositories.add(srcRepo);
            }
            if ((srcRepoIUs = srcRepositoryToIUsMap.get(srcRepo)) == null) {
                srcRepoIUs = new ArrayList<EObject>();
                srcRepositoryToIUsMap.put(srcRepo, srcRepoIUs);
            }
            srcRepoIUs.add(iu);
        }
    }

    private void copyBuildNodeAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null || (trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(srcEAttr.getName())) == null) continue;
            if ("type".equals(srcEAttr.getName())) {
                Object trgtEAttrValue = this.createTrgtEEnumLiteral(AGGREGATETYPE_ENUM, ((EEnumLiteral)srcEAttrValue).getLiteral());
                trgtEObject.eSet((EStructuralFeature)trgtEAttr, trgtEAttrValue);
                continue;
            }
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, srcEAttrValue);
        }
    }

    private void copyCategoryNodeAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null) continue;
            String trgtEAttrName = srcEAttr.getName();
            if (NAME_ATTR.equals(trgtEAttrName)) {
                trgtEAttrName = IDENTIFIER_ATTR;
            }
            if ((trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(trgtEAttrName)) == null) continue;
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, srcEAttrValue);
        }
    }

    private void copyConfigNodeAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            Object trgtEAttrValue;
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null) continue;
            if (OS_ATTR.equals(srcEAttr.getName())) {
                trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(OPERATINGSYSTEM_ATTR);
                trgtEAttrValue = this.createTrgtEEnumLiteral(OPERATINGSYSTEM_ENUM, ((EEnumLiteral)srcEAttrValue).getLiteral());
                trgtEObject.eSet((EStructuralFeature)trgtEAttr, trgtEAttrValue);
                continue;
            }
            if (WS_ATTR.equals(srcEAttr.getName())) {
                trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(WINDOWSYSTEM_ATTR);
                trgtEAttrValue = this.createTrgtEEnumLiteral(WINDOWSYSTEM_ENUM, ((EEnumLiteral)srcEAttrValue).getLiteral());
                trgtEObject.eSet((EStructuralFeature)trgtEAttr, trgtEAttrValue);
                continue;
            }
            if (!ARCH_ATTR.equals(srcEAttr.getName())) continue;
            trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(ARCHITECTURE_ATTR);
            trgtEAttrValue = this.createTrgtEEnumLiteral(ARCHITECTURE_ENUM, ((EEnumLiteral)srcEAttrValue).getLiteral());
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, trgtEAttrValue);
        }
    }

    private void copyIUNodeAttributes(EObject srcEObject, EObject trgtEObject, String iuNodeName) {
        EAttribute srcIdEAttr = (EAttribute)srcEObject.eClass().getEStructuralFeature(ID_ATTR);
        String srcIdEAttrValue = (String)srcEObject.eGet((EStructuralFeature)srcIdEAttr);
        if (iuNodeName == FEATURE_NODE && srcIdEAttrValue != null) {
            srcIdEAttrValue = String.valueOf(srcIdEAttrValue) + ".feature.group";
        }
        EAttribute trgtNameEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(NAME_ATTR);
        trgtEObject.eSet((EStructuralFeature)trgtNameEAttr, (Object)srcIdEAttrValue);
        EAttribute srcVersionEAttr = (EAttribute)srcEObject.eClass().getEStructuralFeature(VERSION_ATTR);
        String srcVersionEAttrValue = (String)srcEObject.eGet((EStructuralFeature)srcVersionEAttr);
        EAttribute trgtVersionRangeEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(VERSIONRANGE_ATTR);
        if (srcVersionEAttrValue != null) {
            VersionRange vr = new VersionRange(Version.create((String)srcVersionEAttrValue), true, null, true);
            trgtEObject.eSet((EStructuralFeature)trgtVersionRangeEAttr, (Object)vr);
        }
    }

    private void copyRepositoryNodeAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null) continue;
            String trgtEAttrName = srcEAttr.getName();
            if (LABEL_ATTR.equals(trgtEAttrName)) {
                trgtEAttrName = DESCRIPTION_ATTR;
            }
            if ((trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(trgtEAttrName)) == null) continue;
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, srcEAttrValue);
        }
    }

    private EReference getSrcIURepoRef(EObject iu) {
        if (this.srcIURepoRef == null) {
            this.srcIURepoRef = (EReference)iu.eClass().getEStructuralFeature(REPO_REF);
        }
        return this.srcIURepoRef;
    }

    private void transformBuildNode(EObject srcEObject, TreePath trgtParentTreePath) {
        EObject aggregatorEObject = this.createTrgtEObject(AGGREGATOR_NODE, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(aggregatorEObject);
        this.copyBuildNodeAttributes(srcEObject, aggregatorEObject);
        List<String> unsupportedRefs = Arrays.asList(PLATFORMS_REF, MAP_REF, "Product", BASE_REF, BUILDER_REF, COMPILER_REF, PROMOTION_REF);
        for (EReference srcERef : srcEObject.eClass().getEAllContainments()) {
            Object srcERefValue;
            if (unsupportedRefs.contains(srcERef.getName()) || (srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef)) == null) continue;
            EReference trgtERef = null;
            if (CONFIGS_REF.equals(srcERef.getName())) {
                trgtERef = (EReference)aggregatorEObject.eClass().getEStructuralFeature(CONFIGURATIONS_REF);
            } else if (CONTRIBUTIONS_REF.equals(srcERef.getName())) {
                trgtERef = (EReference)aggregatorEObject.eClass().getEStructuralFeature(CONTRIBUTIONS_REF);
            } else if (CATEGORIES_REF.equals(srcERef.getName())) {
                trgtERef = (EReference)aggregatorEObject.eClass().getEStructuralFeature(CUSTOMCATEGORIES_REF);
            } else {
                if (!DEFAULTMAILLIST_REF.equals(srcERef.getName()) && !BUILDMASTER_REF.equals(srcERef.getName())) continue;
                trgtERef = (EReference)aggregatorEObject.eClass().getEStructuralFeature(CONTACTS_REF);
            }
            TreePath trgtTreePath = trgtParentTreePath.createChildTreePath(aggregatorEObject, trgtERef);
            if (!srcERef.isMany()) {
                this.transform((EObject)srcERefValue, trgtTreePath);
            } else {
                for (EObject srcChild : (List)srcERefValue) {
                    this.transform(srcChild, trgtTreePath);
                }
            }
            if (!BUILDMASTER_REF.equals(srcERef.getName())) continue;
            EReference buildmasterERef = (EReference)aggregatorEObject.eClass().getEStructuralFeature(BUILDMASTER_REF);
            aggregatorEObject.eSet((EStructuralFeature)buildmasterERef, this.transformationMapping.get(srcERefValue));
        }
    }

    private void transformCategoryNode(EObject srcEObject, TreePath trgtParentTreePath) {
        EObject categoryEobject = this.createTrgtEObject(CUSTOMCATEGORY_NODE, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(categoryEobject);
        this.copyCategoryNodeAttributes(srcEObject, categoryEobject);
        this.srcCategories.add(srcEObject);
    }

    private void transformCategoryRef() {
        EClass scrEClass = null;
        EReference srcERef = null;
        EClass trgtEClass = null;
        EReference trgtERef = null;
        EReference trgtCategoriesERef = null;
        for (EObject srcCategory : this.srcCategories) {
            Object srcERefValue;
            EObject trgtCategory = (EObject)this.transformationMapping.get(srcCategory);
            if (scrEClass == null) {
                scrEClass = srcCategory.eClass();
                srcERef = (EReference)scrEClass.getEStructuralFeature(FEATURES_REF);
                trgtEClass = trgtCategory.eClass();
                trgtERef = (EReference)trgtEClass.getEStructuralFeature(FEATURES_REF);
            }
            if ((srcERefValue = srcCategory.eGet(srcERef)) == null) continue;
            List trgtCategoryFeatureList = (List)trgtCategory.eGet(trgtERef);
            for (EObject srcFeature : (List)srcERefValue) {
                EObject srcContribution = srcFeature.eContainer();
                if (!this.srcContributions.contains(srcContribution)) {
                    String srcCategoryName = (String)AggregatorTransformer_080_2_100.getFeatureValue(srcCategory, NAME_ATTR);
                    String srcContributionLabel = (String)AggregatorTransformer_080_2_100.getFeatureValue(srcContribution, LABEL_ATTR);
                    String srcFeatureId = (String)AggregatorTransformer_080_2_100.getFeatureValue(srcFeature, ID_ATTR);
                    throw new RuntimeException("Category " + srcCategoryName + " references feature " + srcFeatureId + " which belongs to a missing contribution " + srcContributionLabel);
                }
                if (this.srcIUsWithoutRepo.contains(srcFeature)) continue;
                EObject trgtFeature = (EObject)this.transformationMapping.get(srcFeature);
                if (trgtFeature == null) {
                    String srcIUId = (String)AggregatorTransformer_080_2_100.getFeatureValue(srcFeature, ID_ATTR);
                    String srcCategoryName = (String)AggregatorTransformer_080_2_100.getFeatureValue(srcCategory, NAME_ATTR);
                    throw new RuntimeException("Feature " + srcIUId + " is located in category " + srcCategoryName + " but not in any contribution");
                }
                if (trgtCategoriesERef == null) {
                    trgtCategoriesERef = (EReference)trgtFeature.eClass().getEStructuralFeature(CATEGORIES_REF);
                }
                List trgtFeatureCategoryList = (List)trgtFeature.eGet(trgtCategoriesERef);
                trgtFeatureCategoryList.add(trgtCategory);
                trgtCategoryFeatureList.add(trgtFeature);
            }
        }
        EReference srcFeaturesERef = null;
        EReference srcCategoriesERef = null;
        EReference trgtCategoriesERef2 = null;
        EReference trgtFeaturesERef = null;
        for (EObject srcContribution : this.srcContributions) {
            if (srcFeaturesERef == null) {
                srcFeaturesERef = (EReference)srcContribution.eClass().getEStructuralFeature(FEATURES_REF);
            }
            for (EObject srcFeature : (List)srcContribution.eGet(srcFeaturesERef)) {
                EObject trgtFeature;
                if (srcCategoriesERef == null) {
                    srcCategoriesERef = (EReference)srcFeature.eClass().getEStructuralFeature(CATEGORY_REF);
                }
                if ((trgtFeature = (EObject)this.transformationMapping.get(srcFeature)) == null) continue;
                if (trgtCategoriesERef2 == null) {
                    trgtCategoriesERef2 = (EReference)trgtFeature.eClass().getEStructuralFeature(CATEGORIES_REF);
                }
                List trgtFeatureCategoryList = (List)trgtFeature.eGet(trgtCategoriesERef2);
                for (EObject srcCategory : (List)srcFeature.eGet((EStructuralFeature)srcCategoriesERef)) {
                    List trgtCategoryFeatureList;
                    EObject trgtCategory = (EObject)this.transformationMapping.get(srcCategory);
                    if (trgtCategory == null) continue;
                    if (trgtFeaturesERef == null) {
                        trgtFeaturesERef = (EReference)trgtCategory.eClass().getEStructuralFeature(FEATURES_REF);
                    }
                    if (!(trgtCategoryFeatureList = (List)trgtCategory.eGet(trgtFeaturesERef)).contains(trgtFeature)) {
                        trgtCategoryFeatureList.add(trgtFeature);
                    }
                    if (trgtFeatureCategoryList.contains(trgtCategory)) continue;
                    trgtFeatureCategoryList.add(trgtCategory);
                }
            }
        }
    }

    private void transformConfigNode(EObject srcEObject, TreePath trgtParentTreePath) {
        EObject configurationEobject = this.createTrgtEObject(CONFIGURATION_NODE, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(configurationEobject);
        this.copyConfigNodeAttributes(srcEObject, configurationEobject);
        EAttribute enabledEAttr = (EAttribute)configurationEobject.eClass().getEStructuralFeature(ENABLED_ATTR);
        configurationEobject.eSet((EStructuralFeature)enabledEAttr, (Object)Boolean.TRUE);
    }

    private void transformContactNode(EObject srcEObject, TreePath trgtParentTreePath) {
        EObject contactEObject = this.createTrgtEObject(CONTACT_NODE, srcEObject);
        this.copyAttributes(srcEObject, contactEObject);
        String email = (String)AggregatorTransformer_080_2_100.getFeatureValue(contactEObject, EMAIL_ATTR);
        EObject trgtRetrievedContact = this.trgtEmailToContactMap.get(email);
        if (trgtRetrievedContact != null) {
            this.transformationMapping.put(srcEObject, trgtRetrievedContact);
        } else {
            this.trgtEmailToContactMap.put(email, contactEObject);
            trgtParentTreePath.addToLastSegmentContainer(contactEObject);
            EReference aggrERef = (EReference)contactEObject.eClass().getEStructuralFeature(AGGREGATOR_REF);
            contactEObject.eSet((EStructuralFeature)aggrERef, (Object)trgtParentTreePath.getSegment(AGGREGATOR_NODE));
        }
    }

    private void transformContributionNode(EObject srcEObject, TreePath trgtParentTreePath) {
        if (this.srcContributions.contains(srcEObject)) {
            return;
        }
        EAttribute srcLabelEAttr = (EAttribute)srcEObject.eClass().getEStructuralFeature(LABEL_ATTR);
        String srcLabel1 = (String)srcEObject.eGet((EStructuralFeature)srcLabelEAttr);
        for (EObject contribution : this.srcContributions) {
            String srcLabel2 = (String)contribution.eGet((EStructuralFeature)srcLabelEAttr);
            if (srcLabel1 == null || !srcLabel1.equals(srcLabel2)) continue;
            throw new IllegalArgumentException("Label " + srcLabel1 + " is used for more than one contribution");
        }
        EObject contributionEObject = this.createTrgtEObject(CONTRIBUTION_NODE, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(contributionEObject);
        this.copyAttributes(srcEObject, contributionEObject);
        this.srcContributions.add(srcEObject);
        EAttribute enabledEAttr = (EAttribute)contributionEObject.eClass().getEStructuralFeature(ENABLED_ATTR);
        contributionEObject.eSet((EStructuralFeature)enabledEAttr, (Object)Boolean.TRUE);
        ArrayList<EObject> srcRepositories = new ArrayList<EObject>();
        HashMap<EObject, List<EObject>> srcRepositoryToFeturesMap = new HashMap<EObject, List<EObject>>();
        HashMap<EObject, List<EObject>> srcRepositoryToBundlesMap = new HashMap<EObject, List<EObject>>();
        HashMap<EObject, List<EObject>> srcRepositoryToProductsMap = new HashMap<EObject, List<EObject>>();
        for (EReference srcERef : srcEObject.eClass().getEAllContainments()) {
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef);
            if (srcERefValue == null) continue;
            EReference trgtERef = null;
            TreePath trgtTreePath = null;
            if (REPOSITORIES_REF.equals(srcERef.getName())) {
                for (EObject srcRepo : (List)srcERefValue) {
                    if (srcRepositories.contains(srcRepo)) continue;
                    srcRepositories.add(srcRepo);
                }
                continue;
            }
            if (FEATURES_REF.equals(srcERef.getName())) {
                this.collectSrcIUs(srcRepositoryToFeturesMap, srcRepositories, (List)srcERefValue);
                continue;
            }
            if (BUNDLES_REF.equals(srcERef.getName())) {
                this.collectSrcIUs(srcRepositoryToBundlesMap, srcRepositories, (List)srcERefValue);
                continue;
            }
            if (PRODUCTS_REF.equals(srcERef.getName())) {
                this.collectSrcIUs(srcRepositoryToProductsMap, srcRepositories, (List)srcERefValue);
                continue;
            }
            if (!CONTACTS_REF.equals(srcERef.getName())) continue;
            EObject aggregatorEobject = trgtParentTreePath.getSegment(AGGREGATOR_NODE);
            trgtERef = (EReference)aggregatorEobject.eClass().getEStructuralFeature(CONTACTS_REF);
            trgtTreePath = trgtParentTreePath.createChildTreePath(aggregatorEobject, trgtERef);
            for (EObject srcChild : (List)srcERefValue) {
                this.transform(srcChild, trgtTreePath);
            }
            EReference contactsERef = (EReference)contributionEObject.eClass().getEStructuralFeature(CONTACTS_REF);
            List contactsERefValues = (List)contributionEObject.eGet((EStructuralFeature)contactsERef);
            for (EObject srcChild : (List)srcERefValue) {
                contactsERefValues.add((EObject)this.transformationMapping.get(srcChild));
            }
        }
        EReference trgtERef = (EReference)contributionEObject.eClass().getEStructuralFeature(REPOSITORIES_REF);
        TreePath trgtRepositoryTreePath = trgtParentTreePath.createChildTreePath(contributionEObject, trgtERef);
        for (EObject srcRepo : srcRepositories) {
            this.transform(srcRepo, trgtRepositoryTreePath);
        }
        for (EObject srcRepositoryEObject : srcRepositories) {
            this.transformRepoIUs(trgtRepositoryTreePath, srcRepositoryEObject, srcRepositoryToFeturesMap, FEATURES_REF);
            this.transformRepoIUs(trgtRepositoryTreePath, srcRepositoryEObject, srcRepositoryToBundlesMap, BUNDLES_REF);
            this.transformRepoIUs(trgtRepositoryTreePath, srcRepositoryEObject, srcRepositoryToProductsMap, PRODUCTS_REF);
        }
    }

    private void transformIUNode(EObject srcEObject, TreePath trgtParentTreePath, String iuNodeName) {
        EObject iuEObject = this.createTrgtEObject(iuNodeName, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(iuEObject);
        this.copyIUNodeAttributes(srcEObject, iuEObject, iuNodeName);
        EAttribute enabledEAttr = (EAttribute)iuEObject.eClass().getEStructuralFeature(ENABLED_ATTR);
        iuEObject.eSet((EStructuralFeature)enabledEAttr, (Object)Boolean.TRUE);
        trgtParentTreePath.getLastSegment().eSet((EStructuralFeature)enabledEAttr, (Object)Boolean.TRUE);
    }

    private void transformRepoIUs(TreePath trgtRepositoryTreePath, EObject srcRepositoryEObject, Map<EObject, List<EObject>> srcRepositoryToIUsMap, String trgtIURefName) {
        List<EObject> srcIUs = srcRepositoryToIUsMap.get(srcRepositoryEObject);
        if (srcIUs == null) {
            return;
        }
        EObject trgtRepositoryEObject = (EObject)this.transformationMapping.get(srcRepositoryEObject);
        EReference trgtERef = (EReference)trgtRepositoryEObject.eClass().getEStructuralFeature(trgtIURefName);
        TreePath trgtTreePath = trgtRepositoryTreePath.createChildTreePath(trgtRepositoryEObject, trgtERef);
        for (EObject srcIU : srcIUs) {
            this.transform(srcIU, trgtTreePath);
        }
    }

    private void transformRepositoryNode(EObject srcEObject, TreePath trgtParentTreePath) {
        EObject repositoryEObject = this.createTrgtEObject(MAPPEDREPOSITORY_NODE, srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(repositoryEObject);
        this.copyRepositoryNodeAttributes(srcEObject, repositoryEObject);
        EAttribute enabledEAttr = (EAttribute)repositoryEObject.eClass().getEStructuralFeature(ENABLED_ATTR);
        repositoryEObject.eSet((EStructuralFeature)enabledEAttr, (Object)Boolean.FALSE);
    }
}

