/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.ui.properties.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.papyrus.uml.profile.index.ProfileWorkspaceModelIndex;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.StereotypePropertyReferenceEdgeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.ui.properties.widgets.FeatureToSetNameValueEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class FeatureToSetNamePropertyEditor
extends AbstractPropertyEditor {
    private FeatureToSetNameValueEditor editor;
    private AdapterFactoryEditingDomain domain;

    public FeatureToSetNamePropertyEditor(Composite parent, int style) {
        this.editor = new FeatureToSetNameValueEditor(parent, style);
        this.setEditor((AbstractValueEditor)this.editor);
    }

    protected void setObjectToApply() {
        Object firstElement;
        if (this.domain != null && (firstElement = this.input.getSelection().getFirstElement()) instanceof EObject) {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            profiles.addAll(this.getWorkspaceProfiles());
            List registeredProfiles = RegisteredProfile.getRegisteredProfiles();
            for (IRegisteredProfile iRegisteredProfile : registeredProfiles) {
                Profile profile2 = this.getProfile(iRegisteredProfile);
                if (profile2 == null) continue;
                profiles.add(profile2);
            }
            ArrayList allStereotypes = new ArrayList();
            for (Profile profile3 : profiles) {
                allStereotypes.addAll(StereotypeUtil.getAllStereotypes((Profile)profile3));
            }
            boolean editorSet = false;
            Iterator stereotypes = allStereotypes.iterator();
            while (!editorSet && stereotypes.hasNext()) {
                Stereotype stereotype = (Stereotype)stereotypes.next();
                EObject eContainer = ((EObject)firstElement).eContainer();
                String stereotypeQualifiedName = null;
                if (eContainer instanceof StereotypeToApply) {
                    stereotypeQualifiedName = ((StereotypeToApply)eContainer).getStereotypeQualifiedName();
                } else if (firstElement instanceof StereotypePropertyReferenceEdgeAdviceConfiguration) {
                    stereotypeQualifiedName = ((StereotypePropertyReferenceEdgeAdviceConfiguration)firstElement).getStereotypeQualifiedName();
                }
                if (stereotypeQualifiedName != null && stereotypeQualifiedName.equals(stereotype.getQualifiedName())) {
                    this.editor.setSourceStereotype(stereotype);
                    editorSet = true;
                }
                profiles.forEach(profile -> {
                    Resource eResource = profile.eResource();
                    if (eResource != null && eResource.isLoaded()) {
                        eResource.unload();
                    }
                });
            }
        }
    }

    protected Collection<Profile> getWorkspaceProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        Collection workspaceProfilesURIs = ProfileWorkspaceModelIndex.getInstance().getWorkspaceProfilesURIs();
        Iterator iterator = workspaceProfilesURIs.iterator();
        while (iterator.hasNext()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = (URI)iterator.next();
            Resource createResource = resourceSet.getResource(uri, true);
            if (!createResource.getContents().isEmpty() && createResource.getContents().get(0) instanceof Profile) {
                profiles.add((Profile)createResource.getContents().get(0));
                continue;
            }
            createResource.unload();
        }
        return profiles;
    }

    protected Profile getProfile(IRegisteredProfile registeredProfile) {
        URI uri = registeredProfile.getUri();
        Resource resource = this.domain.getResourceSet().getResource(uri, true);
        Profile profile = null;
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Profile) {
            profile = (Profile)resource.getContents().get(0);
        } else {
            resource.unload();
        }
        return profile;
    }

    public void setProperty(String path) {
        super.setProperty(path);
        this.setDomain();
        this.setObjectToApply();
    }

    public void setInput(DataSource input) {
        super.setInput(input);
        this.setDomain();
        this.setObjectToApply();
    }

    private void setDomain() {
        if (this.propertyPath != null && this.input != null) {
            ModelElement modelElement = this.input.getModelElement(this.propertyPath);
            EMFHelper.resolveEditingDomain((Object)this.input.getSelection().getFirstElement());
            if (modelElement instanceof EMFModelElement) {
                this.domain = (AdapterFactoryEditingDomain)((EMFModelElement)modelElement).getDomain();
            }
        }
    }
}

