/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ClassifiedURIImpl;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BasicPluginXMLResourceProvider
implements OpaqueResourceProvider.XML {
    private final Object resourceClassifier;
    private final String diagnosticSource;
    private final String extensionPoint;
    private final String elementName;
    private final String attributeName;
    private final OpaqueResourceProvider.URIAccessor<Element, String, String> uriAccessor;
    private final Function<IProject, URI> baseURIFunction;

    BasicPluginXMLResourceProvider(Object resourceClassifier, String diagnosticSource, String extensionPoint, String elementName, String attributeName) {
        this(resourceClassifier, diagnosticSource, extensionPoint, elementName, attributeName, BasicPluginXMLResourceProvider::getURI);
    }

    BasicPluginXMLResourceProvider(Object resourceClassifier, String diagnosticSource, String extensionPoint, String elementName, String attributeName, OpaqueResourceProvider.URIAccessor<Element, String, String> uriAccessor) {
        this.resourceClassifier = resourceClassifier;
        this.diagnosticSource = diagnosticSource;
        this.extensionPoint = extensionPoint;
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.uriAccessor = uriAccessor;
        Function<IProject, String> projectBundle = project -> Optional.ofNullable(PluginRegistry.findModel((IProject)project)).map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName).orElse(project.getName());
        this.baseURIFunction = project -> URI.createPlatformResourceURI((String)((String)projectBundle.apply((IProject)project)), (boolean)true).appendSegment("");
    }

    @Override
    public Iterable<OpaqueResourceProvider.ClassifiedURI> getOpaqueResourceReferences(IProject modelProject, IFile modelFile, Element object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.elementName.equals(object.getNodeName())) {
            return List.of();
        }
        if (!this.isInExtensionPoint(object)) {
            return List.of();
        }
        String value = object.getAttribute(this.attributeName);
        if (Strings.isNullOrEmpty((String)value)) {
            return List.of();
        }
        return Iterables.filter(List.of(this.resolveURI(modelProject, object, value, diagnostics, context)), Objects::nonNull);
    }

    private boolean isInExtensionPoint(Element element) {
        boolean result = false;
        Node parent = element.getParentNode();
        while (!result && parent instanceof Element) {
            result = this.isExtensionPoint((Element)parent);
            parent = parent.getParentNode();
        }
        return result;
    }

    private boolean isExtensionPoint(Element element) {
        return "extension".equals(element.getNodeName()) && this.extensionPoint.equals(element.getAttribute("point"));
    }

    OpaqueResourceProvider.ClassifiedURI resolveURI(IProject project, Element element, String attributeValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        URI result;
        try {
            result = this.uriAccessor.getURI(element, this.attributeName, attributeValue);
        }
        catch (Exception e) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, this.diagnosticSource, 0, NLS.bind((String)Messages.BasicPluginXMLResourceProvider_0, (Object[])new Object[]{element.getNodeName(), this.resourceClassifier, attributeValue}), null);
            diagnostics.add((Diagnostic)diagnostic);
            return null;
        }
        if (result.isRelative()) {
            result = result.resolve(this.baseURIFunction.apply(project));
        }
        if (result.isPlatformResource()) {
            Path path = new Path(result.toPlatformString(true));
            IResource resource = project.getParent().findMember((IPath)path);
            if (resource == null || !resource.isAccessible() || resource.getType() != 1) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, this.diagnosticSource, 0, NLS.bind((String)Messages.BasicPluginXMLResourceProvider_1, (Object[])new Object[]{result.lastSegment(), element.getNodeName(), this.resourceClassifier}), null);
                diagnostics.add((Diagnostic)diagnostic);
                return null;
            }
        }
        return new ClassifiedURIImpl(result, this.resourceClassifier);
    }

    static URI getURI(Element owner, String attribute, String value) {
        return Strings.isNullOrEmpty((String)value) ? URI.createURI((String)"") : URI.createURI((String)value, (boolean)true);
    }
}

