/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.SetAllBendpointRequest;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.ConnectionBendpointEditPolicy3;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.SetAbsoluteBendpointsCommand;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.router.HintedOrthogonalRouter;

public class LinksLFConnectionBendpointEditPolicy
extends ConnectionBendpointEditPolicy3 {
    private static final String PARAM_CACHED_COMMAND_BASED_ON_FEEDBACK = String.valueOf(LinksLFConnectionBendpointEditPolicy.class.getName()) + ":CachedCommand";
    private boolean myIsShowingFeedback;

    public LinksLFConnectionBendpointEditPolicy(LineMode lineMode) {
        super(lineMode);
    }

    public LinksLFConnectionBendpointEditPolicy() {
        this(LineMode.OBLIQUE);
    }

    @Override
    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        Command cachedPreviousCommand = (Command)request.getExtendedData().remove(PARAM_CACHED_COMMAND_BASED_ON_FEEDBACK);
        if (cachedPreviousCommand != null && !this.myIsShowingFeedback) {
            return cachedPreviousCommand;
        }
        Command result = super.getBendpointsChangedCommand(request);
        if (this.myIsShowingFeedback) {
            request.getExtendedData().put(PARAM_CACHED_COMMAND_BASED_ON_FEEDBACK, result);
        }
        return result;
    }

    @Override
    protected Command getBendpointsChangedCommand(Connection connection, Edge edge) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef1);
        SetConnectionAnchorsCommand srcAnchorUpdate = null;
        if (this.getHost().getSource() instanceof INodeEditPart && connection.getPoints().size() > 1) {
            ptRef1 = connection.getPoints().getFirstPoint();
            INodeEditPart sourceEP = (INodeEditPart)this.getHost().getSource();
            ReconnectRequest reconnectSource = new ReconnectRequest((Object)"Reconnection source");
            Point ptAbs1 = ptRef1.getCopy();
            this.getConnection().translateToAbsolute((Translatable)ptAbs1);
            reconnectSource.setLocation(ptAbs1);
            reconnectSource.setConnectionEditPart(this.getHost());
            ConnectionAnchor newAnchor = sourceEP.getSourceConnectionAnchor((Request)reconnectSource);
            String newTerminal = sourceEP.mapConnectionAnchorToTerminal(newAnchor);
            srcAnchorUpdate = new SetConnectionAnchorsCommand(editingDomain, "Updating source anchor");
            srcAnchorUpdate.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)edge));
            srcAnchorUpdate.setNewSourceTerminal(newTerminal);
        }
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)ptRef2);
        SetConnectionAnchorsCommand trgAnchorUpdate = null;
        if (this.getHost().getTarget() instanceof INodeEditPart && connection.getPoints().size() > 1) {
            ptRef2 = connection.getPoints().getLastPoint();
            INodeEditPart targetEP = (INodeEditPart)this.getHost().getTarget();
            ReconnectRequest reconnectTarget = new ReconnectRequest((Object)"Reconnection target");
            Point ptAbs2 = ptRef2.getCopy();
            this.getConnection().translateToAbsolute((Translatable)ptAbs2);
            reconnectTarget.setLocation(ptAbs2);
            reconnectTarget.setConnectionEditPart(this.getHost());
            ConnectionAnchor newTargetAnchor = targetEP.getTargetConnectionAnchor((Request)reconnectTarget);
            String newTerminal = targetEP.mapConnectionAnchorToTerminal(newTargetAnchor);
            trgAnchorUpdate = new SetConnectionAnchorsCommand(editingDomain, "Updating target anchor");
            trgAnchorUpdate.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)edge));
            trgAnchorUpdate.setNewTargetTerminal(newTerminal);
        }
        SetAbsoluteBendpointsCommand sbbCommand = new SetAbsoluteBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)edge));
        sbbCommand.setNewPointList(connection.getPoints());
        SetAbsoluteBendpointsCommand result = sbbCommand;
        if (srcAnchorUpdate != null) {
            result = result.compose((IUndoableOperation)srcAnchorUpdate);
        }
        if (trgAnchorUpdate != null) {
            result = result.compose((IUndoableOperation)trgAnchorUpdate);
        }
        return new ICommandProxy(result.reduce());
    }

    @Override
    protected Command getSetBendpointCommand(SetAllBendpointRequest request) {
        Connection connection = this.getConnection();
        PointList newPoints = request.getPoints();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetAbsoluteBendpointsCommand sbbCommand = new SetAbsoluteBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)((Edge)this.getHost().getModel())));
        if (request.getSourceReference() != null && request.getTargetReference() != null) {
            sbbCommand.setNewPointList(newPoints, request.getSourceReference(), request.getTargetReference());
        } else {
            sbbCommand.setNewPointList(newPoints, connection.getSourceAnchor(), connection.getTargetAnchor());
        }
        return new ICommandProxy((ICommand)sbbCommand);
    }

    public ConnectionEditPart getHost() {
        return (ConnectionEditPart)super.getHost();
    }

    @Override
    protected Connection getConnection() {
        return super.getConnection();
    }

    @Override
    protected void showOutsideSourceFeedback(LineSeg newLine, LineSeg moveLine, List constraint) {
        Connection conn = (Connection)this.getHostFigure();
        ConnectionAnchor anchor = conn.getSourceAnchor();
        PrecisionRectangle bounds = new PrecisionRectangle(anchor.getOwner().getBounds());
        anchor.getOwner().translateToAbsolute((Translatable)bounds);
        PrecisionPoint startPoint = new PrecisionPoint(anchor.getOwner().getBounds().getCenter());
        anchor.getOwner().translateToAbsolute((Translatable)startPoint);
        this.snapToGrid(startPoint, moveLine.isHorizontal(), bounds);
        conn.translateToRelative((Translatable)startPoint);
        conn.translateToRelative((Translatable)bounds);
        Point origin = new Point(newLine.getOrigin());
        if (moveLine.isHorizontal()) {
            origin.x = startPoint.x;
        } else {
            origin.y = startPoint.y;
        }
        newLine.setOrigin(origin);
        constraint.add(0, new AbsoluteBendpoint((Point)startPoint));
    }

    @Override
    protected void showOutsideTargetFeedback(LineSeg newLine, LineSeg moveLine, List constraint) {
        Connection conn = (Connection)this.getHostFigure();
        ConnectionAnchor anchor = conn.getTargetAnchor();
        PrecisionRectangle bounds = new PrecisionRectangle(anchor.getOwner().getBounds());
        anchor.getOwner().translateToAbsolute((Translatable)bounds);
        PrecisionPoint endPoint = new PrecisionPoint(anchor.getOwner().getBounds().getCenter());
        anchor.getOwner().translateToAbsolute((Translatable)endPoint);
        this.snapToGrid(endPoint, moveLine.isHorizontal(), bounds);
        conn.translateToRelative((Translatable)endPoint);
        conn.translateToRelative((Translatable)bounds);
        Point terminus = new Point(newLine.getTerminus());
        if (moveLine.isHorizontal()) {
            terminus.x = endPoint.x;
        } else {
            terminus.y = endPoint.y;
        }
        newLine.setTerminus(terminus);
        constraint.add(new AbsoluteBendpoint((Point)endPoint));
    }

    protected void snapToGrid(PrecisionPoint point, boolean horizontally, PrecisionRectangle limitingBounds) {
        SnapToHelper snapper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
        if (snapper == null) {
            return;
        }
        PrecisionPoint snapped = point.getPreciseCopy();
        snapper.snapPoint((Request)new LocationRequest((Object)"move bendpoint"), horizontally ? 64 : 128, point, snapped);
        point.setLocation((Point)snapped);
    }

    @Override
    public void showSourceFeedback(Request request) {
        ConnectionRouter router = this.getConnection().getConnectionRouter();
        if (router instanceof HintedOrthogonalRouter) {
            HintedOrthogonalRouter routerImpl = (HintedOrthogonalRouter)router;
            HintedOrthogonalRouter.EndRoutingHint hint = request instanceof BendpointRequest ? HintedOrthogonalRouter.EndRoutingHint.FixBendpointMoveAnchor : HintedOrthogonalRouter.EndRoutingHint.FixAnchorMoveBendpoint;
            routerImpl.setEndRoutingHint(this.getConnection(), hint);
        }
        super.showSourceFeedback(request);
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        ConnectionRouter router = this.getConnection().getConnectionRouter();
        if (router instanceof HintedOrthogonalRouter) {
            ((HintedOrthogonalRouter)router).setEndRoutingHint(this.getConnection(), null);
        }
        super.eraseSourceFeedback(request);
    }

    @Override
    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        this.myIsShowingFeedback = false;
        super.eraseConnectionFeedback(request, removeFeedbackFigure);
    }

    @Override
    protected void showMoveBendpointFeedback(BendpointRequest request) {
        super.showMoveBendpointFeedback(request);
        this.myIsShowingFeedback = true;
    }

    @Override
    protected void showCreateBendpointFeedback(BendpointRequest request) {
        super.showCreateBendpointFeedback(request);
        this.myIsShowingFeedback = true;
    }

    @Override
    protected void showMoveLineSegFeedback(BendpointRequest request) {
        super.showMoveLineSegFeedback(request);
        this.myIsShowingFeedback = true;
    }

    @Override
    protected void showMoveOrthogonalBenspointFeedback(BendpointRequest request) {
        super.showMoveOrthogonalBenspointFeedback(request);
        this.myIsShowingFeedback = true;
    }
}

