/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.mwe2.utils.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.AbstractEMFWorkflowComponent;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.xtext.xbase.lib.Pair;

public class UMLWriter
extends AbstractEMFWorkflowComponent {
    private boolean platformSchemeAware = true;
    private boolean cloneSlotContents = false;
    private boolean ignoreEmptySlot = false;
    private boolean useSameResource = false;
    private boolean xmiIdentifiers = false;
    private Map<Matcher, String> xmiIdentifierFilters = Maps.newLinkedHashMap();

    public String getComponentName() {
        return UMLWriter.class.getSimpleName();
    }

    public String getLogMessage() {
        return "Writing UML model to " + this.getUri();
    }

    public boolean isPlatformSchemeAware() {
        return this.platformSchemeAware;
    }

    public void setPlatformSchemeAware(boolean platformSchemeAware) {
        this.platformSchemeAware = platformSchemeAware;
    }

    public boolean isIgnoreEmptySlot() {
        return this.ignoreEmptySlot;
    }

    public void setIgnoreEmptySlot(boolean ignoreEmptySlot) {
        this.ignoreEmptySlot = ignoreEmptySlot;
    }

    public boolean isCloneSlotContents() {
        return this.cloneSlotContents;
    }

    public void setCloneSlotContents(boolean b) {
        this.cloneSlotContents = b;
    }

    public boolean isUseSameResource() {
        return this.useSameResource;
    }

    public void setUseSameResource(boolean useSameResource) {
        this.useSameResource = useSameResource;
    }

    public boolean isXmiIdentifiers() {
        return this.xmiIdentifiers;
    }

    public void setXmiIdentifiers(boolean setXMIIdentifiers) {
        this.xmiIdentifiers = setXMIIdentifiers;
    }

    public void addXmiIdentifierFilters(Pair<String, String> filter, Pair<String, String> ... more) {
        this.setXmiIdentifiers(true);
        this.xmiIdentifierFilters.put(Pattern.compile((String)filter.getKey()).matcher(""), (String)filter.getValue());
        int i = 0;
        while (i < more.length) {
            this.xmiIdentifierFilters.put(Pattern.compile((String)more[i].getKey()).matcher(""), (String)more[i].getValue());
            ++i;
        }
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Resource r;
        EObject sc;
        Object slotContent = ctx.get(this.getModelSlot());
        if (slotContent == null) {
            if (this.isIgnoreEmptySlot()) {
                issues.addWarning((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' is empty. Not writing anything.");
            } else {
                issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' is empty.");
            }
            return;
        }
        if (!(slotContent instanceof Collection) && !(slotContent instanceof EObject)) {
            issues.addError((WorkflowComponent)this, "slot '" + this.getModelSlot() + "' neither contains an EList nor an EObject", slotContent, null, null);
            return;
        }
        if (slotContent instanceof EObject) {
            EObject sc2 = (EObject)slotContent;
            if (this.isCloneSlotContents()) {
                if (sc2.eResource() == null) {
                    issues.addWarning((WorkflowComponent)this, "model in slot '" + this.getModelSlot() + "' is not yet associated with a resource; cloning it is most likely an error!");
                } else {
                    EcoreUtil.Copier copier = new EcoreUtil.Copier();
                    EObject copy = copier.copy(sc2);
                    copier.copyReferences();
                    slotContent = copy;
                }
            } else if (sc2.eResource() != null && !this.isUseSameResource()) {
                issues.addWarning((WorkflowComponent)this, "the element in slot '" + this.getModelSlot() + "' is already contained in a resource and will be taken out of that resource!");
            }
        }
        this.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        URI uri = URI.createURI((String)this.getUri(), (boolean)true);
        EObject eObject = sc = slotContent instanceof Collection ? (EObject)((Collection)slotContent).iterator().next() : (EObject)slotContent;
        if (sc.eResource() != null && this.isUseSameResource()) {
            r = sc.eResource();
            r.setURI(uri);
        } else {
            r = this.getResourceSet().createResource(uri);
            if (slotContent instanceof Collection) {
                r.getContents().addAll((Collection)slotContent);
            } else {
                r.getContents().add((Object)((EObject)slotContent));
            }
            this.addStereotypes(r);
        }
        this.write(r, issues);
    }

    protected void addStereotypes(Resource r) {
        TreeIterator iter = EcoreUtil.getAllContents((Collection)ImmutableList.copyOf((Collection)r.getContents()));
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (next instanceof Element) {
                r.getContents().addAll((Collection)((Element)next).getStereotypeApplications());
                continue;
            }
            iter.prune();
        }
    }

    private void write(Resource r, Issues issues) {
        try {
            if (this.isXmiIdentifiers()) {
                if (!(r instanceof XMLResource)) {
                    issues.addWarning((WorkflowComponent)this, "resource is not an XML resource; cannot set XMI identifiers", (Object)r);
                } else if (!this.xmiIdentifierFilters.isEmpty()) {
                    this.setXMIIdentifiers((XMLResource)r, this.xmiIdentifierFilters);
                } else {
                    this.setXMIIdentifiers((XMLResource)r);
                }
            }
            HashMap<String, URIHandlerImpl.PlatformSchemeAware> options = new HashMap<String, URIHandlerImpl.PlatformSchemeAware>();
            if (this.isPlatformSchemeAware()) {
                options.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
            }
            r.save(options);
        }
        catch (IOException e) {
            throw new WorkflowInterruptedException("Problems writing xmi file to " + this.getUri() + " : " + e.getMessage());
        }
    }

    protected void setXMIIdentifiers(XMLResource resource) {
        UnmodifiableIterator iter = Iterators.filter((Iterator)resource.getAllContents(), InternalEObject.class);
        while (iter.hasNext()) {
            InternalEObject next = (InternalEObject)iter.next();
            resource.setID((EObject)next, UML2Util.getXMIIdentifier((InternalEObject)next));
        }
    }

    protected void setXMIIdentifiers(XMLResource resource, Map<Matcher, String> filters) {
        UnmodifiableIterator iter = Iterators.filter((Iterator)resource.getAllContents(), InternalEObject.class);
        while (iter.hasNext()) {
            InternalEObject next = (InternalEObject)iter.next();
            String id = this.filter(resource, filters, next);
            if (id == null) continue;
            resource.setID((EObject)next, id);
        }
    }

    private String filter(XMLResource resource, Map<Matcher, String> filters, InternalEObject object) {
        String id;
        String result = id = UML2Util.getXMIIdentifier((InternalEObject)object);
        for (Map.Entry<Matcher, String> filter : filters.entrySet()) {
            String filtered;
            EObject collision;
            Matcher m = filter.getKey();
            m.reset(id);
            if (!m.find() || (collision = resource.getEObject(filtered = m.replaceFirst(filter.getValue()))) != null && collision != object) continue;
            result = filtered;
            break;
        }
        if (result.equals(id)) {
            EObject collision = resource.getEObject(result);
            int counter = 0;
            while (collision != null && collision != object) {
                result = String.valueOf(id) + '$' + ++counter;
                collision = resource.getEObject(result);
            }
        }
        return result;
    }
}

