/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;

public class DurationLinkFigure
extends UMLEdgeFigure {
    private static final int ORIENTATION_SWITCH_DIFFERENCE = 30;
    private static final int HORIZOTAL_ARROW_START_LINE_OFFSET = 15;
    private static final int HORIZOTAL_ARROW_END_LINE_OFFSET = 15;
    private static final int ARROW_PADDING = 15;
    private Orientation arrowOrientation = Orientation.VERTICAL;
    private int arrowPositionDelta = 0;
    private PapyrusWrappingLabel durationLabel;
    private static final int SELECTION_TOLERANCE = 3;
    public static final String DELTA_VIEW_STYLE = "delta";

    protected void outlineShape(Graphics graphics) {
        this.arrowOrientation = this.computeOptimalOrientation();
        this.paintStartLine(graphics);
        this.paintEndLine(graphics);
        this.paintArrow(graphics);
    }

    protected void paintStartLine(Graphics graphics) {
        graphics.pushState();
        graphics.setLineStyle(2);
        try {
            PointList startLinePoints = this.getStartLinePoints();
            graphics.drawPolyline(startLinePoints);
        }
        finally {
            graphics.popState();
        }
    }

    public PointList getStartLinePoints() {
        if (this.arrowOrientation == Orientation.HORIZONTAL) {
            return this.getStartLinePointsHorizontal();
        }
        return this.getStartLinePointsVertical();
    }

    private PointList getStartLinePointsHorizontal() {
        PointList points = new PointList(3);
        points.addPoint(this.getStart());
        Point startOffsetEnd = this.getStart().getCopy();
        startOffsetEnd.setX(startOffsetEnd.x() + 15);
        points.addPoint(startOffsetEnd);
        int arrowYCoordinate = this.getArrowLineHorizontalY();
        Point startLineEnd = startOffsetEnd.getCopy();
        if (arrowYCoordinate > startOffsetEnd.y) {
            startLineEnd.setY(arrowYCoordinate + 15);
        } else {
            startLineEnd.setY(arrowYCoordinate - 15);
        }
        points.addPoint(startLineEnd);
        return points;
    }

    private PointList getStartLinePointsVertical() {
        PointList points = new PointList(2);
        points.addPoint(this.getStart());
        int arrowLinePosition = this.getArrowLineVerticalX();
        Point startLineEnd = this.getStart().getCopy();
        if (arrowLinePosition > this.getStart().x()) {
            startLineEnd.setX(arrowLinePosition + 15);
        } else {
            startLineEnd.setX(arrowLinePosition - 15);
        }
        points.addPoint(startLineEnd);
        return points;
    }

    private int getArrowLineVerticalX() {
        if (super.getPoints().size() < 2) {
            return 0;
        }
        return (this.getStart().x() + this.getEnd().x()) / 2 + this.arrowPositionDelta;
    }

    private int getArrowLineVerticalY() {
        return this.getEnd().y();
    }

    protected void paintEndLine(Graphics graphics) {
        graphics.pushState();
        graphics.setLineStyle(2);
        try {
            PointList endLinePoints = this.getEndLinePoints();
            graphics.drawPolyline(endLinePoints);
        }
        finally {
            graphics.popState();
        }
    }

    public PointList getEndLinePoints() {
        if (this.arrowOrientation == Orientation.HORIZONTAL) {
            return this.getEndLinePointsHorizontal();
        }
        return this.getEndLinePointsVertical();
    }

    private PointList getEndLinePointsHorizontal() {
        PointList points = new PointList(2);
        points.addPoint(this.getEnd());
        Point endOffsetEnd = this.getEnd().getCopy();
        endOffsetEnd.setX(endOffsetEnd.x() - 15);
        points.addPoint(endOffsetEnd);
        int arrowYCoordinate = this.getArrowLineHorizontalY();
        Point endLineEnd = endOffsetEnd.getCopy();
        if (arrowYCoordinate < this.getEnd().y) {
            endLineEnd.setY(arrowYCoordinate - 15);
        } else {
            endLineEnd.setY(arrowYCoordinate + 15);
        }
        points.addPoint(endLineEnd);
        return points;
    }

    private PointList getEndLinePointsVertical() {
        PointList points = new PointList(2);
        points.addPoint(this.getEnd());
        int arrowLinePosition = this.getArrowLineVerticalX();
        Point endLineEnd = this.getEnd().getCopy();
        if (arrowLinePosition < this.getEnd().x()) {
            endLineEnd.setX(arrowLinePosition - 15);
        } else {
            endLineEnd.setX(arrowLinePosition + 15);
        }
        points.addPoint(endLineEnd);
        return points;
    }

    protected void paintArrow(Graphics graphics) {
        PolylineConnection arrowLine = new PolylineConnection();
        arrowLine.setForegroundColor(this.getForegroundColor());
        arrowLine.setBackgroundColor(this.getBackgroundColor());
        arrowLine.setLineStyle(this.getLineStyle());
        arrowLine.setLineWidth(this.getLineWidth());
        PointList arrowPoints = this.getArrowLinePoints();
        Point arrowStart = arrowPoints.getFirstPoint();
        Point arrowEnd = arrowPoints.getLastPoint();
        arrowLine.setStart(arrowStart);
        arrowLine.setEnd(arrowEnd);
        this.decorateArrowLine(arrowLine, arrowStart, arrowEnd);
        arrowLine.paint(graphics);
    }

    public PointList getArrowLinePoints() {
        PointList points = new PointList(2);
        Point arrowStart = null;
        Point arrowEnd = null;
        if (this.arrowOrientation == Orientation.HORIZONTAL) {
            arrowStart = this.getStart().getCopy().setX(this.getStart().x() + 15).setY(this.getArrowLineHorizontalY());
            arrowEnd = this.getEnd().getCopy().setX(this.getEnd().x() - 15).setY(this.getArrowLineHorizontalY());
        } else {
            arrowStart = this.getStart().getCopy().setX(this.getArrowLineVerticalX());
            arrowEnd = arrowStart.getCopy().setY(this.getArrowLineVerticalY());
        }
        points.addPoint(arrowStart);
        points.addPoint(arrowEnd);
        return points;
    }

    private int getArrowLineHorizontalY() {
        if (super.getPoints().size() < 2) {
            return 0;
        }
        return (this.getStart().y() + this.getEnd().y()) / 2 + this.arrowPositionDelta;
    }

    protected void decorateArrowLine(PolylineConnection arrowLine, Point arrowStart, Point arrowEnd) {
        PolylineDecoration source = new PolylineDecoration();
        source.setScale((double)(7 * this.getLineWidth()), (double)(3 * this.getLineWidth()));
        source.setLineWidth(this.getLineWidth());
        source.setLocation(arrowStart);
        source.setReferencePoint(arrowEnd);
        arrowLine.setSourceDecoration((RotatableDecoration)source);
        PolylineDecoration target = new PolylineDecoration();
        target.setScale((double)(7 * this.getLineWidth()), (double)(3 * this.getLineWidth()));
        target.setLineWidth(this.getLineWidth());
        target.setLocation(arrowEnd);
        target.setReferencePoint(arrowStart);
        arrowLine.setTargetDecoration((RotatableDecoration)target);
    }

    private Orientation computeOptimalOrientation() {
        if (Math.abs(this.getStart().y - this.getEnd().y) < 30) {
            return Orientation.HORIZONTAL;
        }
        return Orientation.VERTICAL;
    }

    public boolean containsPoint(int x, int y) {
        PointList startLinePoints = this.getStartLinePoints();
        if (Geometry.polylineContainsPoint((PointList)startLinePoints, (int)x, (int)y, (int)3)) {
            return true;
        }
        PointList endLinePoints = this.getEndLinePoints();
        if (Geometry.polylineContainsPoint((PointList)endLinePoints, (int)x, (int)y, (int)3)) {
            return true;
        }
        PointList arrowPoints = this.getArrowLinePoints();
        if (Geometry.polylineContainsPoint((PointList)arrowPoints, (int)x, (int)y, (int)3)) {
            return true;
        }
        List children = this.getChildren();
        return children.stream().anyMatch(child -> child.containsPoint(x, y));
    }

    public void setArrowPositionDelta(int delta) {
        if (delta != this.arrowPositionDelta) {
            this.arrowPositionDelta = delta;
            this.revalidate();
        }
    }

    public int getArrowPositionDelta() {
        return this.arrowPositionDelta;
    }

    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        if (this.getPoints().size() >= 2) {
            PointList allPoints = new PointList();
            allPoints.addAll(this.getStartLinePoints());
            allPoints.addAll(this.getEndLinePoints());
            allPoints.addAll(this.getArrowLinePoints());
            bounds.union(allPoints.getBounds());
        }
        return bounds;
    }

    public void setConnectionRouter(ConnectionRouter cr) {
    }

    public Orientation getArrowOrientation() {
        return this.arrowOrientation;
    }

    public WrappingLabel getDurationLabelFigure() {
        return this.durationLabel;
    }

    protected void createContents() {
        super.createContents();
        this.durationLabel = new PapyrusWrappingLabel();
        this.durationLabel.setText("");
        this.add((IFigure)this.durationLabel);
    }

    public Object getRoutingConstraint() {
        ArrayList<Bendpoint> list = new ArrayList<Bendpoint>();
        list.add(() -> ((DurationLinkFigure)this).getStart());
        list.add(() -> ((DurationLinkFigure)this).getEnd());
        return list;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

