/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.HTMLExportHelper;
import org.eclipse.papyrus.uml.export.tree.UMLTreeFactory;
import org.eclipse.papyrus.uml.export.util.FileUtil;
import org.eclipse.papyrus.uml.export.util.IconHelper;
import org.eclipse.papyrus.uml.export.util.ImageUtil;
import org.eclipse.papyrus.uml.export.util.IndexHelper;

public class HTMLExportRunner {
    private static final String ICONS_DIRECTORY = "icons";

    public static IPath generateHtmlWebSite(Path targetDirectoryPath, List<Diagram> allDiagrams, HTMLExportHelper helper) {
        for (Diagram diagram : allDiagrams) {
            ImageUtil.reFactoredgenerateImg(targetDirectoryPath, diagram, helper.getAnnotations());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        UMLTreeFactory diagramExplorer = new UMLTreeFactory(helper.getAdditionnalDatas());
        for (Diagram diagram : allDiagrams) {
            diagramExplorer.addDiagram(diagram);
        }
        IPath append = targetDirectoryPath.append("index.html");
        File file = append.toFile();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            IndexHelper indexHelper = new IndexHelper(helper.getHeaders(), helper.getFooters());
            out.write(indexHelper.getIndex(gson.toJsonTree((Object)diagramExplorer.getTree()).toString()));
            out.close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        for (Map.Entry<String, String> entry : helper.getFromTO().entrySet()) {
            FileUtil.copyFileFromPlatform((IPath)targetDirectoryPath, entry.getValue(), entry.getKey());
        }
        IPath iconDirPath = targetDirectoryPath.append(ICONS_DIRECTORY);
        File iconDir = iconDirPath.toFile();
        if (!iconDir.exists()) {
            iconDir.mkdirs();
        }
        IconHelper.printIcon(iconDirPath);
        return iconDirPath;
    }
}

