/*****************************************************************************
 * Copyright (c) 2010 Atos Origin.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Mathieu Velten (Atos Origin) mathieu.velten@atosorigin.com - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.navigation;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.gmfdiag.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IModelLinker;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;


public class UMLRuleHelper {

	private static final EClass[] possibleBehaviors = { UMLPackage.Literals.INTERACTION, UMLPackage.Literals.ACTIVITY, UMLPackage.Literals.STATE_MACHINE };

	public static void addBehaviorCreatedNavigableElements(List<NavigableElement> navElements, NavigableElement currentNavElement, EStructuralFeature feature, final IModelLinker modelLinker) {
		for (EClass behaviorClass : possibleBehaviors) {
			final EObject behavior = UMLFactory.eINSTANCE.create(behaviorClass);
			navElements.add(new CreatedNavigableElement(behavior, currentNavElement, feature, modelLinker, UMLBaseNameSetter.instance));
		}
	}

}
