/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.participants;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.ControlPropertiesCommand;
import org.eclipse.papyrus.infra.internationalization.controlmode.commands.CreatePropertiesControlResourceCommand;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;

public class PropertiesControlParticipant
implements IControlCommandParticipant {
    private static final String PARTICIPANT_ID = "org.eclipse.papyrus.infra.internationalization.controlmode.PropertiesControlParticipant";
    private InternationalizationModelResource internationalizationModelResource;

    public String getID() {
        return PARTICIPANT_ID;
    }

    public int getPriority() {
        return 40;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        boolean result = false;
        EObject objectToControl = request.getTargetObject();
        if (objectToControl != null) {
            InternationalizationModelResource modelResource = this.getInternationalizationModelResource(request);
            Map localesAndResourcesForURI = modelResource.getLocalesAndResourcesForURI(request.getSourceURI().trimFileExtension().appendFileExtension("properties"));
            result = localesAndResourcesForURI != null && !localesAndResourcesForURI.isEmpty();
        }
        return result;
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        UnexecutableCommand resultCommand = UnexecutableCommand.INSTANCE;
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource(request);
        if (modelResource != null) {
            Set locales = modelResource.getAvailablePropertiesLocales(request.getSourceURI());
            resultCommand = new CompositeTransactionalCommand(request.getEditingDomain(), "Create properties files");
            for (Locale currentLocale : locales) {
                ((CompositeTransactionalCommand)resultCommand).add((IUndoableOperation)new CreatePropertiesControlResourceCommand(request, "properties", currentLocale));
            }
        }
        return resultCommand;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        this.internationalizationModelResource = null;
        return new ControlPropertiesCommand(request);
    }

    protected InternationalizationModelResource getInternationalizationModelResource(ControlModeRequest request) {
        ModelSet modelSet;
        if (this.internationalizationModelResource == null && request != null && (modelSet = request.getModelSet()) != null) {
            try {
                this.internationalizationModelResource = (InternationalizationModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return this.internationalizationModelResource;
    }
}

