/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.papyrus.infra.tools.util.Try;

final class Failure<T>
extends Try<T> {
    private static final long serialVersionUID = -4229519157128957990L;
    private static final String NO_REASON = "No reason provided.";
    private final Throwable failure;
    private final String reason;

    Failure(String reason) {
        this(reason, null);
    }

    Failure(Throwable failure) {
        this(null, failure);
    }

    Failure(String reason, Throwable failure) {
        this.reason = reason != null ? reason : (failure != null ? failure.getClass().getName() : NO_REASON);
        this.failure = failure;
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.empty();
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public T get() throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public <U> Try<U> map(Function<? super T, U> mapping) {
        return this;
    }

    @Override
    public <U> Try<U> flatMap(Function<? super T, Optional<U>> mapping) {
        return this;
    }

    @Override
    public <U> Try<U> tryMap(Function<? super T, Try<U>> mapping) {
        return this;
    }

    @Override
    public Try<T> filter(Predicate<? super T> test) {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)obj;
        return Objects.equals(this.reason, other.reason) && Objects.equals(this.failure, other.failure);
    }

    public int hashCode() {
        return Objects.hash(Failure.class, this.reason, this.failure);
    }

    public String toString() {
        return this.failure == null || Objects.equals(this.failure.getMessage(), this.reason) ? String.format("Failure(%s)", this.reason) : String.format("Failure(%s, %s: %s)", this.reason, this.failure.getClass().getSimpleName(), this.failure.getMessage());
    }
}

