/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.Activator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.definition.IDirectEditorExtensionPoint;

public class DirectEditorRegistry {
    protected TreeMap<Integer, List<IDirectEditorExtensionPoint>> editorMap = new TreeMap();
    protected ArrayList<String> objectToEdits = new ArrayList();

    public void add(IDirectEditorExtensionPoint directEditor) {
        List<IDirectEditorExtensionPoint> currentValue;
        assert (directEditor != null);
        this.objectToEdits.add(directEditor.getObjectToEdit());
        Integer priority = directEditor.getPriority();
        String preferedLanguage = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + directEditor.getObjectToEdit());
        if (preferedLanguage.equals(directEditor.getLanguage())) {
            priority = new Integer(0);
        }
        if ((currentValue = this.editorMap.get(priority)) == null) {
            currentValue = new ArrayList<IDirectEditorExtensionPoint>();
        }
        currentValue.add(directEditor);
        this.editorMap.put(priority, currentValue);
    }

    protected void adaptPreferences() {
        Iterator<String> iter = this.objectToEdits.iterator();
        IDirectEditorExtensionPoint defaultDirectEditor = null;
        while (iter.hasNext()) {
            String objectToEdit = iter.next();
            defaultDirectEditor = this.getDefaultDirectEditor(objectToEdit);
            String id = "papyrus.directeditor." + defaultDirectEditor.getObjectToEdit();
            String language = defaultDirectEditor.getLanguage();
            if (Activator.getDefault().getPreferenceStore().getString(id).equals("Simple Direct Editor")) continue;
            Activator.getDefault().getPreferenceStore().setValue(id, language);
        }
    }

    public String toString() {
        String out = "";
        for (Integer index : this.editorMap.keySet()) {
            out = String.valueOf(out) + "\n[" + index + "]" + "=[" + this.editorMap.get(index) + "]";
        }
        return out;
    }

    public void init(IDirectEditorExtensionPoint[] directEditors) {
        this.editorMap = new TreeMap();
        this.objectToEdits = new ArrayList();
        int i = 0;
        while (i < directEditors.length) {
            this.add(directEditors[i]);
            ++i;
        }
        this.adaptPreferences();
    }

    public IDirectEditorExtensionPoint getDefaultDirectEditor(String ObjectToEdit) {
        Iterator<Integer> keyIterator = this.editorMap.keySet().iterator();
        TreeMap<Integer, IDirectEditorExtensionPoint> directEditorExtensionPoints = new TreeMap<Integer, IDirectEditorExtensionPoint>();
        while (keyIterator.hasNext()) {
            Integer index = keyIterator.next();
            for (IDirectEditorExtensionPoint directEditorExtensionPoint : this.editorMap.get(index)) {
                if (!directEditorExtensionPoint.getObjectToEdit().equals(ObjectToEdit)) continue;
                directEditorExtensionPoints.put(directEditorExtensionPoint.getPriority(), directEditorExtensionPoint);
            }
            if (directEditorExtensionPoints.isEmpty()) continue;
            return (IDirectEditorExtensionPoint)directEditorExtensionPoints.firstEntry().getValue();
        }
        return null;
    }
}

