/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.NotationAndTypeAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;

public class CombinedCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected Command getCreateCommand(final CreateViewRequest request) {
        int insertAt;
        Command createCommand = super.getCreateCommand(request);
        if (request.getExtendedData().get("InsertAt") instanceof Integer && (insertAt = ((Integer)request.getExtendedData().get("InsertAt")).intValue()) >= 0) {
            final GraphicalEditPart graphicalHost = (GraphicalEditPart)this.getHost();
            AbstractTransactionalCommand insertAtCommand = new AbstractTransactionalCommand(graphicalHost.getEditingDomain(), "Insert view at " + insertAt, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    View container = graphicalHost.getNotationView();
                    EList children = container.getPersistedChildren();
                    List viewDescriptors = request.getViewDescriptors();
                    ArrayList reversedDescriptors = new ArrayList(viewDescriptors);
                    Collections.reverse(reversedDescriptors);
                    for (CreateViewRequest.ViewDescriptor descriptor : reversedDescriptors) {
                        children.move(insertAt, (Object)((View)descriptor.getAdapter(View.class)));
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            return new ICommandProxy((ICommand)(createCommand == null ? insertAtCommand : new CommandProxy(createCommand).compose((IUndoableOperation)insertAtCommand).reduce()));
        }
        return createCommand;
    }

    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        GraphicalEditPart compartmentEditPart = (GraphicalEditPart)this.getHost();
        IFigure compartmentFigure = compartmentEditPart.getFigure();
        Point locationToViewer = request.getLocation().getCopy();
        Point locationToCompartment = locationToViewer.getCopy();
        compartmentFigure.translateToRelative((Translatable)locationToCompartment);
        compartmentFigure.translateFromParent((Translatable)locationToCompartment);
        InteractionOperandEditPart targetOperandPart = CombinedCreationEditPolicy.findOperandAt(locationToCompartment, compartmentEditPart);
        if (targetOperandPart != null) {
            IFigure targetOperandFigure = targetOperandPart.getFigure();
            Rectangle targetOperandBounds = targetOperandFigure.getBounds();
            Point locationToOperand = locationToViewer.getCopy();
            targetOperandFigure.translateToRelative((Translatable)locationToOperand);
            targetOperandFigure.translateFromParent((Translatable)locationToOperand);
            int height = targetOperandBounds.getBottom().y() - locationToOperand.y();
            int width = compartmentFigure.getBounds().width();
            int distanceToCompartmentTop = compartmentFigure.getBounds().getTopLeft().getNegated().translate((Point)locationToCompartment).y;
            Rectangle bounds = new Rectangle(0, distanceToCompartmentTop, width, height);
            SetResizeAndLocationCommand setBoundsCommand = new SetResizeAndLocationCommand(editingDomain, "Set dimension", (IAdaptable)descriptor, bounds);
            View view = targetOperandPart.getNotationView();
            int siblingHeight = targetOperandPart.getFigure().getBounds().height();
            Dimension siblingDimension = new Dimension(width, siblingHeight - height);
            SetResizeCommand reduceSiblingSizeCommand = new SetResizeCommand(editingDomain, "Set dimension", (IAdaptable)new NotationAndTypeAdapter(view.getElement(), view), siblingDimension);
            return setBoundsCommand.compose((IUndoableOperation)reduceSiblingSizeCommand);
        }
        Rectangle clientArea = compartmentFigure.getClientArea();
        Dimension size = new Dimension(clientArea.getSize());
        SetResizeCommand setBoundsCommand = new SetResizeCommand(editingDomain, "Set dimension", (IAdaptable)descriptor, size);
        return setBoundsCommand;
    }

    private static InteractionOperandEditPart findOperandAt(Point locationToCompartment, GraphicalEditPart compartmentPart) {
        EditPart targetPart = CombinedCreationEditPolicy.findEditPartAt(locationToCompartment, compartmentPart);
        InteractionOperandEditPart operandEditPart = targetPart instanceof InteractionOperandEditPart ? (InteractionOperandEditPart)targetPart : (targetPart != null ? CombinedCreationEditPolicy.findParentOperandPart(targetPart) : null);
        return operandEditPart;
    }

    private static EditPart findEditPartAt(Point locationToCompartment, GraphicalEditPart compartmentPart) {
        EditPart targetPart;
        IFigure targetOperandFigure = compartmentPart.getFigure().findFigureAt(locationToCompartment);
        if (targetOperandFigure == null) {
            targetPart = null;
        } else {
            EditPart partForFigure = null;
            IFigure currentFigure = targetOperandFigure;
            while (currentFigure != null) {
                partForFigure = (EditPart)compartmentPart.getViewer().getVisualPartMap().get(currentFigure);
                if (partForFigure != null) break;
                currentFigure = currentFigure.getParent();
            }
            targetPart = partForFigure;
        }
        return targetPart;
    }

    private static InteractionOperandEditPart findParentOperandPart(EditPart part) {
        EditPart currentPart = part.getParent();
        while (currentPart != null) {
            if (currentPart instanceof InteractionOperandEditPart) {
                return (InteractionOperandEditPart)currentPart;
            }
            currentPart = currentPart.getParent();
        }
        return null;
    }
}

