/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import java.math.BigDecimal;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.FormulaParser;

public class FormulaResultDisplayConverter
extends DisplayConverter {
    protected FormulaDataProvider dataProvider;
    protected boolean formatNumberValues = false;

    public FormulaResultDisplayConverter(FormulaDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public Object canonicalToDisplayValue(Object canonicalValue) {
        if (canonicalValue instanceof BigDecimal || canonicalValue != null && this.formatNumberValues && this.dataProvider.getFormulaParser().isNumber(canonicalValue.toString())) {
            FormulaParser parser = this.dataProvider.getFormulaParser();
            return parser.decimalFormat.format(parser.convertToBigDecimal(canonicalValue.toString()));
        }
        return canonicalValue;
    }

    @Override
    public Object displayToCanonicalValue(Object displayValue) {
        return displayValue;
    }

    public void setFormatNumberValues(boolean format) {
        this.formatNumberValues = format;
    }
}

