/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.InternalArchitectureDomainMerger;

public class MergedArchitectureDomain
extends MergedADElement {
    private final EList<MergedArchitectureContext> contexts = new UniqueEList<MergedArchitectureContext>(){
        private static final long serialVersionUID = 1L;

        protected void didAdd(int index, MergedArchitectureContext newObject) {
            newObject.setParent(MergedArchitectureDomain.this);
        }
    };
    private final EList<ArchitectureDomain> mergedDomains = new UniqueEList();
    private boolean needsMerge;

    @Deprecated(since="3.1", forRemoval=true)
    public MergedArchitectureDomain() {
        super(null);
    }

    public MergedArchitectureDomain(ArchitectureDomain domain) {
        super(null, (ADElement)domain);
    }

    protected ArchitectureDomain getModel() {
        this.checkMerge();
        return (ArchitectureDomain)super.getModel();
    }

    public Collection<Stakeholder> getStakeholders() {
        this.checkMerge();
        return ECollections.unmodifiableEList((EList)this.getModel().getStakeholders());
    }

    public Collection<Concern> getConcerns() {
        this.checkMerge();
        return ECollections.unmodifiableEList((EList)this.getModel().getConcerns());
    }

    public Collection<MergedArchitectureContext> getContexts() {
        this.checkMerge();
        return ECollections.unmodifiableEList(this.contexts);
    }

    final void addContext(MergedArchitectureContext context) {
        this.contexts.add((Object)context);
    }

    @Deprecated(since="3.1", forRemoval=true)
    public void merge(ArchitectureDomain domain) {
        this.needsMerge = this.mergedDomains.add((Object)domain);
    }

    private void checkMerge() {
        if (this.needsMerge) {
            this.needsMerge = false;
            this.element = (ADElement)this.mergedDomains.get(0);
            InternalArchitectureDomainMerger merger = InternalArchitectureDomainMerger.newInstance();
            List<MergedArchitectureDomain> mergeResult = merger.mergeDomains((Iterable<? extends ArchitectureDomain>)this.mergedDomains);
            mergeResult.stream().filter(other -> Objects.equals(this.getName(), other.getName())).findFirst().ifPresent(self -> {
                this.element = self.getModel();
                self.getContexts().forEach(this::addContext);
            });
        }
    }

    @Override
    public boolean isMerged() {
        this.checkMerge();
        return super.isMerged() || this.getContexts().stream().anyMatch(MergedADElement::isMerged);
    }

    @Override
    public String getName() {
        this.checkMerge();
        return super.getName();
    }

    @Override
    public String getId() {
        this.checkMerge();
        return super.getId();
    }

    @Override
    public String getIcon() {
        this.checkMerge();
        return super.getIcon();
    }

    @Override
    public String getQualifiedName() {
        this.checkMerge();
        return super.getQualifiedName();
    }

    @Override
    @Deprecated(since="3.1", forRemoval=true)
    public ADElement getImageObject() {
        this.checkMerge();
        return super.getImageObject();
    }
}

