/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;

public class CompoundFilteredRestrictedContentProvider
extends AbstractFilteredContentProvider
implements IRestrictedContentProvider {
    private List<IRestrictedContentProvider> encapsulatedContentProviders = new ArrayList<IRestrictedContentProvider>();

    public boolean add(IRestrictedContentProvider o) {
        if (o != null) {
            return this.encapsulatedContentProviders.add(o);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        HashSet<Object> asList = new HashSet<Object>();
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object[] directElements = encapsulatedContentProvider.getElements(inputElement);
            asList.addAll(Arrays.asList(directElements));
        }
        return asList.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        HashSet<Object> asList = new HashSet<Object>();
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object[] directElements = encapsulatedContentProvider.getChildren(parentElement);
            if (directElements == null || directElements.length == 0) continue;
            asList.addAll(Arrays.asList(directElements));
        }
        return asList.toArray();
    }

    public Object getParent(Object element) {
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object parent = encapsulatedContentProvider.getParent(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.encapsulatedContentProviders.clear();
    }

    @Override
    public void setRestriction(boolean isRestricted) {
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            current.setRestriction(isRestricted);
        }
    }

    @Override
    public boolean isRestricted() {
        if (!this.encapsulatedContentProviders.isEmpty()) {
            return this.encapsulatedContentProviders.get(0).isRestricted();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidValue(Object element) {
        boolean result = false;
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            boolean bl = result = result || current.isValidValue(element);
        }
        return result;
    }

    @Override
    public Object[] getElements() {
        return this.getElements(null);
    }

    @Override
    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            current.setIgnoreInheritedElements(ignoreInheritedElements);
        }
    }

    @Override
    public boolean isIgnoringInheritedElements() {
        return this.encapsulatedContentProviders.get(0).isIgnoringInheritedElements();
    }
}

