/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.AssistantPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class ModelingAssistantPreferences
implements ISchedulingRule {
    private static final String PREF_WORKSPACE_ASSISTANT_MODELS = "workspaceAssistantModels";
    private final IEclipsePreferences preferences;
    private final Set<URI> workspaceAssistantModels = Sets.newLinkedHashSet();
    private final PreferenceListener listener = new PreferenceListener();
    private final AtomicBoolean savePending = new AtomicBoolean();

    ModelingAssistantPreferences(IEclipsePreferences preferences) {
        this.preferences = preferences;
        this.initWorkspaceAssistantModels();
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.listener);
    }

    public void dispose() {
        try {
            this.savePreferences(true);
        }
        catch (CoreException e) {
            AssistantPlugin.getPlugin().getLog().log(e.getStatus());
        }
        this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<URI> getWorkspaceAssistantModels() {
        Set<URI> set = this.workspaceAssistantModels;
        synchronized (set) {
            return ImmutableList.copyOf(this.workspaceAssistantModels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkspaceAssistantModel(URI uri) {
        Set<URI> set = this.workspaceAssistantModels;
        synchronized (set) {
            return this.workspaceAssistantModels.contains(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkspaceAssistantModel(URI uri) {
        Set<URI> set = this.workspaceAssistantModels;
        synchronized (set) {
            if (this.workspaceAssistantModels.add(uri)) {
                this.updateWorkspaceAssistantModels();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkspaceAssistantModel(URI uri) {
        Set<URI> set = this.workspaceAssistantModels;
        synchronized (set) {
            if (this.workspaceAssistantModels.remove(uri)) {
                this.updateWorkspaceAssistantModels();
            }
        }
    }

    void initWorkspaceAssistantModels() {
        this.workspaceAssistantModels.clear();
        String stringList = this.preferences.get(PREF_WORKSPACE_ASSISTANT_MODELS, "");
        for (String next : Splitter.on((char)' ').split((CharSequence)Strings.nullToEmpty((String)stringList))) {
            if ((next = next.trim()).isEmpty()) continue;
            this.workspaceAssistantModels.add(URI.createURI((String)next, (boolean)true));
        }
    }

    void updateWorkspaceAssistantModels() {
        this.listener.write(PREF_WORKSPACE_ASSISTANT_MODELS, new Runnable(){

            @Override
            public void run() {
                ModelingAssistantPreferences.this.preferences.put(ModelingAssistantPreferences.PREF_WORKSPACE_ASSISTANT_MODELS, Joiner.on((char)' ').join(ModelingAssistantPreferences.this.workspaceAssistantModels));
            }
        });
    }

    void savePreferences(boolean now) throws CoreException {
        if (!now) {
            if (this.savePending.compareAndSet(false, true)) {
                new PreferenceSaveJob().schedule(10000L);
            }
        } else if (this.savePending.compareAndSet(true, false)) {
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, AssistantPlugin.getPlugin().getSymbolicName(), "Failed to save preferences.", (Throwable)e));
            }
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    private class PreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final Set<String> updating = Sets.newConcurrentHashSet();

        private PreferenceListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            block7: {
                if (this.updating.contains(event.getKey())) break block7;
                switch (event.getKey()) {
                    case "workspaceAssistantModels": {
                        ModelingAssistantPreferences.this.initWorkspaceAssistantModels();
                    }
                }
            }
        }

        void write(String key, Runnable writeOperation) {
            this.updating.add(key);
            try {
                writeOperation.run();
            }
            finally {
                this.updating.remove(key);
                try {
                    ModelingAssistantPreferences.this.savePreferences(false);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private class PreferenceSaveJob
    extends Job {
        PreferenceSaveJob() {
            super("Saving preferences");
            this.setRule(ModelingAssistantPreferences.this);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            try {
                ModelingAssistantPreferences.this.savePreferences(true);
            }
            catch (CoreException e) {
                result = e.getStatus();
            }
            return result;
        }
    }
}

