/**
 * Copyright (c) 2006, 2017, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Emilien Perico (Atos Origin) - add code to refactor some classes
 * Christian W. Damus (CEA) - bug 430648
 * Christian W. Damus (CEA) - bug 431023
 * Mickael ADAM (ALL4TEC) mickael.adam@all4tec.net - Bug 512343
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package xpt.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPropertySheet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.navigator.NavigatorItem;
import xpt.navigator.NavigatorLinkHelper;
import xpt.navigator.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class Editor {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private NavigatorLinkHelper xptNavigatorLinkHelper;
  
  @Inject
  private NavigatorItem xptNavigatorItem;
  
  @Inject
  private DiagramEditorContextMenuProvider xptDiagramEditorContextMenuProvider;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  public CharSequence className(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence implementsList(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _implementsList = this.implementsList(this.buildImplementsList(it));
    _builder.append(_implementsList);
    return _builder;
  }
  
  public CharSequence getPreferencesHint(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint getPreferencesHint() {");
    _builder.newLine();
    _builder.append("return ");
    CharSequence _preferenceHintAccess = this.xptActivator.preferenceHintAccess(it.getEditorGen());
    _builder.append(_preferenceHintAccess);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContributorId(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getContributorId() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".ID;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence checkEditorInput(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isIDEMode = this.isIDEMode(it);
      if (_isIDEMode) {
        _builder.append("input instanceof org.eclipse.ui.IFileEditorInput || ");
      }
    }
    _builder.append("input instanceof org.eclipse.emf.common.ui.URIEditorInput");
    return _builder;
  }
  
  public CharSequence gotoMarker(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void gotoMarker(org.eclipse.core.resources.IMarker marker) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService.getInstance().gotoMarker(this, marker);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSaveAsAllowed(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSaveAsAllowed() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doSaveAs(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void doSaveAs() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("performSaveAs(new org.eclipse.core.runtime.NullProgressMonitor());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getShowInContext(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.part.ShowInContext getShowInContext() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.ui.part.ShowInContext(getEditorInput(), ");
    {
      boolean _hasNavigator = this.hasNavigator(it);
      if (_hasNavigator) {
        _builder.append("getNavigatorSelection()");
      } else {
        _builder.append("getGraphicalViewer().getSelection()");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence configureGraphicalViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void configureGraphicalViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.configureGraphicalViewer();");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptDiagramEditorContextMenuProvider.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" provider =");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("new ");
    CharSequence _qualifiedClassName_1 = this.xptDiagramEditorContextMenuProvider.qualifiedClassName(it.getEditorGen().getDiagram());
    _builder.append(_qualifiedClassName_1, "\t\t\t");
    _builder.append("(this, getDiagramGraphicalViewer());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("getDiagramGraphicalViewer().setContextMenu(provider);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getSite().registerContextMenu(org.eclipse.gmf.runtime.diagram.ui.actions.ActionIds.DIAGRAM_EDITOR_CONTEXT_MENU, provider, getDiagramGraphicalViewer());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence controlLastClickPositionProviderService(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void startupLastClickPositionProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myLastClickPositionProvider == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider = new org.eclipse.gmf.tooling.runtime.part.LastClickPositionProvider(this);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.attachToService();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void shutDownLastClickPositionProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myLastClickPositionProvider != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.detachFromService();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider.dispose();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myLastClickPositionProvider = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addDropTargetListener(final GenEditorView it, final String transferAccessor) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("getDiagramGraphicalViewer().addDropTargetListener(new DropTargetListener(getDiagramGraphicalViewer(), ");
    _builder.append(transferAccessor);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected Object getJavaObject(org.eclipse.swt.dnd.TransferData data) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    _builder.append(transferAccessor, "\t\t");
    _builder.append(".nativeToJava(data);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("});");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DropTargetListener(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private abstract class DropTargetListener extends org.eclipse.gmf.runtime.diagram.ui.parts.DiagramDropTargetListener {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_constructor = this.DTL_constructor(it);
    _builder.append(_DTL_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_getObjectsBeingDropped = this.DTL_getObjectsBeingDropped(it);
    _builder.append(_DTL_getObjectsBeingDropped, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _DTL_getJavaObject = this.DTL_getJavaObject(it);
    _builder.append(_DTL_getJavaObject, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_constructor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public DropTargetListener(org.eclipse.gef.EditPartViewer viewer, org.eclipse.swt.dnd.Transfer xfer) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super(viewer, xfer);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_getObjectsBeingDropped(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected java.util.List getObjectsBeingDropped() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.dnd.TransferData data = getCurrentEvent().currentDataType;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.HashSet<org.eclipse.emf.common.util.URI> uris = new java.util.HashSet<");
    String _diamondOp = this._codeStyle.diamondOp(it.getEditorGen().getDiagram(), "org.eclipse.emf.common.util.URI");
    _builder.append(_diamondOp, "\t");
    _builder.append(">(); ");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object transferedObject = getJavaObject(data);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (transferedObject instanceof org.eclipse.jface.viewers.IStructuredSelection) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.viewers.IStructuredSelection selection = (org.eclipse.jface.viewers.IStructuredSelection) transferedObject;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator<?> it = selection.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Object nextSelectedObject = it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      boolean _hasNavigator = this.hasNavigator(it);
      if (_hasNavigator) {
        _builder.append("if (nextSelectedObject instanceof ");
        CharSequence _qualifiedClassName = this.xptNavigatorItem.qualifiedClassName(it.getEditorGen().getNavigator());
        _builder.append(_qualifiedClassName, "\t\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("org.eclipse.gmf.runtime.notation.View view = ((");
        CharSequence _qualifiedClassName_1 = this.xptNavigatorItem.qualifiedClassName(it.getEditorGen().getNavigator());
        _builder.append(_qualifiedClassName_1, "\t\t\t\t\t\t\t\t");
        _builder.append(") nextSelectedObject).getView();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("nextSelectedObject = view.getElement();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else ");
      }
    }
    _builder.append("if (nextSelectedObject instanceof org.eclipse.core.runtime.IAdaptable) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.core.runtime.IAdaptable adaptable = (org.eclipse.core.runtime.IAdaptable) nextSelectedObject;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("nextSelectedObject = adaptable.getAdapter(org.eclipse.emf.ecore.EObject.class);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (nextSelectedObject instanceof org.eclipse.emf.ecore.EObject) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject modelElement = (org.eclipse.emf.ecore.EObject) nextSelectedObject;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("uris.add(org.eclipse.emf.ecore.util.EcoreUtil.getURI(modelElement));\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.ArrayList<org.eclipse.emf.ecore.EObject> result = new java.util.ArrayList<");
    String _diamondOp_1 = this._codeStyle.diamondOp(it.getEditorGen().getDiagram(), "org.eclipse.emf.ecore.EObject");
    _builder.append(_diamondOp_1, "\t");
    _builder.append(">(uris.size());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (org.eclipse.emf.common.util.URI nextURI : uris) { ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EObject modelObject = getEditingDomain().getResourceSet().getEObject(nextURI, true);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("result.add(modelObject);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence DTL_getJavaObject(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected abstract Object getJavaObject(org.eclipse.swt.dnd.TransferData data);");
    _builder.newLine();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForSavingDeletedFile(it), "The original file \"{0}\" has been deleted.");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveAsProblems(it)), "Problem During Save As...");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveAsProblems(it)), "Save could not be completed. Target file is already open in another editor.");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveProblems(it)), "Save Problems");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveProblems(it)), "Could not save file.");
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForSavingDeletedFile(it));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveAsProblems(it)));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForSaveProblems(it)));
    _builder.append(_accessorField_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForSavingDeletedFile(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SavingDeletedFile");
  }
  
  @Localization
  public String i18nKeyForSaveAsProblems(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SaveAsError");
  }
  
  @Localization
  public String i18nKeyForSaveProblems(final GenEditorView editor) {
    String _i18nKeyForEditor = this.i18nKeyForEditor(editor);
    return (_i18nKeyForEditor + ".SaveError");
  }
  
  @Localization
  public String i18nKeyForEditor(final GenEditorView editor) {
    CharSequence _className = this.className(editor);
    return ("" + _className);
  }
  
  public Iterable<String> buildImplementsList(final GenEditorView it) {
    List<String> result = CollectionLiterals.<String>newLinkedList();
    boolean _isIDEMode = this.isIDEMode(it);
    if (_isIDEMode) {
      result.add("org.eclipse.ui.ide.IGotoMarker");
    }
    if ((this.hasPropertySheet(it) && it.getEditorGen().getPropertySheet().isReadOnly())) {
      result.add("org.eclipse.gmf.runtime.diagram.ui.properties.views.IReadOnlyDiagramPropertySheetPageContributor");
    }
    return result;
  }
  
  public boolean isIDEMode(final GenEditorView it) {
    GenApplication _application = it.getEditorGen().getApplication();
    return (null == _application);
  }
  
  public boolean hasPropertySheet(final GenEditorView it) {
    GenPropertySheet _propertySheet = it.getEditorGen().getPropertySheet();
    return (_propertySheet != null);
  }
  
  public boolean hasNavigator(final GenEditorView it) {
    GenNavigator _navigator = it.getEditorGen().getNavigator();
    return (_navigator != null);
  }
  
  public CharSequence extendsList(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.uml.diagram.common.part.UmlGmfDiagramEditor");
    return _builder;
  }
  
  public CharSequence attributes(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public static final String ID = \"");
    String _iD = it.getID();
    _builder.append(_iD, "\t");
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("public static final String CONTEXT_ID = \"");
    String _contextID = it.getContextID();
    _builder.append(_contextID);
    _builder.append("\"; ");
    CharSequence _nonNLS_1 = this._common.nonNLS();
    _builder.append(_nonNLS_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.gef.KeyHandler paletteKeyHandler = null;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.swt.events.MouseListener paletteMouseListener = null;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.papyrus.commands.util.OperationHistoryDirtyState dirtyState;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("private org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider documentProvider;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _className = it.getClassName();
    _builder.append(_className);
    _builder.append("(org.eclipse.papyrus.infra.core.services.ServicesRegistry servicesRegistry, org.eclipse.gmf.runtime.notation.Diagram diagram) throws org.eclipse.papyrus.infra.core.services.ServiceException{");
    _builder.newLineIfNotEmpty();
    _builder.append("super(servicesRegistry, diagram);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// adds a listener to the palette service, which reacts to palette customizations");
    _builder.newLine();
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().addProviderChangeListener(this);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Share the same editing provider");
    _builder.newLine();
    _builder.append("editingDomain = servicesRegistry.getService(org.eclipse.emf.transaction.TransactionalEditingDomain.class);");
    _builder.newLine();
    _builder.append("documentProvider = new org.eclipse.papyrus.infra.gmfdiag.common.GmfMultiDiagramDocumentProvider(editingDomain);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// overrides editing domain created by super constructor");
    _builder.newLine();
    _builder.append("setDocumentProvider(documentProvider);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getNavigatorSelection(final GenNavigator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.jface.viewers.ISelection getNavigatorSelection() {");
    _builder.newLine();
    {
      GenNavigatorChildReference _diagramTopReference = this._utils_qvto.getDiagramTopReference(it);
      boolean _tripleNotEquals = (_diagramTopReference != null);
      if (_tripleNotEquals) {
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = getDiagramDocument();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _findSelectionBody = this.xptNavigatorLinkHelper.findSelectionBody(it);
    _builder.append(_findSelectionBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createPaletteRoot(final Palette it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.palette.PaletteRoot createPaletteRoot(org.eclipse.gef.palette.PaletteRoot existingPaletteRoot) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gef.palette.PaletteRoot paletteRoot;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (existingPaletteRoot == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("paletteRoot = org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().createPalette(this, getDefaultPaletteContent());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().updatePalette(existingPaletteRoot, this, getDefaultPaletteContent());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("paletteRoot = existingPaletteRoot;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("applyCustomizationsToPalette(paletteRoot);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return paletteRoot;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence Editor(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("@SuppressWarnings({\"deprecation\", \"restriction\"})");
    _builder.newLine();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _createPaletteRoot = this.createPaletteRoot(it.getEditorGen().getDiagram().getPalette());
    _builder.append(_createPaletteRoot, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _contextID = this.getContextID(it);
    _builder.append(_contextID, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _preferencesHint = this.getPreferencesHint(it);
    _builder.append(_preferencesHint, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _contributorId = this.getContributorId(it);
    _builder.append(_contributorId, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _adapter = this.getAdapter(it);
    _builder.append(_adapter, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _documentProvider = this.getDocumentProvider(it);
    _builder.append(_documentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _editingDomain = this.getEditingDomain(it);
    _builder.append(_editingDomain, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setDocumentProvider = this.setDocumentProvider(it);
    _builder.append(_setDocumentProvider, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _isIDEMode = this.isIDEMode(it);
      if (_isIDEMode) {
        _builder.append("\t");
        CharSequence _gotoMarker = this.gotoMarker(it);
        _builder.append(_gotoMarker, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isSaveAsAllowed = this.isSaveAsAllowed(it);
        _builder.append(_isSaveAsAllowed, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _doSaveAs = this.doSaveAs(it);
        _builder.append(_doSaveAs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _performSaveAs = this.performSaveAs(it);
        _builder.append(_performSaveAs, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _showInContext = this.getShowInContext(it);
        _builder.append(_showInContext, "\t");
        _builder.newLineIfNotEmpty();
        {
          boolean _hasNavigator = this.hasNavigator(it);
          if (_hasNavigator) {
            _builder.append("\t");
            CharSequence _navigatorSelection = this.getNavigatorSelection(it.getEditorGen().getNavigator());
            _builder.append(_navigatorSelection, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    CharSequence _configureGraphicalViewer = this.configureGraphicalViewer(it);
    _builder.append(_configureGraphicalViewer, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _generateCreateShortcutAction = it.getEditorGen().getDiagram().generateCreateShortcutAction();
      if (_generateCreateShortcutAction) {
        _builder.append("\t");
        CharSequence _initializeGraphicalViewer = this.initializeGraphicalViewer(it);
        _builder.append(_initializeGraphicalViewer, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _controlLastClickPositionProviderService = this.controlLastClickPositionProviderService(it);
        _builder.append(_controlLastClickPositionProviderService, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _dispose = this.dispose(it);
        _builder.append(_dispose, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _DropTargetListener = this.DropTargetListener(it);
        _builder.append(_DropTargetListener, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createPaletteCustomizer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.ui.palette.PaletteCustomizer createPaletteCustomizer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteCustomizer(getPreferenceStore());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _createEditingDomain = this.createEditingDomain(it);
    _builder.append(_createEditingDomain);
    _builder.newLineIfNotEmpty();
    CharSequence _configureDiagramEditDomain = this.configureDiagramEditDomain(it);
    _builder.append(_configureDiagramEditDomain);
    _builder.newLineIfNotEmpty();
    CharSequence _doSave = this.doSave(it);
    _builder.append(_doSave);
    _builder.newLineIfNotEmpty();
    CharSequence _dirtyState = this.getDirtyState(it);
    _builder.append(_dirtyState);
    _builder.newLineIfNotEmpty();
    CharSequence _setUndoContext = this.setUndoContext(it);
    _builder.append(_setUndoContext);
    _builder.newLineIfNotEmpty();
    CharSequence _isDirty = this.isDirty(it);
    _builder.append(_isDirty);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _handlePaletteChange = this.handlePaletteChange(it);
    _builder.append(_handlePaletteChange, "\t\t");
    _builder.newLineIfNotEmpty();
    CharSequence _dispose = this.dispose(it);
    _builder.append(_dispose);
    _builder.newLineIfNotEmpty();
    CharSequence _paletteViewer = this.getPaletteViewer(it);
    _builder.append(_paletteViewer);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    CharSequence _constructPaletteViewer = this.constructPaletteViewer(it);
    _builder.append(_constructPaletteViewer, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    CharSequence _createPaletteviewerProvider = this.createPaletteviewerProvider(it);
    _builder.append(_createPaletteviewerProvider);
    _builder.newLineIfNotEmpty();
    CharSequence _graphicalViewer = this.getGraphicalViewer(it);
    _builder.append(_graphicalViewer);
    _builder.newLineIfNotEmpty();
    CharSequence _initializeGraphicalViewer = this.initializeGraphicalViewer(it);
    _builder.append(_initializeGraphicalViewer);
    _builder.newLineIfNotEmpty();
    CharSequence _selectionChanged = this.selectionChanged(it);
    _builder.append(_selectionChanged);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence handlePaletteChange(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void providerChanged(org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent event) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// update the palette if the palette service has changed");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().equals(event.getSource())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().updatePalette(getPaletteViewer().getPaletteRoot(), this, getDefaultPaletteContent());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructPaletteViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.ui.palette.PaletteViewer constructPaletteViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteViewer();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence dispose(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// remove palette service listener");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// remove preference listener");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService.getInstance().removeProviderChangeListener(this);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(dirtyState != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dirtyState.dispose();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dirtyState = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.dispose();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getPaletteViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.ui.palette.PaletteViewer getPaletteViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getEditDomain().getPaletteViewer();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence implementsList(final Iterable<String> it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener");
    {
      boolean _isEmpty = IterableExtensions.isEmpty(it);
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append(", ");
        {
          boolean _hasElements = false;
          for(final String string : it) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            CharSequence _implementsListEntry = this.implementsListEntry(string);
            _builder.append(_implementsListEntry);
          }
        }
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence implementsListEntry(final String it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(it);
    return _builder;
  }
  
  public CharSequence createPaletteviewerProvider(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.ui.palette.PaletteViewerProvider createPaletteViewerProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getEditDomain().setPaletteRoot(createPaletteRoot(null));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.gef.ui.palette.PaletteViewerProvider(getEditDomain()) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* Override to provide the additional behavior for the tools. Will intialize with a");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* PaletteEditPartFactory that has a TrackDragger that understand how to handle the");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* mouseDoubleClick event for shape creation tools. Also will initialize the palette");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* with a defaultTool that is the SelectToolEx that undestands how to handle the enter");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* key which will result in the creation of the shape also.");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("protected void configurePaletteViewer(org.eclipse.gef.ui.palette.PaletteViewer viewer) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super.configurePaletteViewer(viewer);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// customize menu...");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.setContextMenu(new org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteContextMenuProvider(viewer));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.getKeyHandler().setParent(getPaletteKeyHandler());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.getControl().addMouseListener(getPaletteMouseListener());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// Add a transfer drag target listener that is supported on");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// palette template entries whose template is a creation tool.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// This will enable drag and drop of the palette shape creation");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// tools.");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.addDragSourceListener(new org.eclipse.gmf.runtime.diagram.ui.internal.parts.PaletteToolTransferDragSourceListener(viewer));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("viewer.setCustomizer(createPaletteCustomizer());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public org.eclipse.gef.ui.palette.PaletteViewer createPaletteViewer(org.eclipse.swt.widgets.Composite parent) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gef.ui.palette.PaletteViewer pViewer = constructPaletteViewer();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pViewer.createControl(parent);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("configurePaletteViewer(pViewer);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("hookPaletteViewer(pViewer);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return pViewer;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* @return Palette Key Handler for the palette");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.gef.KeyHandler getPaletteKeyHandler() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (paletteKeyHandler == null) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("paletteKeyHandler = new org.eclipse.gef.KeyHandler() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* Processes a <i>key released </i> event. This method is called by the Tool");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* whenever a key is released, and the Tool is in the proper state. Override");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* to support pressing the enter key to create a shape or connection");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* (between two selected shapes)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* @param event");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*            the KeyEvent");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* @return <code>true</code> if KeyEvent was handled in some way");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_3, "\t\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("public boolean keyReleased(org.eclipse.swt.events.KeyEvent event) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if (event.keyCode == org.eclipse.swt.SWT.Selection) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("org.eclipse.gef.Tool tool = getPaletteViewer().getActiveTool().createTool();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("if (toolSupportsAccessibility(tool)) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("tool.keyUp(event, getDiagramGraphicalViewer());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("// deactivate current selection");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("getPaletteViewer().setActiveTool(null);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("return super.keyReleased(event);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return paletteKeyHandler;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("* @return Palette Mouse listener for the palette");
    _builder.newLine();
    _builder.append("\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private org.eclipse.swt.events.MouseListener getPaletteMouseListener() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (paletteMouseListener == null) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("paletteMouseListener = new org.eclipse.swt.events.MouseListener() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* Flag to indicate that the current active tool should be cleared after a");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* mouse double-click event.");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("private boolean clearActiveTool = false;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* Override to support double-clicking a palette tool entry to create a");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* shape or connection (between two selected shapes).");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("* @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("org.eclipse.gef.Tool tool = getPaletteViewer().getActiveTool().createTool();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if (toolSupportsAccessibility(tool)) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("tool.setViewer(getDiagramGraphicalViewer());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("tool.setEditDomain(getDiagramGraphicalViewer().getEditDomain());");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("tool.mouseDoubleClick(e, getDiagramGraphicalViewer());");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("// Current active tool should be deactivated,");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("// but if it is down here it will get");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("// reactivated deep in GEF palette code after");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("// receiving mouse up events.");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("clearActiveTool = true;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_1, "\t\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("public void mouseDown(org.eclipse.swt.events.MouseEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("// do nothing");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _overrideI_2 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_2, "\t\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("public void mouseUp(org.eclipse.swt.events.MouseEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("// Deactivate current active tool here if a");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("// double-click was handled.");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("if (clearActiveTool) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("getPaletteViewer().setActiveTool(null);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("clearActiveTool = false;");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return paletteMouseListener;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performSaveAs(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void performSaveAs(org.eclipse.core.runtime.IProgressMonitor progressMonitor) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Nothing");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditingDomain(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.transaction.TransactionalEditingDomain getEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editingDomain;");
    _builder.newLine();
    _builder.append("}\t");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createEditingDomain(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.emf.transaction.TransactionalEditingDomain createEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Already configured");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return editingDomain;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence configureDiagramEditDomain(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void configureDiagramEditDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.configureDiagramEditDomain();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getDiagramEditDomain().getDiagramCommandStack().addCommandStackListener(new org.eclipse.gef.commands.CommandStackListener() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void commandStackChanged(java.util.EventObject event) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (org.eclipse.swt.widgets.Display.getCurrent() == null) { ");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.swt.widgets.Display.getDefault().asyncExec(new Runnable() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("firePropertyChange(org.eclipse.ui.IEditorPart.PROP_DIRTY);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("firePropertyChange(org.eclipse.ui.IEditorPart.PROP_DIRTY);\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doSave(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void doSave(org.eclipse.core.runtime.IProgressMonitor progressMonitor) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// The saving of the resource is done by the CoreMultiDiagramEditor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getDirtyState().saved();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDirtyState(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.papyrus.commands.util.OperationHistoryDirtyState getDirtyState() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(dirtyState == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dirtyState = org.eclipse.papyrus.commands.util.OperationHistoryDirtyState.newInstance(getUndoContext(), getOperationHistory());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return dirtyState;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setUndoContext(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setUndoContext(org.eclipse.core.commands.operations.IUndoContext context) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(dirtyState != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dirtyState.dispose();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("dirtyState = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.setUndoContext(context);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isDirty(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isDirty() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getDirtyState().isDirty();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDocumentProvider(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected final org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider getDocumentProvider(org.eclipse.ui.IEditorInput input) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return documentProvider;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setDocumentProvider(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected final void setDocumentProvider(org.eclipse.ui.IEditorInput input) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Already set in the constructor");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getGraphicalViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.GraphicalViewer getGraphicalViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getGraphicalViewer();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence initializeGraphicalViewer(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void initializeGraphicalViewer() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.initializeGraphicalViewer();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Enable Drop");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getDiagramGraphicalViewer().addDropTargetListener(new org.eclipse.papyrus.uml.diagram.common.listeners.DropTargetListener(getDiagramGraphicalViewer(), org.eclipse.jface.util.LocalSelectionTransfer.getTransfer()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("protected Object getJavaObject(org.eclipse.swt.dnd.TransferData data) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// It is usual for the transfer data not to be set because it is available locally");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return LocalSelectionTransfer.getTransfer().getSelection();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("protected org.eclipse.emf.transaction.TransactionalEditingDomain getTransactionalEditingDomain() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return getEditingDomain();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence selectionChanged(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public void selectionChanged(org.eclipse.ui.IWorkbenchPart part, org.eclipse.jface.viewers.ISelection selection) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getSite().getPage().getActiveEditor() instanceof org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor editor = (org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor) getSite().getPage().getActiveEditor();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// If not the active editor, ignore selection changed.");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (this.equals(editor.getActiveEditor())) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("updateActions(getSelectionActions());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super.selectionChanged(part, selection);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("super.selectionChanged(part, selection);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.selectionChanged(part, selection);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// from");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor.selectionChanged(IWorkbenchPart,");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ISelection)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (part == this) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("rebuildStatusLine();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getContextID(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected String getContextID() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return CONTEXT_ID;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdapter(final GenEditorView it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!this.hasPropertySheet(it)) || this.hasNavigator(it))) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("@SuppressWarnings(\"rawtypes\")");
        _builder.newLine();
        _builder.append("public Object getAdapter(Class type) {");
        _builder.newLine();
        {
          boolean _hasPropertySheet = this.hasPropertySheet(it);
          boolean _not = (!_hasPropertySheet);
          if (_not) {
            _builder.append("\t");
            _builder.append("if (type == org.eclipse.ui.views.properties.IPropertySheetPage.class) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        {
          boolean _hasNavigator = this.hasNavigator(it);
          if (_hasNavigator) {
            _builder.append("\t");
            _builder.append("if (type == org.eclipse.ui.part.IShowInTargetList.class) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return new org.eclipse.ui.part.IShowInTargetList() {");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            CharSequence _overrideI = this._codeStyle.overrideI(it);
            _builder.append(_overrideI, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("public String[] getShowInTargetIds() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("return new String[] { org.eclipse.ui.navigator.resources.ProjectExplorer.VIEW_ID };");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("return super.getAdapter(type);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
