/**
 * Copyright (c) 2013, 2020 Montages A.G., CEA LIST, Artal
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up parsers
 */
package parsers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ExpressionLabelParser;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;

/**
 * [MG] FIXME: revisit, he same problem as with the QualifiedClassNameProvider
 */
@Singleton
@SuppressWarnings("all")
public class ParsersUtil {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public CharSequence classNameCustomParser(final CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _lastSegment = this._common_qvto.lastSegment(it.getQualifiedName());
    _builder.append(_lastSegment);
    return _builder;
  }
  
  public CharSequence packageNameCustomParser(final CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _withoutLastSegment = this._common_qvto.withoutLastSegment(it.getQualifiedName());
    _builder.append(_withoutLastSegment);
    return _builder;
  }
  
  public CharSequence classNameExpressionLabelParser(final ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _lastSegment = this._common_qvto.lastSegment(it.getQualifiedClassName());
    _builder.append(_lastSegment);
    return _builder;
  }
  
  public CharSequence packageNameExpressionLabelParser(final ExpressionLabelParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _withoutLastSegment = this._common_qvto.withoutLastSegment(it.getQualifiedClassName());
    _builder.append(_withoutLastSegment);
    return _builder;
  }
  
  public CharSequence classNameGenParsers(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence packageNameGenParsers(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
}
