/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package metamodel;

import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;

@Singleton
@SuppressWarnings("all")
public class Facility_qvto {
  public String getNameToken(final GenPackage gp) {
    return gp.getPrefix();
  }
  
  public String fieldName(final GenPackage gp) {
    String _nameToken = this.getNameToken(gp);
    return ("instance" + _nameToken);
  }
}
