/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleRuleImpl;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.IRefreshHandlerPart;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.RefreshHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.SVGPostProcessor;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.css.xml.engine.CSSXMLEngineImpl;
import org.eclipse.ui.IEditorPart;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.svg.SVGDocument;

public class CssSvgPostProcessor
implements SVGPostProcessor,
IRefreshHandlerPart {
    private static final String CSS_PROPERTY_SVG_STYLESHEET = "svgCSSFile";
    private static final String CSS_PROPERTY_SVG_CLASS = "svgCSSClass";
    private CSSEngine engine = new CSSXMLEngineImpl();
    private WeakHashMap<Resource, Map<String, URI>> relativePaths = new WeakHashMap();
    private Collection<URI> loadedSheets = new ArrayList<URI>();
    private Collection<URI> failedSheets = new ArrayList<URI>();
    private Map<SVGDocument, Map<Element, Map<String, String>>> styledDocuments = new HashMap<SVGDocument, Map<Element, Map<String, String>>>();

    public CssSvgPostProcessor() {
        RefreshHandler.register((IRefreshHandlerPart)this);
    }

    public void refresh(IEditorPart editorPart) {
        this.relativePaths.clear();
        this.loadedSheets.clear();
        this.failedSheets.clear();
        this.styledDocuments.clear();
        this.engine.reset();
    }

    public void postProcess(EObject view, SVGDocument document) {
        if (document == null) {
            return;
        }
        if (view instanceof Node) {
            View shape = (View)view;
            StringValueStyle nsURI = (StringValueStyle)shape.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), CSS_PROPERTY_SVG_STYLESHEET);
            if (nsURI != null) {
                this.loadStylesheet(this.getCanonicalURI(shape.getElement(), nsURI.getStringValue()));
            }
            StringValueStyle nsClassName = (StringValueStyle)shape.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), CSS_PROPERTY_SVG_CLASS);
            String className = "";
            if (nsClassName != null) {
                className = nsClassName.getStringValue();
            }
            document.getDocumentElement().setAttribute("class", className);
            this.applyStyles(document);
        }
    }

    private void loadStylesheet(URI uri) {
        StyleSheet sheet;
        block17: {
            InputStream stream;
            if (uri == null || uri.isEmpty()) {
                return;
            }
            if (this.loadedSheets.contains(uri)) {
                return;
            }
            if (this.failedSheets.contains(uri)) {
                return;
            }
            try {
                stream = URIConverter.INSTANCE.createInputStream(uri);
            }
            catch (IOException e) {
                Activator.log.error("Failed to locate stylesheet from " + uri, (Throwable)e);
                this.failedSheets.add(uri);
                return;
            }
            sheet = null;
            try {
                try {
                    sheet = this.engine.parseStyleSheet(stream);
                }
                catch (IOException e) {
                    Activator.log.error("Failed to load stylesheet at " + uri, (Throwable)e);
                    this.failedSheets.add(uri);
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sheet != null) {
            this.loadedSheets.add(uri);
        }
    }

    private URI getCanonicalURI(EObject model, String uri) {
        URI canonical;
        if (uri.startsWith("platform:/")) {
            return URI.createURI((String)uri);
        }
        Map<String, URI> resMap = this.relativePaths.get(model.eResource());
        if (resMap == null) {
            resMap = new HashMap<String, URI>();
            this.relativePaths.put(model.eResource(), resMap);
        }
        if ((canonical = resMap.get(uri)) != null) {
            return canonical;
        }
        URI resURI = model.eResource().getURI();
        if (!resURI.isPlatform()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("platform:/");
        String[] segments = resURI.segments();
        int i = 0;
        while (i < segments.length - 1) {
            builder.append(segments[i]);
            builder.append("/");
            ++i;
        }
        builder.append(uri);
        canonical = URI.createURI((String)builder.toString());
        resMap.put(uri, canonical);
        return canonical;
    }

    private void applyStyles(SVGDocument document) {
        List<CSSStyleRule> rules = this.getAllRulesIn(this.engine.getDocumentCSS());
        Map<Element, Map<String, String>> originals = this.styledDocuments.get(document);
        if (originals == null) {
            originals = new HashMap<Element, Map<String, String>>();
            this.styledDocuments.put(document, originals);
        }
        this.applyStyles(document.getDocumentElement(), rules, originals);
    }

    private void applyStyles(Element element, List<CSSStyleRule> rules, Map<Element, Map<String, String>> originals) {
        int i = 0;
        while (i != element.getChildNodes().getLength()) {
            org.w3c.dom.Node child = element.getChildNodes().item(i);
            if (child instanceof Element) {
                this.applyStyles((Element)child, rules, originals);
            }
            ++i;
        }
        Map<String, String> style = originals.get(element);
        if (style == null) {
            style = this.getBaseStyle(element);
            originals.put(element, style);
        }
        style = new HashMap<String, String>(style);
        List<CSSStyleRule> applicable = this.getApplicableRules(element, rules);
        for (CSSStyleRule rule : applicable) {
            this.applyRuleTo(rule, style);
        }
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> entry : style.entrySet()) {
            if (count != 0) {
                builder.append(";");
            }
            builder.append(entry.getKey());
            builder.append(":");
            builder.append(entry.getValue());
            ++count;
        }
        element.setAttribute("style", builder.toString());
    }

    private List<CSSStyleRule> getAllRulesIn(DocumentCSS css) {
        ArrayList<CSSStyleRule> result = new ArrayList<CSSStyleRule>();
        int i = 0;
        while (i != css.getStyleSheets().getLength()) {
            StyleSheet ss = css.getStyleSheets().item(i);
            if (ss instanceof CSSStyleSheet) {
                CSSStyleSheet cs = (CSSStyleSheet)ss;
                int j = 0;
                while (j != cs.getCssRules().getLength()) {
                    CSSRule rule = cs.getCssRules().item(j);
                    if (rule.getType() == 1) {
                        result.add((CSSStyleRule)rule);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private List<CSSStyleRule> getApplicableRules(Element svgElement, List<CSSStyleRule> rules) {
        ArrayList<CSSStyleRule> matching = new ArrayList<CSSStyleRule>();
        for (CSSStyleRule rule : rules) {
            SelectorList selectors = ((CSSStyleRuleImpl)rule).getSelectorList();
            boolean match = true;
            int i = 0;
            while (i != selectors.getLength()) {
                ExtendedSelector xs = (ExtendedSelector)selectors.item(i);
                if (!xs.match(svgElement, null)) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            matching.add(rule);
        }
        if (matching.isEmpty()) {
            return matching;
        }
        boolean[] available = new boolean[matching.size()];
        Arrays.fill(available, 0, available.length, true);
        int i = 0;
        while (i != matching.size()) {
            CSSStyleRule rule = (CSSStyleRule)matching.get(i);
            if (rule != null && rule.getParentRule() != null) {
                int j = 0;
                while (j != matching.size()) {
                    if (matching.get(i) == rule.getParentRule()) {
                        available[i] = false;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        ArrayList<CSSStyleRule> result = new ArrayList<CSSStyleRule>();
        int i2 = 0;
        while (i2 != matching.size()) {
            if (available[i2]) {
                result.add((CSSStyleRule)matching.get(i2));
            }
            ++i2;
        }
        return result;
    }

    private Map<String, String> getBaseStyle(Element element) {
        HashMap<String, String> result = new HashMap<String, String>();
        String styleValue = element.getAttribute("style");
        if (styleValue != null && !styleValue.isEmpty()) {
            String[] props = styleValue.split(";");
            int i = 0;
            while (i != props.length) {
                String[] temp = props[i].split(":");
                if (temp.length == 2) {
                    result.put(temp[0], temp[1]);
                } else if (temp.length > 2) {
                    StringBuilder builder = new StringBuilder(temp[1]);
                    int j = 2;
                    while (j != temp.length) {
                        builder.append(":");
                        builder.append(temp[j]);
                        ++j;
                    }
                    result.put(temp[0], builder.toString());
                }
                ++i;
            }
        }
        return result;
    }

    private void applyRuleTo(CSSStyleRule rule, Map<String, String> properties) {
        if (rule.getParentRule() != null) {
            this.applyRuleTo((CSSStyleRule)rule.getParentRule(), properties);
        }
        int i = 0;
        while (i != rule.getStyle().getLength()) {
            String name = rule.getStyle().item(i);
            String value = rule.getStyle().getPropertyCSSValue(name).getCssText();
            properties.put(name, value);
            ++i;
        }
    }
}

