/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.valuespecification.xtext.utils.commands;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.validation.commands.AsyncValidateSubtreeCommand;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.AbstractRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.LiteralBooleanRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.LiteralIntegerOrUnlimitedNaturalRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.LiteralNullRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.LiteralRealRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.umlValueSpecification.LiteralStringRule;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.utils.Activator;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class ValueSpecificationSetCommand {
    private static ValueSpecificationSetCommand instance = new ValueSpecificationSetCommand();

    public static ValueSpecificationSetCommand getInstance() {
        return instance;
    }

    public CompositeCommand createSetCommand(Injector injector, EObject objectToEdit, EStructuralFeature structuralFeature, String xtextStringValue, Collection<String> defaultLanguages) {
        ValueSpecification initialValueSpecification = null;
        if (structuralFeature != null) {
            initialValueSpecification = (ValueSpecification)objectToEdit.eGet(structuralFeature);
        }
        CompositeCommand result = new CompositeCommand("validation");
        ContextElementAdapter.IContextElementProvider provider = this.getContextProvider(objectToEdit);
        XtextFakeResourceContext context = new XtextFakeResourceContext(injector);
        context.getFakeResource().eAdapters().add((Object)new ContextElementAdapter(provider));
        try {
            context.getFakeResource().load((InputStream)new StringInputStream(xtextStringValue), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
            ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
        }
        EcoreUtil2.resolveLazyCrossReferences((Resource)context.getFakeResource(), (CancelIndicator)CancelIndicator.NullImpl);
        if (!context.getFakeResource().getParseResult().hasSyntaxErrors() && context.getFakeResource().getErrors().size() == 0) {
            EObject xtextObject = context.getFakeResource().getParseResult().getRootASTElement();
            ICommand cmd = this.getParseCommand(objectToEdit, initialValueSpecification, structuralFeature, xtextObject, xtextStringValue, defaultLanguages);
            if (cmd != null) {
                result.add((IUndoableOperation)cmd);
            }
        } else {
            result.add((IUndoableOperation)this.manageOpaqueExpression(objectToEdit, structuralFeature, initialValueSpecification, xtextStringValue, defaultLanguages));
        }
        AsyncValidateSubtreeCommand validationCommand = new AsyncValidateSubtreeCommand(objectToEdit);
        validationCommand.disableUIFeedback();
        result.add((IUndoableOperation)validationCommand);
        return result;
    }

    public ICommand getParseCommand(EObject objectToEdit, EStructuralFeature structuralFeature, EObject xtextObject, String xtextStringValue, Collection<String> defaultLanguages) {
        ValueSpecification initialValueSpecification = null;
        if (structuralFeature != null) {
            initialValueSpecification = (ValueSpecification)objectToEdit.eGet(structuralFeature);
        }
        return this.getParseCommand(objectToEdit, initialValueSpecification, structuralFeature, xtextObject, xtextStringValue, defaultLanguages);
    }

    protected ICommand getParseCommand(EObject objectToEdit, ValueSpecification initialValueSpecification, EStructuralFeature structuralFeature, EObject xtextObject, String xtextStringValue, Collection<String> defaultLanguages) {
        if (!(objectToEdit == null || objectToEdit instanceof MultiplicityElement && ((MultiplicityElement)objectToEdit).isMultivalued())) {
            return this.manageValueSpecification(objectToEdit, structuralFeature, initialValueSpecification, xtextObject, xtextStringValue, defaultLanguages);
        }
        return this.manageOpaqueExpression(objectToEdit, structuralFeature, initialValueSpecification, xtextStringValue, defaultLanguages);
    }

    protected ICommand createCommand(EObject objectToEdit, EStructuralFeature structuralFeature, ValueSpecification valueSpecification) {
        CompositeCommand setValueCommand = new CompositeCommand("Set Value Specification Command");
        SetRequest request = new SetRequest(objectToEdit, structuralFeature, (Object)valueSpecification);
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)objectToEdit);
        ICommand setDefaultValueCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
        if (setDefaultValueCommand != null && setDefaultValueCommand.canExecute()) {
            setValueCommand.add((IUndoableOperation)setDefaultValueCommand);
        } else {
            setValueCommand.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
        }
        return setValueCommand.isEmpty() ? null : setValueCommand;
    }

    protected ICommand manageValueSpecification(EObject objectToEdit, EStructuralFeature structuralFeature, ValueSpecification initialValueSpecification, EObject xtextObject, String xtextStringValue, Collection<String> defaultLanguages) {
        ICommand resultCommand = null;
        ValueSpecification newValueSpecification = null;
        if (xtextObject instanceof AbstractRule) {
            if (((AbstractRule)xtextObject).getUndefined() != null) {
                if (initialValueSpecification != null) {
                    resultCommand = this.createCommand(objectToEdit, structuralFeature, null);
                }
            } else {
                AbstractRule abstractRule = (AbstractRule)xtextObject;
                newValueSpecification = this.getObjectToUpdate(objectToEdit, initialValueSpecification, (EObject)abstractRule);
                if (newValueSpecification != null) {
                    resultCommand = this.createUpdateValueSpecificationCommand(objectToEdit, structuralFeature, newValueSpecification, abstractRule);
                } else {
                    newValueSpecification = this.createValueSpecification(objectToEdit, (EObject)initialValueSpecification, abstractRule);
                    if (newValueSpecification != null) {
                        this.affectAttributes(newValueSpecification, abstractRule);
                    } else {
                        newValueSpecification = this.createOpaqueExpression((EObject)initialValueSpecification, xtextStringValue, defaultLanguages);
                    }
                    resultCommand = this.createCommand(objectToEdit, structuralFeature, newValueSpecification);
                }
            }
        }
        return resultCommand;
    }

    protected ValueSpecification createValueSpecification(EObject objectToEdit, EObject initialValueSpecification, AbstractRule abstractRule) {
        InstanceValue createdValueSpecification = null;
        EObject value = abstractRule.getValue();
        if (abstractRule.getInstanceSpecification() != null) {
            createdValueSpecification = UMLFactory.eINSTANCE.createInstanceValue();
            createdValueSpecification.setInstance(abstractRule.getInstanceSpecification());
        } else if (value instanceof LiteralBooleanRule) {
            if (this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_BOOLEAN)) {
                createdValueSpecification = UMLFactory.eINSTANCE.createLiteralBoolean();
                this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                ((LiteralBoolean)createdValueSpecification).setValue(Boolean.parseBoolean(((LiteralBooleanRule)value).getValue()));
            }
        } else if (value instanceof LiteralIntegerOrUnlimitedNaturalRule) {
            boolean created = false;
            LiteralIntegerOrUnlimitedNaturalRule integerValue = (LiteralIntegerOrUnlimitedNaturalRule)value;
            if (integerValue.getUnlimited() != null) {
                createdValueSpecification = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
                this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                ((LiteralUnlimitedNatural)createdValueSpecification).setValue(-1);
                created = true;
            } else {
                int intValue = integerValue.getValue();
                if (intValue >= 0 && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL)) {
                    createdValueSpecification = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
                    this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                    ((LiteralUnlimitedNatural)createdValueSpecification).setValue(intValue);
                    created = true;
                }
                if (!created && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_INTEGER)) {
                    createdValueSpecification = UMLFactory.eINSTANCE.createLiteralInteger();
                    this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                    ((LiteralInteger)createdValueSpecification).setValue(intValue);
                    created = true;
                }
                if (!created && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_REAL)) {
                    createdValueSpecification = UMLFactory.eINSTANCE.createLiteralReal();
                    this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                    ((LiteralReal)createdValueSpecification).setValue((double)intValue);
                }
            }
        } else if (value instanceof LiteralRealRule) {
            if (this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_REAL)) {
                createdValueSpecification = UMLFactory.eINSTANCE.createLiteralReal();
                this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
                ((LiteralReal)createdValueSpecification).setValue(((LiteralRealRule)value).getValue());
            }
        } else if (value instanceof LiteralNullRule) {
            createdValueSpecification = UMLFactory.eINSTANCE.createLiteralNull();
            this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
        } else if (value instanceof LiteralStringRule) {
            createdValueSpecification = UMLFactory.eINSTANCE.createLiteralString();
            this.copyFeatureValues((ValueSpecification)createdValueSpecification, initialValueSpecification);
            ((LiteralString)createdValueSpecification).setValue(((LiteralStringRule)value).getValue());
        }
        return createdValueSpecification;
    }

    protected void affectAttributes(ValueSpecification createdValueSpecification, AbstractRule abstractRule) {
        if (abstractRule.getVisibility() != null) {
            VisibilityKind visibility = null;
            if (abstractRule.getVisibility().getPublic() != null) {
                visibility = VisibilityKind.PUBLIC_LITERAL;
            } else if (abstractRule.getVisibility().getPackage() != null) {
                visibility = VisibilityKind.PACKAGE_LITERAL;
            } else if (abstractRule.getVisibility().getProtected() != null) {
                visibility = VisibilityKind.PROTECTED_LITERAL;
            } else if (abstractRule.getVisibility().getPrivate() != null) {
                visibility = VisibilityKind.PRIVATE_LITERAL;
            }
            createdValueSpecification.setVisibility(visibility);
        }
        if (this.getName(abstractRule) != null) {
            createdValueSpecification.setName(this.getName(abstractRule));
        }
    }

    protected ICommand createUpdateValueSpecificationCommand(EObject objectToEdit, EStructuralFeature structuralFeature, ValueSpecification valueSpecification, AbstractRule abstractRule) {
        ICommand setValueCommand;
        String newName;
        CompositeCommand setAttributesCommand = new CompositeCommand("Update Value Specification Command");
        if (abstractRule.getVisibility() != null) {
            VisibilityKind visibility = null;
            if (abstractRule.getVisibility().getPublic() != null) {
                visibility = VisibilityKind.PUBLIC_LITERAL;
            } else if (abstractRule.getVisibility().getPackage() != null) {
                visibility = VisibilityKind.PACKAGE_LITERAL;
            } else if (abstractRule.getVisibility().getProtected() != null) {
                visibility = VisibilityKind.PROTECTED_LITERAL;
            } else if (abstractRule.getVisibility().getPrivate() != null) {
                visibility = VisibilityKind.PRIVATE_LITERAL;
            }
            if (valueSpecification.getVisibility() == null || !valueSpecification.getVisibility().equals((Object)visibility)) {
                SetRequest request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__VISIBILITY, (Object)visibility);
                IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)valueSpecification);
                ICommand setVisibilityCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
                if (setVisibilityCommand != null && setVisibilityCommand.canExecute()) {
                    setAttributesCommand.add((IUndoableOperation)setVisibilityCommand);
                }
            }
        }
        if ((newName = this.getName(abstractRule)) != null) {
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)valueSpecification) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)valueSpecification) != null) {
                EMFtoGMFCommandWrapper setLabelCommand;
                ModelSet modelSet = (ModelSet)valueSpecification.eResource().getResourceSet();
                if (modelSet != null && (setLabelCommand = new EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand((EditingDomain)modelSet.getTransactionalEditingDomain(), (NamedElement)valueSpecification, newName, null))) != null && setLabelCommand.canExecute()) {
                    setAttributesCommand.add((IUndoableOperation)setLabelCommand);
                }
            } else {
                ICommand setNameCommand = this.createSetNameCommand(valueSpecification, newName);
                if (setNameCommand != null && setNameCommand.canExecute()) {
                    setAttributesCommand.add((IUndoableOperation)setNameCommand);
                }
            }
        }
        if ((setValueCommand = this.createSetValueCommand(valueSpecification, abstractRule)) != null && setValueCommand.canExecute()) {
            setAttributesCommand.add((IUndoableOperation)setValueCommand);
        }
        SetRequest unsetRequest = new SetRequest(objectToEdit, structuralFeature, null);
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)objectToEdit);
        ICommand unsetCommand = commandProvider.getEditCommand((IEditCommandRequest)unsetRequest);
        if (unsetCommand != null && unsetCommand.canExecute()) {
            setAttributesCommand.add((IUndoableOperation)unsetCommand);
            SetRequest resetRequest = new SetRequest(objectToEdit, structuralFeature, (Object)valueSpecification);
            ICommand resetCommand = commandProvider.getEditCommand((IEditCommandRequest)resetRequest);
            if (resetCommand != null && resetCommand.canExecute()) {
                setAttributesCommand.add((IUndoableOperation)resetCommand);
            }
        }
        return setAttributesCommand.isEmpty() ? null : setAttributesCommand;
    }

    protected ICommand createSetNameCommand(ValueSpecification valueSpecification, String name) {
        ICommand resultCommand = null;
        if (valueSpecification.getName() == null || !valueSpecification.getName().equals(name)) {
            SetRequest request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.NAMED_ELEMENT__NAME, (Object)name);
            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)valueSpecification);
            resultCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
        }
        return resultCommand;
    }

    protected ICommand createSetValueCommand(ValueSpecification valueSpecification, AbstractRule abstractRule) {
        ICommand resultCommand = null;
        SetRequest request = null;
        if (valueSpecification instanceof InstanceValue && abstractRule.getInstanceSpecification() != null) {
            request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.INSTANCE_VALUE__INSTANCE, (Object)abstractRule.getInstanceSpecification());
        } else {
            EObject xtextValue = abstractRule.getValue();
            if (valueSpecification instanceof LiteralBoolean && xtextValue instanceof LiteralBooleanRule) {
                request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_BOOLEAN__VALUE, (Object)Boolean.parseBoolean(((LiteralBooleanRule)xtextValue).getValue()));
            } else if (valueSpecification instanceof LiteralInteger && xtextValue instanceof LiteralIntegerOrUnlimitedNaturalRule && ((LiteralIntegerOrUnlimitedNaturalRule)xtextValue).getUnlimited() == null) {
                request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_INTEGER__VALUE, (Object)((LiteralIntegerOrUnlimitedNaturalRule)xtextValue).getValue());
            } else if (valueSpecification instanceof LiteralUnlimitedNatural && xtextValue instanceof LiteralIntegerOrUnlimitedNaturalRule) {
                int intValue = 0;
                intValue = ((LiteralIntegerOrUnlimitedNaturalRule)xtextValue).getUnlimited() != null ? -1 : ((LiteralIntegerOrUnlimitedNaturalRule)xtextValue).getValue();
                request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL__VALUE, (Object)intValue);
            } else if (valueSpecification instanceof LiteralReal && xtextValue instanceof LiteralRealRule) {
                request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_REAL__VALUE, (Object)((LiteralRealRule)xtextValue).getValue());
            } else if (valueSpecification instanceof LiteralString && xtextValue instanceof LiteralStringRule) {
                request = new SetRequest((EObject)valueSpecification, (EStructuralFeature)UMLPackage.Literals.LITERAL_STRING__VALUE, (Object)((LiteralStringRule)xtextValue).getValue());
            }
        }
        if (request != null) {
            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)valueSpecification);
            resultCommand = commandProvider.getEditCommand((IEditCommandRequest)request);
        }
        return resultCommand;
    }

    protected void copyFeatureValues(ValueSpecification newValueSpecification, EObject existingObject) {
        if (existingObject != null && existingObject instanceof ValueSpecification) {
            ValueSpecification existingValueSpecification = (ValueSpecification)existingObject;
            for (EStructuralFeature structuralFeature : existingValueSpecification.eClass().getEAllStructuralFeatures()) {
                if (!structuralFeature.isChangeable() || !newValueSpecification.eClass().getEAllStructuralFeatures().contains((Object)structuralFeature) || existingObject instanceof OpaqueExpression && structuralFeature.equals(UMLPackage.Literals.NAMED_ELEMENT__NAME)) continue;
                newValueSpecification.eSet(structuralFeature, existingObject.eGet(structuralFeature));
            }
            String existingLabel = UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)((ValueSpecification)existingObject));
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)existingObject) && existingLabel != null) {
                UMLLabelInternationalization.getInstance().setLabel((NamedElement)newValueSpecification, existingLabel, null);
            }
        }
    }

    protected boolean isTypeNeeeded(Object object, Object typeNeeded) {
        boolean result = false;
        if (!(object instanceof TypedElement)) {
            result = true;
        } else {
            TypedElement typedElement = (TypedElement)object;
            if (typedElement.getType() == null || !(typedElement.getType() instanceof PrimitiveType)) {
                result = true;
            } else if (typedElement.getType() instanceof PrimitiveType) {
                PrimitiveType type = (PrimitiveType)typedElement.getType();
                if (typeNeeded.equals(UMLPackage.Literals.LITERAL_BOOLEAN)) {
                    result = UMLUtil.isBoolean((Type)type);
                } else if (typeNeeded.equals(UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL)) {
                    result = UMLUtil.isUnlimitedNatural((Type)type);
                } else if (typeNeeded.equals(UMLPackage.Literals.LITERAL_INTEGER)) {
                    result = UMLUtil.isInteger((Type)type);
                } else if (typeNeeded.equals(UMLPackage.Literals.LITERAL_REAL)) {
                    result = UMLUtil.isReal((Type)type);
                }
            }
        }
        return result;
    }

    protected ICommand manageOpaqueExpression(EObject initialEObject, EStructuralFeature structuralFeature, ValueSpecification initialValueSpecification, String xtextStringValue, Collection<String> defaultLanguages) {
        ICommand resultCommand = null;
        if (initialValueSpecification != null && initialValueSpecification instanceof OpaqueExpression && !xtextStringValue.isEmpty()) {
            resultCommand = this.createUpdateOpaqueExpressionCommand((OpaqueExpression)initialValueSpecification, xtextStringValue);
        } else {
            OpaqueExpression createdOpaqueExpression = null;
            if (!xtextStringValue.isEmpty()) {
                createdOpaqueExpression = this.createOpaqueExpression((EObject)initialValueSpecification, xtextStringValue, defaultLanguages);
            }
            resultCommand = this.createCommand(initialEObject, structuralFeature, (ValueSpecification)createdOpaqueExpression);
        }
        return resultCommand;
    }

    protected ICommand createUpdateOpaqueExpressionCommand(OpaqueExpression opaqueExpression, String name) {
        CompositeCommand setAttributesCommand = new CompositeCommand("Update Opaque Expression Command");
        if (!name.isEmpty()) {
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)opaqueExpression) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)opaqueExpression) != null) {
                EMFtoGMFCommandWrapper setLabelCommand;
                ModelSet modelSet = (ModelSet)opaqueExpression.eResource().getResourceSet();
                if (modelSet != null && (setLabelCommand = new EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand((EditingDomain)modelSet.getTransactionalEditingDomain(), (NamedElement)opaqueExpression, name, null))) != null && setLabelCommand.canExecute()) {
                    setAttributesCommand.add((IUndoableOperation)setLabelCommand);
                }
            } else {
                ICommand setNameCommand = this.createSetNameCommand((ValueSpecification)opaqueExpression, name);
                if (setNameCommand != null && setNameCommand.canExecute()) {
                    setAttributesCommand.add((IUndoableOperation)setNameCommand);
                }
            }
        }
        return setAttributesCommand;
    }

    protected OpaqueExpression createOpaqueExpression(EObject initiaValueSpecification, String xtextStringValue, Collection<String> defaultLanguages) {
        OpaqueExpression valueSpecification = UMLFactory.eINSTANCE.createOpaqueExpression();
        this.copyFeatureValues((ValueSpecification)valueSpecification, initiaValueSpecification);
        valueSpecification.getLanguages().addAll(defaultLanguages);
        valueSpecification.setName(xtextStringValue);
        return valueSpecification;
    }

    protected ContextElementAdapter.IContextElementProvider getContextProvider(final EObject objectToEdit) {
        return new ContextElementAdapter.IContextElementProvider(){

            public EObject getContextObject() {
                if (objectToEdit instanceof EObject) {
                    return objectToEdit;
                }
                return null;
            }
        };
    }

    protected ValueSpecification getObjectToUpdate(EObject objectToEdit, ValueSpecification initialValueSpecification, EObject xtextObject) {
        InstanceValue result = null;
        if (initialValueSpecification != null && xtextObject != null && xtextObject instanceof AbstractRule && ((AbstractRule)xtextObject).getUndefined() == null) {
            AbstractRule abstractRule = (AbstractRule)xtextObject;
            if (initialValueSpecification instanceof InstanceValue && abstractRule.getInstanceSpecification() != null) {
                result = (InstanceValue)initialValueSpecification;
            } else {
                EObject xtextValue = abstractRule.getValue();
                if (initialValueSpecification instanceof LiteralBoolean && xtextValue instanceof LiteralBooleanRule && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_BOOLEAN)) {
                    result = (LiteralBoolean)initialValueSpecification;
                } else if (initialValueSpecification instanceof LiteralInteger && xtextValue instanceof LiteralIntegerOrUnlimitedNaturalRule && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_INTEGER)) {
                    if (((LiteralIntegerOrUnlimitedNaturalRule)xtextValue).getUnlimited() == null) {
                        result = (LiteralInteger)initialValueSpecification;
                    }
                } else if (initialValueSpecification instanceof LiteralUnlimitedNatural && xtextValue instanceof LiteralIntegerOrUnlimitedNaturalRule && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL)) {
                    LiteralIntegerOrUnlimitedNaturalRule integerValue = (LiteralIntegerOrUnlimitedNaturalRule)xtextValue;
                    if (integerValue.getUnlimited() != null || integerValue.getValue() >= 0) {
                        result = (LiteralUnlimitedNatural)initialValueSpecification;
                    }
                } else if (initialValueSpecification instanceof LiteralReal && xtextValue instanceof LiteralRealRule && this.isTypeNeeeded(objectToEdit, UMLPackage.Literals.LITERAL_REAL)) {
                    result = (LiteralReal)initialValueSpecification;
                } else if (initialValueSpecification instanceof LiteralNull && xtextValue instanceof LiteralNullRule) {
                    result = (LiteralNull)initialValueSpecification;
                } else if (initialValueSpecification instanceof LiteralString && xtextValue instanceof LiteralStringRule) {
                    result = (LiteralString)initialValueSpecification;
                }
            }
        }
        return result;
    }

    protected String getName(AbstractRule abstractRule) {
        return abstractRule.getName() == null ? null : abstractRule.getName().substring(0, abstractRule.getName().length() - 1);
    }
}

