/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AxisIndexStyle implements Enumerator
{
    ALPHABETIC(1, "ALPHABETIC", "ALPHABETIC"),
    NUMERIC(0, "NUMERIC", "NUMERIC");

    public static final int ALPHABETIC_VALUE = 1;
    public static final int NUMERIC_VALUE = 0;
    private static final AxisIndexStyle[] VALUES_ARRAY;
    public static final List<AxisIndexStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AxisIndexStyle[]{ALPHABETIC, NUMERIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AxisIndexStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisIndexStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisIndexStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisIndexStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisIndexStyle get(int value) {
        switch (value) {
            case 1: {
                return ALPHABETIC;
            }
            case 0: {
                return NUMERIC;
            }
        }
        return null;
    }

    private AxisIndexStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

