/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.nattable.contentprovider.RowContainmentFeatureContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.RowElementTypeIdContentProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.nattable.wizard.CategoriesWizardUtils;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ConfigurePastePage
extends WizardPage {
    private static final Image CHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/checked.gif");
    private static final Image UNCHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/unchecked.gif");
    private static String UNDEFINED = "<Undefined>";
    protected INattableModelManager nattableManager = null;
    protected TreeViewer treeViewer;
    protected List<Object> initialSelection;
    protected ILabelProvider treeItemWrappedLabelProvider;
    protected ILabelProvider containmentFeatureLabelProvider;
    protected IStaticContentProvider containmentFeatureContentProvider;
    protected Map<ITreeItemAxis, PasteEObjectConfiguration> pasteConfigurations;

    public ConfigurePastePage(String pageName, INattableModelManager nattableManager, ILabelProvider treeItemWrappedLabelProvider, ILabelProvider containmentFeatureLabelProvider, IStaticContentProvider containmentFeatureContentProvider) {
        super(pageName);
        this.setTitle(pageName);
        this.nattableManager = nattableManager;
        this.pasteConfigurations = new HashMap<ITreeItemAxis, PasteEObjectConfiguration>();
        this.treeItemWrappedLabelProvider = treeItemWrappedLabelProvider;
        this.containmentFeatureLabelProvider = containmentFeatureLabelProvider;
        this.containmentFeatureContentProvider = containmentFeatureContentProvider;
    }

    public void setInitialElementSelections(List<Object> arrayList) {
        this.initialSelection = arrayList;
        if (this.treeViewer != null) {
            this.treeViewer.setInput(this.initialSelection);
            this.treeViewer.expandAll();
        }
    }

    public void createControl(Composite parent) {
        Composite treeViewerComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        treeViewerComposite.setLayout((Layout)gridLayout);
        final Tree tree = new Tree(treeViewerComposite, 68354);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        treeViewerComposite.setLayout((Layout)columnLayout);
        this.treeViewer = new TreeViewer(tree);
        TreeViewerColumn firstViewerColumn = this.createTreeViewerColumn(this.treeViewer, Messages.ConfigurePastePage_firstColumnTitle);
        firstViewerColumn.getColumn().setAlignment(0x1000000);
        columnLayout.setColumnData((Widget)firstViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(225));
        firstViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ConfigurePastePage.this.treeItemWrappedLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return ConfigurePastePage.this.treeItemWrappedLabelProvider.getImage(element);
            }
        });
        TreeViewerColumn secondViewerColumn = this.createTreeViewerColumn(this.treeViewer, Messages.ConfigurePastePage_secondColumnTitle);
        secondViewerColumn.getColumn().setAlignment(0x1000000);
        columnLayout.setColumnData((Widget)secondViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(75));
        secondViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        secondViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                if (ConfigurePastePage.this.canEditPasteConfiguration(element)) {
                    PasteEObjectConfiguration pasteConfiguration = ConfigurePastePage.this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element);
                    if (pasteConfiguration != null) {
                        if (ConfigurePastePage.this.pasteConfigurations.get(element) == null) {
                            ConfigurePastePage.this.pasteConfigurations.put((ITreeItemAxis)element, (PasteEObjectConfiguration)EcoreUtil.copy((EObject)pasteConfiguration));
                        }
                        ConfigurePastePage.this.pasteConfigurations.get(element).setDetachedMode(((Boolean)value).booleanValue());
                    }
                    ConfigurePastePage.this.treeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return ConfigurePastePage.this.getDetachedMode(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)tree, 40);
            }

            protected boolean canEdit(Object element) {
                return ConfigurePastePage.this.canEditPasteConfiguration(element);
            }
        });
        TreeViewerColumn thirdViewerColumn = this.createTreeViewerColumn(this.treeViewer, Messages.ConfigurePastePage_thirdColumnTitle);
        thirdViewerColumn.getColumn().setAlignment(0x1000000);
        columnLayout.setColumnData((Widget)thirdViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(230));
        thirdViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }
        });
        thirdViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                if (ConfigurePastePage.this.canEditPasteConfiguration(element)) {
                    PasteEObjectConfiguration pasteConfiguration = ConfigurePastePage.this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element);
                    if (pasteConfiguration != null) {
                        if (ConfigurePastePage.this.pasteConfigurations.get(element) == null) {
                            ConfigurePastePage.this.pasteConfigurations.put((ITreeItemAxis)element, (PasteEObjectConfiguration)EcoreUtil.copy((EObject)pasteConfiguration));
                        }
                        ConfigurePastePage.this.pasteConfigurations.get(element).setPastedElementId((String)value);
                    }
                    ConfigurePastePage.this.treeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return ConfigurePastePage.this.getPastedElementId(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return new ExtendedComboBoxCellEditor((Composite)tree, Arrays.asList(new RowElementTypeIdContentProvider(ConfigurePastePage.this.nattableManager).getElements()), (ILabelProvider)new LabelProvider(), 8);
            }

            protected boolean canEdit(Object element) {
                return ConfigurePastePage.this.canEditPasteConfiguration(element);
            }
        });
        TreeViewerColumn fourthViewerColumn = this.createTreeViewerColumn(this.treeViewer, Messages.ConfigurePastePage_fourthColumnTitle);
        fourthViewerColumn.getColumn().setAlignment(0x1000000);
        columnLayout.setColumnData((Widget)fourthViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(200));
        fourthViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                EStructuralFeature containmentFeature = ConfigurePastePage.this.getContainmentFeature(element);
                if (containmentFeature != null) {
                    return ConfigurePastePage.this.containmentFeatureLabelProvider.getImage((Object)containmentFeature);
                }
                return null;
            }
        });
        fourthViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.treeViewer){

            protected void setValue(Object element, Object value) {
                if (value instanceof EStructuralFeature && ConfigurePastePage.this.canEditPasteConfiguration(element)) {
                    PasteEObjectConfiguration pasteConfiguration = ConfigurePastePage.this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element);
                    if (pasteConfiguration != null) {
                        if (ConfigurePastePage.this.pasteConfigurations.get(element) == null) {
                            ConfigurePastePage.this.pasteConfigurations.put((ITreeItemAxis)element, (PasteEObjectConfiguration)EcoreUtil.copy((EObject)pasteConfiguration));
                        }
                        ConfigurePastePage.this.pasteConfigurations.get(element).setPasteElementContainementFeature((EStructuralFeature)value);
                    }
                    ConfigurePastePage.this.treeViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return ConfigurePastePage.this.getContainmentFeatureAsString(element);
            }

            protected CellEditor getCellEditor(final Object element) {
                return new ExtendedDialogCellEditor((Composite)tree, (ILabelProvider)new LabelProvider()){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        TreeSelectorDialog dialog = new TreeSelectorDialog(cellEditorWindow.getShell()){

                            protected void initViewerAndProvider() {
                                super.initViewerAndProvider();
                                this.getViewer().setComparator(new ViewerComparator((Comparator)new StringComparator()));
                            }
                        };
                        dialog.setTitle(Messages.ConfigurePastePage_fourthColumnTitle);
                        Object treeContentProvider = null;
                        treeContentProvider = element instanceof IdTreeItemAxis && ((IdTreeItemAxis)element).getChildren().isEmpty() && Integer.parseInt(((IdTreeItemAxis)element).getElement()) == 0 || element instanceof ITreeItemAxis && ((ITreeItemAxis)element).getParent() instanceof IdTreeItemAxis && Integer.parseInt(((IdTreeItemAxis)((ITreeItemAxis)element).getParent()).getElement()) == 0 ? new EncapsulatedContentProvider((IStructuredContentProvider)new RowContainmentFeatureContentProvider((this).ConfigurePastePage.this.nattableManager.getTable(), (this).ConfigurePastePage.this.nattableManager.getTable().getContext().eClass())) : new ProviderBasedBrowseStrategy((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)(this).ConfigurePastePage.this.containmentFeatureContentProvider));
                        dialog.setContentProvider((ITreeContentProvider)treeContentProvider);
                        dialog.setLabelProvider((this).ConfigurePastePage.this.containmentFeatureLabelProvider);
                        if (dialog.open() == 0) {
                            Object[] result = dialog.getResult();
                            if (result.length == 0) {
                                return null;
                            }
                            if (result[0] instanceof EObject) {
                                return result[0];
                            }
                        }
                        return null;
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return ConfigurePastePage.this.canEditPasteConfiguration(element);
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new ITreeItemContentProvider(){

            @Override
            public boolean hasChildren(Object parent) {
                if (parent instanceof ITreeItemAxis && CategoriesWizardUtils.isCategoryItem((ITreeItemAxis)parent)) {
                    return false;
                }
                return super.hasChildren(parent);
            }
        });
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (event.index == 1) {
                    PasteEObjectConfiguration pasteConfiguration;
                    Image trailingImage = null;
                    if (item.getData() instanceof ITreeItemAxis && ConfigurePastePage.this.canEditPasteConfiguration(item.getData()) && (pasteConfiguration = ConfigurePastePage.this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)item.getData())) != null) {
                        Image image = trailingImage = pasteConfiguration.isDetachedMode() ? CHECKED : UNCHECKED;
                    }
                    if (trailingImage != null) {
                        int itemWidth = tree.getColumn(event.index).getWidth();
                        int imageWidth = trailingImage.getBounds().width;
                        int x = event.x + (itemWidth - imageWidth) / 2;
                        int itemHeight = tree.getItemHeight();
                        int imageHeight = trailingImage.getBounds().height;
                        int y = event.y + (itemHeight - imageHeight) / 2;
                        event.gc.drawImage(trailingImage, x, y);
                    }
                } else if (event.index == 2 || event.index == 3) {
                    String text = null;
                    if (2 == event.index) {
                        Object result = ConfigurePastePage.this.getPastedElementId(item.getData());
                        text = result != null ? (String)result : "";
                    } else if (3 == event.index) {
                        text = ConfigurePastePage.this.getContainmentFeatureAsString(item.getData());
                    }
                    Image image = item.getImage(event.index);
                    int x = event.x + 2;
                    int yOffset = 0;
                    if (event.index == 1) {
                        Point size = event.gc.textExtent(text);
                        yOffset = Math.max(0, (event.height - size.y) / 2);
                    }
                    int y = event.y + yOffset;
                    if (image != null) {
                        x += image.getBounds().width + 2;
                    }
                    event.gc.drawText(text, x, y, true);
                }
            }
        });
        this.setControl((Control)treeViewerComposite);
    }

    protected boolean canEditPasteConfiguration(Object element) {
        return element instanceof IdTreeItemAxis && ((IdTreeItemAxis)element).getChildren().isEmpty() && Integer.parseInt(((IdTreeItemAxis)element).getElement()) == 0 || element instanceof EStructuralFeatureAxis && element instanceof ITreeItemAxis;
    }

    protected Object getDetachedMode(Object element) {
        PasteEObjectConfiguration pasteConfiguration;
        Boolean result = null;
        if (this.canEditPasteConfiguration(element) && (pasteConfiguration = this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element)) != null) {
            result = pasteConfiguration.isDetachedMode();
        }
        return result;
    }

    protected Object getPastedElementId(Object element) {
        PasteEObjectConfiguration pasteConfiguration;
        String result = null;
        if (this.canEditPasteConfiguration(element) && (pasteConfiguration = this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element)) != null) {
            String pastedElementId = pasteConfiguration.getPastedElementId();
            if (pastedElementId == null || pastedElementId.isEmpty()) {
                pastedElementId = UNDEFINED;
            }
            result = pastedElementId;
        }
        return result;
    }

    protected EStructuralFeature getContainmentFeature(Object element) {
        EStructuralFeature pasteElementContainementFeature;
        PasteEObjectConfiguration pasteConfiguration;
        EStructuralFeature result = null;
        if (this.canEditPasteConfiguration(element) && (pasteConfiguration = this.getPasteConfigurationFromTreeItemAxis((ITreeItemAxis)element)) != null && (pasteElementContainementFeature = pasteConfiguration.getPasteElementContainementFeature()) != null) {
            result = pasteElementContainementFeature;
        }
        return result;
    }

    protected String getContainmentFeatureAsString(Object element) {
        String result = "";
        if (this.canEditPasteConfiguration(element)) {
            EStructuralFeature containmentFeature = this.getContainmentFeature(element);
            result = containmentFeature != null ? containmentFeature.getName() : UNDEFINED;
        }
        return result;
    }

    protected TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    protected PasteEObjectConfiguration getPasteConfigurationFromTreeItemAxis(ITreeItemAxis treeItemAxis) {
        PasteEObjectConfiguration pasteConfiguration = null;
        if (this.pasteConfigurations.get(treeItemAxis) != null) {
            pasteConfiguration = this.pasteConfigurations.get(treeItemAxis);
        } else {
            pasteConfiguration = this.getChildrenPasteConfiguration(treeItemAxis);
            if (pasteConfiguration == null) {
                int depth = -1;
                boolean hasNoTreeFillingFirstDepth = false;
                String category = null;
                if (treeItemAxis instanceof EStructuralFeatureAxis && treeItemAxis.getParent() instanceof IdTreeItemAxis) {
                    depth = Integer.parseInt(((IdTreeItemAxis)treeItemAxis.getParent()).getElement());
                    category = ((EStructuralFeatureAxis)treeItemAxis).getElement().getName();
                } else if (treeItemAxis instanceof IdTreeItemAxis) {
                    depth = Integer.parseInt(((IdTreeItemAxis)treeItemAxis).getElement());
                    hasNoTreeFillingFirstDepth = true;
                }
                if (-1 != depth) {
                    pasteConfiguration = this.getPasteConfigurationsFor(this.nattableManager.getTable(), depth, category, hasNoTreeFillingFirstDepth);
                }
            }
        }
        if (pasteConfiguration == null) {
            pasteConfiguration = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        return pasteConfiguration;
    }

    protected PasteEObjectConfiguration getChildrenPasteConfiguration(ITreeItemAxis treeItemAxis) {
        PasteEObjectConfiguration result = null;
        if (!treeItemAxis.getChildren().isEmpty()) {
            for (ITreeItemAxis childItemAxis : treeItemAxis.getChildren()) {
                if (!(childItemAxis instanceof EObjectTreeItemAxis) || !(childItemAxis.getElement() instanceof PasteEObjectConfiguration)) continue;
                result = (PasteEObjectConfiguration)childItemAxis.getElement();
            }
        }
        return result;
    }

    protected PasteEObjectConfiguration getPasteConfigurationsFor(Table table, int depth, String categoryName, boolean hasNoTreeFillingFirstDepth) {
        PasteEObjectConfiguration result = null;
        if (hasNoTreeFillingFirstDepth) {
            LocalTableHeaderAxisConfiguration conf = table.getLocalRowHeaderAxisConfiguration();
            if (conf == null) {
                conf = table.getTableConfiguration().getRowHeaderAxisConfiguration();
            }
            List<TreeFillingConfiguration> filling = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(table, depth);
            ArrayList<PasteEObjectConfiguration> referencedPasteConf = new ArrayList<PasteEObjectConfiguration>();
            for (TreeFillingConfiguration tmp : filling) {
                if (tmp.getPasteConfiguration() == null) continue;
                referencedPasteConf.add(tmp.getPasteConfiguration());
            }
            Iterator axisConfIterator = conf.getOwnedAxisConfigurations().iterator();
            while (result == null && axisConfIterator.hasNext()) {
                IAxisConfiguration axisConf = (IAxisConfiguration)axisConfIterator.next();
                if (!(axisConf instanceof PasteEObjectConfiguration) || referencedPasteConf.contains(axisConf)) continue;
                result = (PasteEObjectConfiguration)axisConf;
            }
        } else {
            Iterator<TreeFillingConfiguration> treeFillingConfIterator = FillingConfigurationUtils.getAllTreeFillingConfiguration(table).iterator();
            while (result == null && treeFillingConfIterator.hasNext()) {
                Object element;
                TreeFillingConfiguration curr = treeFillingConfIterator.next();
                if (curr.getDepth() != depth) continue;
                if (categoryName == null || categoryName.isEmpty()) {
                    result = curr.getPasteConfiguration();
                    continue;
                }
                String featureName = curr.getAxisUsedAsAxisProvider().getAlias();
                if ((featureName == null || featureName.isEmpty()) && (element = curr.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                    featureName = ((EStructuralFeature)element).getName();
                }
                if (!categoryName.equals(featureName)) continue;
                result = curr.getPasteConfiguration();
            }
        }
        return result;
    }

    public Map<ITreeItemAxis, PasteEObjectConfiguration> getPasteConfigurations() {
        return this.pasteConfigurations;
    }
}

