/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.util.List;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;

public class PackageExplorerUtils {
    private static final String PACKAGE_EXPLORER_VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";

    public static final IPackagesViewPart openPackageExplorerView() throws PartInitException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPackagesViewPart pack = null;
        IViewPart packageExplorer = activeWorkbenchWindow.getActivePage().showView(PACKAGE_EXPLORER_VIEW_ID);
        pack = (IPackagesViewPart)packageExplorer;
        Assert.assertNotNull((Object)pack);
        pack.setFocus();
        return pack;
    }

    public static final void setSelectionInPackageExplorerView(IPackagesViewPart packageExplorer, IStructuredSelection newSelection) {
        packageExplorer.getTreeViewer().expandAll();
        packageExplorer.getTreeViewer().setSelection((ISelection)newSelection);
        IStructuredSelection currentSelection = (IStructuredSelection)packageExplorer.getTreeViewer().getSelection();
        Assert.assertEquals((String)"Package Explorer: The current selection is not the same as the wanted selection", (Object)currentSelection.toList(), (Object)newSelection.toList());
        currentSelection = PackageExplorerUtils.getCurrentSelectionInPackageExplorerView();
        Assert.assertEquals((String)"Package Explorer: The SelectionService doesn't return the wanted selection", (Object)currentSelection.toList(), (Object)newSelection.toList());
    }

    public static final IStructuredSelection getCurrentSelectionInPackageExplorerView() {
        return (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection(PACKAGE_EXPLORER_VIEW_ID);
    }

    public static final List<?> getCurrentSelectionAsListInPackageExplorerView() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection(PACKAGE_EXPLORER_VIEW_ID);
        List list = selection.toList();
        return list;
    }
}

