/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.xtend.ui.handlers;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.gmf.codegen.util.PapyrusGMFExtensionMigrator;
import org.eclipse.papyrus.gmf.codegen.xtend.ui.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class MigrateGMFGenFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof IFile) {
            Object[] roots;
            IFile selectedFile = (IFile)selectedElement;
            String selectedFilePath = selectedFile.getFullPath().toString();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource inputResource = resourceSet.getResource(URI.createURI((String)selectedFilePath), true);
            PapyrusGMFExtensionMigrator migrator = new PapyrusGMFExtensionMigrator();
            Object[] objectArray = roots = inputResource.getContents().toArray();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                Object root = objectArray[n2];
                migrator.migrate((EObject)root);
                ++n2;
            }
            if (inputResource.getContents().size() == 1) {
                EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource("genextension_migration");
                inputResource.getContents().add((Object)annotation);
            }
            try {
                inputResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error on file conversion", (String)e.getMessage());
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.gmf.codegen.xtend.ui", "Error on file conversion", (Throwable)e));
            }
        }
        return null;
    }
}

