/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.ui.properties.widgets;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.emf.types.ui.properties.messages.Messages;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class FeatureNameValueEditor
extends StringEditor {
    private static final String BROWSE_ICON = "/icons/browse_12x12.gif";
    private Button button = null;
    private EClass sourceEClass;

    public FeatureNameValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, null, 8);
        this.button.setImage(Activator.getDefault().getImage(BROWSE_ICON));
        this.button.setToolTipText(Messages.FeatureNameValueEditor_browseButtonTooltip);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureNameValueEditor.this.handleManageBrowseButtonPressed();
            }
        });
    }

    protected void handleManageBrowseButtonPressed() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getParent().getShell());
        dialog.setContentProvider((ITreeContentProvider)new FeatureContentProvider());
        dialog.setLabelProvider((ILabelProvider)new FeatureStyledLabelProvider());
        dialog.setTitle(Messages.FeatureNameValueEditor_dialogTitle);
        dialog.setMessage(Messages.FeatureNameValueEditor_dialogMessage);
        dialog.setInput((Object)this.sourceEClass);
        if (dialog.open() == 0) {
            Object[] values = dialog.getResult();
            if (1 != values.length) {
                Status status = new Status(4, "org.eclipse.papyrus.infra.widgets", "");
                this.updateStatus((IStatus)status);
            } else if (values[0] instanceof EStructuralFeature) {
                this.setValue(((EStructuralFeature)values[0]).getName());
                this.notifyChange();
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.button.setEnabled(!readOnly);
    }

    public void setSourceEClass(EClass sourceEClass) {
        this.sourceEClass = sourceEClass;
    }

    protected class FeatureContentProvider
    extends FilteredContentProvider {
        protected EClass currentEClass;

        protected FeatureContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
            if (inputElement instanceof EClass) {
                this.currentEClass = (EClass)inputElement;
                for (EStructuralFeature feature : this.currentEClass.getEAllStructuralFeatures()) {
                    EReference reference;
                    if (feature instanceof EReference && ((reference = (EReference)feature).isContainer() || reference.isContainment() || reference.isMany()) || feature.isDerived() || !feature.isChangeable()) continue;
                    features.add(feature);
                }
            }
            return features.toArray();
        }

        public boolean isFlat() {
            return true;
        }
    }

    public class FeatureLabelProvider
    extends EMFLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public String getText(Object element) {
            String text = null;
            if (element instanceof EStructuralFeature) {
                text = String.valueOf(((EStructuralFeature)element).getName()) + ": " + ((EStructuralFeature)element).getEType().getName();
            }
            return text != null ? text : super.getText(element);
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString(this.getText(element));
            if (element instanceof EStructuralFeature) {
                int nameLenght = ((EStructuralFeature)element).getName().length();
                styledString.setStyle(nameLenght, styledString.length() - nameLenght, StyledString.QUALIFIER_STYLER);
            }
            return styledString;
        }
    }

    public class FeatureStyledLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        public FeatureStyledLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FeatureLabelProvider());
        }

        public String getText(Object element) {
            return this.getStyledStringProvider().getStyledText(element).getString();
        }
    }
}

