/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.uml.Package;

public class SelectOutputPage
extends AbstractCreateContextPage
implements Listener {
    private CheckboxTableViewer viewer;
    protected CCombo combo;
    private Table table;

    public SelectOutputPage() {
        super(Messages.SelectOutputPage_0);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        this.combo = new CCombo(root, 2048);
        this.setDescription(Messages.SelectOutputPage_1);
        this.combo.add(Messages.SelectOutputPage_2);
        this.combo.add(Messages.SelectOutputPage_3);
        this.combo.add(Messages.SelectOutputPage_4);
        this.combo.setEditable(false);
        this.combo.setBackground(new Color((Device)this.combo.getDisplay(), 255, 255, 255));
        this.combo.select(0);
        this.combo.addListener(13, (Listener)this);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)root);
        this.viewer = new CheckboxTableViewer(root, 67846);
        this.table = this.viewer.getTable();
        this.table.setVisible(false);
        this.table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EPackage) {
                    EPackage p = (EPackage)element;
                    return "Ecore package Name : " + p.getName();
                }
                if (element instanceof Package) {
                    Package p = (Package)element;
                    return "Profile name : " + p.getName();
                }
                return null;
            }
        });
        this.viewer.setInput(new Object());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectOutputPage.this.UpdateButton();
            }
        });
    }

    public void handleEvent(Event event) {
        if (this.combo.getSelectionIndex() != 0) {
            this.table.setVisible(true);
        } else {
            this.table.setVisible(false);
        }
        this.canFlipToNextPage();
        super.getContainer().updateButtons();
    }

    public void setSelectorData() {
        this.viewer.setInput(this.getWizard().generator.getExternalReference());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setSelectorData();
        }
    }

    public IWizardPage getNextPage() {
        int selection = this.combo.getSelectionIndex();
        this.getWizard().selectFieldsPage.setTargetURI(this.getListPackage(selection));
        this.getWizard().generatorPage.setStrategy(selection);
        return this.getWizard().selectFieldsPage;
    }

    public List<URI> getListPackage(int selection) {
        ArrayList<URI> list = new ArrayList<URI>();
        if (selection == 0) {
            list.add(this.getWizard().generatorPage.oldURI);
        } else {
            Object[] objectArray = this.viewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String result;
                String temp;
                EPackage p;
                Object o = objectArray[n2];
                if (o instanceof EPackage) {
                    p = (EPackage)o;
                    if (selection == 1) {
                        list.add(this.getWizard().generatorPage.oldURI);
                    } else {
                        temp = this.getWizard().generatorPage.oldURI.toString();
                        temp = temp.substring(0, temp.lastIndexOf("/"));
                        result = String.valueOf(temp) + "/" + p.getName() + ".ctx";
                        list.add(URI.createURI((String)result, (boolean)true));
                    }
                    this.getWizard().generator.addCheckElement(o);
                }
                if (o instanceof Package) {
                    p = (Package)o;
                    if (selection == 1) {
                        list.add(this.getWizard().generatorPage.oldURI);
                    } else {
                        temp = this.getWizard().generatorPage.oldURI.toString();
                        temp = temp.substring(0, temp.lastIndexOf("/"));
                        result = String.valueOf(temp) + "/" + p.getName() + ".ctx";
                        list.add(URI.createURI((String)result, (boolean)true));
                    }
                    this.getWizard().generator.addCheckElement(o);
                }
                ++n2;
            }
        }
        return list;
    }

    public boolean canFlipToNextPage() {
        return this.combo.getSelectionIndex() == 0 || this.viewer.getCheckedElements().length != 0;
    }

    public void UpdateButton() {
        this.canFlipToNextPage();
        super.getContainer().updateButtons();
    }
}

